/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.NameNotFoundException;
import javax.jmi.reflect.ConstraintViolationException;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementPartKind;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.mdr.handlers.InstanceHandler;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.DeferredObject;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaPackageClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.UsageFinder;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public abstract class JavaPackageImpl
extends InstanceHandler
implements JavaPackage {
    String name = null;
    private final boolean isProxy;
    private final SubPackagesCollection subpackages;
    private final ResourcesCollection resources;
    private final HashSet representedPackages;
    private boolean simpleDelete = false;
    private boolean isValid = true;

    public JavaPackageImpl(StorableObject s) {
        super(s);
        if (s instanceof DeferredObject) {
            this.subpackages = new SubPackagesCollection();
            this.resources = new ResourcesCollection();
            this.representedPackages = new HashSet();
            this.isProxy = true;
        } else {
            this.subpackages = null;
            this.resources = null;
            this.representedPackages = null;
            this.isProxy = false;
        }
    }

    public String getName() {
        if (this.isProxy) {
            return this.name;
        }
        return this.super_getName();
    }

    protected abstract String super_getName();

    public void setName(String name) {
        ModelElement nameAttr = null;
        try {
            nameAttr = ((MofClass)this.refMetaObject()).lookupElementExtended("name");
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        throw new ConstraintViolationException((Object)this, (RefObject)nameAttr, "Name attribute is readonly.");
    }

    public Collection getSubPackages() {
        return this.isProxy ? this.subpackages : this.super_getSubPackages();
    }

    public Collection getResources() {
        return this.isProxy ? this.resources : this.super_getResources();
    }

    public Resource getResource() {
        return null;
    }

    protected abstract Collection super_getSubPackages();

    protected abstract Collection super_getResources();

    void addSubPackage(JavaPackageImpl pkg) {
        if (this.isProxy) {
            try {
                ((StorableObject)pkg._getDelegate()).setComposite(this._getDelegate(), null, null);
            }
            catch (StorageException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            this.subpackages.addSubPackage(pkg);
        } else {
            this.super_getSubPackages().add(pkg);
        }
    }

    void removeRealPackage(JavaPackageImpl real) {
        if (!this.isProxy) {
            throw new IllegalStateException();
        }
        this.representedPackages.remove((Object)real);
        if (this.representedPackages.isEmpty()) {
            this.refDelete();
        }
    }

    void addRealPackage(JavaPackageImpl real) {
        if (!this.isProxy) {
            throw new IllegalStateException();
        }
        if (!this.representedPackages.add(real)) {
            throw new IllegalStateException();
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void _delete() {
        if (!this.isProxy) {
            if (!this.simpleDelete) {
                ((JavaPackageClassImpl)this.refClass()).removeRealPackage(this);
            }
            super._delete();
        } else {
            JavaPackageClassImpl.removePackage(this);
            Iterator it = this.representedPackages.iterator();
            while (it.hasNext()) {
                JavaPackageImpl pck = (JavaPackageImpl)((Object)it.next());
                pck.delete();
            }
            this.representedPackages.clear();
            JavaPackageImpl parent = (JavaPackageImpl)super._immediateComposite();
            if (parent != null) {
                parent.subpackages.removeSubPackage(this);
            }
        }
        this.isValid = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete() {
        this.simpleDelete = true;
        try {
            this.refDelete();
        }
        finally {
            this.simpleDelete = false;
        }
    }

    protected RefFeatured _immediateComposite() {
        JavaPackage composite = (JavaPackage)super._immediateComposite();
        return composite == null ? null : ((JavaPackageClassImpl)this.refClass()).resolvePackage(composite.getName(), true);
    }

    protected RefFeatured _outermostComposite() {
        JavaPackage composite = (JavaPackage)super._outermostComposite();
        return ((JavaPackageClassImpl)this.refClass()).resolvePackage(composite.getName(), true);
    }

    public Collection getReferences() {
        Resource[] res = this.findReferencedResources();
        UsageFinder finder = new UsageFinder((NamedElement)this);
        return finder.getUsers(res);
    }

    private Resource[] findReferencedResources() {
        StringTokenizer tokenizer = new StringTokenizer(this.getName(), ".");
        String part = tokenizer.nextToken();
        ArrayList<Object> result = new ArrayList<Object>(Arrays.asList((Object[])ClassIndex.findResourcesForIdentifier(part)));
        while (tokenizer.hasMoreTokens()) {
            part = tokenizer.nextToken();
            result.retainAll(Arrays.asList((Object[])ClassIndex.findResourcesForIdentifier(part)));
        }
        return result.toArray(new Resource[result.size()]);
    }

    boolean shouldInclude() {
        return !this.getResources().isEmpty() || !this.getSubPackages().isEmpty();
    }

    private void handleInvalid(InvalidObjectException e) {
        System.err.println("Invalid represented package for: " + this.getName() + " toString: " + this.toString());
        System.err.println("...number of represented packages: " + this.representedPackages.size());
        System.err.println("...resolvePackage(getName()) returns " + ((JavaPackageClassImpl)this.refClass()).resolvePackage(this.getName(), true));
        throw e;
    }

    public List getChildren() {
        ArrayList result = new ArrayList(this.getSubPackages());
        result.addAll(this.getResources());
        return result;
    }

    public void replaceChild(Element oldElement, Element newElement) {
        throw new UnsupportedOperationException();
    }

    public int getStartOffset() {
        throw new UnsupportedOperationException();
    }

    public int getEndOffset() {
        throw new UnsupportedOperationException();
    }

    public int getPartStartOffset(ElementPartKind part) {
        throw new UnsupportedOperationException();
    }

    public int getPartEndOffset(ElementPartKind part) {
        throw new UnsupportedOperationException();
    }

    public Element duplicate() {
        throw new UnsupportedOperationException("The operation is intentionally unsupported at this element.");
    }

    private class ResourcesCollection
    extends AbstractCollection {
        private ResourcesCollection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            JavaPackageImpl.this._lock(false);
            try {
                int size = 0;
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    ++size;
                    it.next();
                }
                int n = size;
                return n;
            }
            finally {
                JavaPackageImpl.this._unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            JavaPackageImpl.this._lock(false);
            try {
                boolean bl = !this.iterator().hasNext();
                return bl;
            }
            finally {
                JavaPackageImpl.this._unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object o) {
            JavaPackageImpl.this._lock(false);
            try {
                Set roots = this.createRootsSet();
                Iterator it = JavaPackageImpl.this.representedPackages.iterator();
                boolean contains = false;
                while (it.hasNext() && !contains) {
                    JavaPackage pkg = (JavaPackage)it.next();
                    try {
                        if (!roots.contains(pkg.refImmediatePackage())) continue;
                        contains = pkg.getResources().contains(o);
                    }
                    catch (InvalidObjectException e) {
                        JavaPackageImpl.this.handleInvalid(e);
                    }
                }
                boolean bl = contains;
                return bl;
            }
            finally {
                JavaPackageImpl.this._unlock();
            }
        }

        private Set createRootsSet() {
            ClassPath cp = JavaMetamodel.getManager().getClassPath();
            FileObject[] fo = cp.getRoots();
            HashSet<JavaModelPackage> roots = new HashSet<JavaModelPackage>(fo.length);
            for (int i = 0; i < fo.length; ++i) {
                roots.add(JavaMetamodel.getManager().getJavaExtent(fo[i]));
            }
            return roots;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator iterator() {
            JavaPackageImpl.this._lock(false);
            try {
                Iterator iterator = new Iterator(){
                    private Iterator packages;
                    private Set roots;
                    private Iterator resources;
                    {
                        this.packages = JavaPackageImpl.this.representedPackages.iterator();
                        this.roots = ResourcesCollection.this.createRootsSet();
                        this.resources = null;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public boolean hasNext() {
                        JavaPackageImpl.this._lock(false);
                        try {
                            while ((this.resources == null || !this.resources.hasNext()) && this.packages.hasNext()) {
                                JavaPackage pkg = (JavaPackage)this.packages.next();
                                try {
                                    if (!this.roots.contains(pkg.refImmediatePackage())) continue;
                                    this.resources = pkg.getResources().iterator();
                                }
                                catch (InvalidObjectException e) {
                                    JavaPackageImpl.this.handleInvalid(e);
                                }
                            }
                            boolean bl = this.resources != null && this.resources.hasNext();
                            return bl;
                        }
                        finally {
                            JavaPackageImpl.this._unlock();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object next() {
                        JavaPackageImpl.this._lock(false);
                        try {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            Object e = this.resources.next();
                            return e;
                        }
                        finally {
                            JavaPackageImpl.this._unlock();
                        }
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                return iterator;
            }
            finally {
                JavaPackageImpl.this._unlock();
            }
        }

        boolean isReallyEmpty() {
            Iterator it = JavaPackageImpl.this.representedPackages.iterator();
            while (it.hasNext()) {
                try {
                    if (((JavaPackage)it.next()).getResources().isEmpty()) continue;
                    return false;
                }
                catch (InvalidObjectException e) {
                    JavaPackageImpl.this.handleInvalid(e);
                }
            }
            return true;
        }
    }

    private static class SubPackagesCollection
    extends AbstractCollection {
        private HashSet subpackages = new HashSet();

        private SubPackagesCollection() {
        }

        private void _lock(boolean write) {
            JavaMetamodel.getDefaultRepository().beginTrans(write);
        }

        private void _unlock() {
            JavaMetamodel.getDefaultRepository().endTrans(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            this._lock(false);
            try {
                int size = 0;
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    ++size;
                    it.next();
                }
                int n = size;
                return n;
            }
            finally {
                this._unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            this._lock(false);
            try {
                boolean bl = !this.iterator().hasNext();
                return bl;
            }
            finally {
                this._unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object o) {
            this._lock(false);
            try {
                boolean bl = this.subpackages.contains(o) && ((JavaPackageImpl)((Object)o)).shouldInclude();
                return bl;
            }
            finally {
                this._unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator iterator() {
            this._lock(false);
            try {
                Iterator iterator = new Iterator(){
                    private JavaPackage next = null;
                    private Iterator iterator = SubPackagesCollection.access$200(SubPackagesCollection.this).iterator();

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean hasNext() {
                        SubPackagesCollection.this._lock(false);
                        try {
                            while (this.iterator.hasNext() && this.next == null) {
                                JavaPackageImpl temp = (JavaPackageImpl)((Object)this.iterator.next());
                                if (temp.subpackages.isReallyEmpty() && temp.resources.isReallyEmpty()) {
                                    this.iterator.remove();
                                    temp.refDelete();
                                    continue;
                                }
                                if (!temp.shouldInclude()) continue;
                                this.next = temp;
                            }
                            boolean bl = this.next != null;
                            return bl;
                        }
                        finally {
                            SubPackagesCollection.this._unlock();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object next() {
                        SubPackagesCollection.this._lock(false);
                        try {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            JavaPackage result = this.next;
                            this.next = null;
                            JavaPackage javaPackage = result;
                            return javaPackage;
                        }
                        finally {
                            SubPackagesCollection.this._unlock();
                        }
                    }

                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                return iterator;
            }
            finally {
                this._unlock();
            }
        }

        void addSubPackage(JavaPackage pkg) {
            this.subpackages.add(pkg);
        }

        void removeSubPackage(JavaPackage pkg) {
            this.subpackages.remove(pkg);
        }

        boolean isReallyEmpty() {
            return this.subpackages.isEmpty();
        }

        static /* synthetic */ HashSet access$200(SubPackagesCollection x0) {
            return x0.subpackages;
        }
    }
}

