/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui;

import java.awt.Component;
import java.awt.Image;
import java.awt.Panel;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.j2seproject.UpdateHelper;
import org.netbeans.modules.java.j2seproject.ui.RemoveClassPathRootAction;
import org.netbeans.modules.java.j2seproject.ui.ShowJavadocAction;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

class ProjectNode
extends AbstractNode {
    private static final String PROJECT_ICON = "org/netbeans/modules/java/j2seproject/ui/resources/projectDependencies.gif";
    private static final Component CONVERTOR_COMPONENT = new Panel();
    private final AntArtifact antArtifact;
    private final URI artifactLocation;
    private Image cachedIcon;
    static /* synthetic */ Class class$org$netbeans$api$project$Project;

    ProjectNode(AntArtifact antArtifact, URI artifactLocation, UpdateHelper helper, ReferenceHelper refHelper, String classPathId, String entryId) {
        super(Children.LEAF, ProjectNode.createLookup(antArtifact, artifactLocation, helper, refHelper, classPathId, entryId));
        this.antArtifact = antArtifact;
        this.artifactLocation = artifactLocation;
    }

    public String getDisplayName() {
        ProjectInformation info = this.getProjectInformation();
        if (info != null) {
            return MessageFormat.format(NbBundle.getMessage((Class)ProjectNode.class, (String)"TXT_ProjectArtifactFormat"), info.getDisplayName(), this.artifactLocation.toString());
        }
        return NbBundle.getMessage((Class)ProjectNode.class, (String)"TXT_UnknownProjectName");
    }

    public String getName() {
        return this.getDisplayName();
    }

    public Image getIcon(int type) {
        if (this.cachedIcon == null) {
            ProjectInformation info = this.getProjectInformation();
            if (info != null) {
                Icon icon = info.getIcon();
                if (icon instanceof ImageIcon) {
                    this.cachedIcon = ((ImageIcon)icon).getImage();
                } else {
                    int height = icon.getIconHeight();
                    int width = icon.getIconWidth();
                    this.cachedIcon = new BufferedImage(width, height, 2);
                    icon.paintIcon(CONVERTOR_COMPONENT, this.cachedIcon.getGraphics(), 0, 0);
                }
            } else {
                this.cachedIcon = Utilities.loadImage((String)PROJECT_ICON);
            }
        }
        return this.cachedIcon;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public boolean canCopy() {
        return false;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get((Class)OpenProjectAction.class), SystemAction.get((Class)ShowJavadocAction.class), SystemAction.get((Class)RemoveClassPathRootAction.class)};
    }

    public Action getPreferredAction() {
        return this.getActions(false)[0];
    }

    private ProjectInformation getProjectInformation() {
        Project p = this.antArtifact.getProject();
        if (p != null) {
            return ProjectUtils.getInformation((Project)p);
        }
        return null;
    }

    private static Lookup createLookup(AntArtifact antArtifact, URI artifactLocation, UpdateHelper helper, ReferenceHelper refHelper, String classPathId, String entryId) {
        Object[] content;
        Project p = antArtifact.getProject();
        if (p == null) {
            content = new Object[1];
        } else {
            content = new Object[3];
            content[1] = new JavadocProvider(antArtifact, artifactLocation);
            content[2] = p;
        }
        content[0] = new Removable(helper, refHelper, classPathId, entryId);
        Lookup lkp = Lookups.fixed((Object[])content);
        return lkp;
    }

    private static class Removable
    implements RemoveClassPathRootAction.Removable {
        private final UpdateHelper helper;
        private final ReferenceHelper refHelper;
        private final String classPathId;
        private final String entryId;

        Removable(UpdateHelper helper, ReferenceHelper refHelper, String classPathId, String entryId) {
            this.helper = helper;
            this.refHelper = refHelper;
            this.classPathId = classPathId;
            this.entryId = entryId;
        }

        public boolean canRemove() {
            EditableProperties props = this.helper.getProperties("nbproject/project.properties");
            return props.getProperty(this.classPathId) != null;
        }

        public void remove() {
            ProjectManager.mutex().writeAccess(new Runnable(){
                static final /* synthetic */ boolean $assertionsDisabled;

                public void run() {
                    EditableProperties props = Removable.this.helper.getProperties("nbproject/project.properties");
                    String cp = props.getProperty(Removable.this.classPathId);
                    if (cp != null) {
                        String[] entries = PropertyUtils.tokenizePath((String)cp);
                        ArrayList<String> result = new ArrayList<String>();
                        for (int i = 0; i < entries.length; ++i) {
                            if (Removable.this.entryId.equals(J2SEProjectProperties.getAntPropertyName(entries[i]))) continue;
                            int size = result.size();
                            if (size > 0) {
                                result.set(size - 1, (String)result.get(size - 1) + ':');
                            }
                            result.add(entries[i]);
                        }
                        props.setProperty(Removable.this.classPathId, result.toArray(new String[result.size()]));
                        Removable.this.helper.putProperties("nbproject/project.properties", props);
                        String ref = "${" + Removable.this.entryId + "}";
                        if (!RemoveClassPathRootAction.isReferenced(new EditableProperties[]{props, Removable.this.helper.getProperties("nbproject/private/private.properties")}, ref)) {
                            Removable.this.refHelper.destroyReference(ref);
                        }
                        Project project = FileOwnerQuery.getOwner((FileObject)Removable.this.helper.getAntProjectHelper().getProjectDirectory());
                        if (!$assertionsDisabled && project == null) {
                            throw new AssertionError();
                        }
                        try {
                            ProjectManager.getDefault().saveProject(project);
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().notify((Throwable)ioe);
                        }
                    }
                }

                static {
                    $assertionsDisabled = !(class$org$netbeans$modules$java$j2seproject$ui$ProjectNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$ProjectNode = ProjectNode.class$("org.netbeans.modules.java.j2seproject.ui.ProjectNode")) : class$org$netbeans$modules$java$j2seproject$ui$ProjectNode).desiredAssertionStatus();
                }
            });
        }
    }

    private static class OpenProjectAction
    extends NodeAction {
        private OpenProjectAction() {
        }

        protected void performAction(Node[] activatedNodes) {
            Project[] projects = new Project[activatedNodes.length];
            for (int i = 0; i < projects.length; ++i) {
                projects[i] = (Project)activatedNodes[i].getLookup().lookup(class$org$netbeans$api$project$Project == null ? ProjectNode.class$("org.netbeans.api.project.Project") : class$org$netbeans$api$project$Project);
            }
            OpenProjects.getDefault().open(projects, false);
        }

        protected boolean enable(Node[] activatedNodes) {
            List<Project> openedProjects = Arrays.asList(OpenProjects.getDefault().getOpenProjects());
            for (int i = 0; i < activatedNodes.length; ++i) {
                Project p = (Project)activatedNodes[i].getLookup().lookup(class$org$netbeans$api$project$Project == null ? ProjectNode.class$("org.netbeans.api.project.Project") : class$org$netbeans$api$project$Project);
                if (p == null) {
                    return false;
                }
                if (!openedProjects.contains(p)) continue;
                return false;
            }
            return true;
        }

        public String getName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$ProjectNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$ProjectNode = ProjectNode.class$("org.netbeans.modules.java.j2seproject.ui.ProjectNode")) : class$org$netbeans$modules$java$j2seproject$ui$ProjectNode), (String)"CTL_OpenProject");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$java$j2seproject$ui$ProjectNode$OpenProjectAction == null ? (class$org$netbeans$modules$java$j2seproject$ui$ProjectNode$OpenProjectAction = ProjectNode.class$("org.netbeans.modules.java.j2seproject.ui.ProjectNode$OpenProjectAction")) : class$org$netbeans$modules$java$j2seproject$ui$ProjectNode$OpenProjectAction);
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider {
        private final AntArtifact antArtifact;
        private final URI artifactLocation;

        JavadocProvider(AntArtifact antArtifact, URI artifactLocation) {
            this.antArtifact = antArtifact;
            this.artifactLocation = artifactLocation;
        }

        public boolean hasJavadoc() {
            return this.findJavadoc().size() > 0;
        }

        public void showJavadoc() {
            Set us = this.findJavadoc();
            URL[] urls = us.toArray(new URL[us.size()]);
            URL pageURL = ShowJavadocAction.findJavadoc("overview-summary.html", urls);
            if (pageURL == null) {
                pageURL = ShowJavadocAction.findJavadoc("index.html", urls);
            }
            ProjectInformation info = null;
            Project p = this.antArtifact.getProject();
            if (p != null) {
                info = ProjectUtils.getInformation((Project)p);
            }
            ShowJavadocAction.showJavaDoc(pageURL, info == null ? NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$ProjectNode == null ? (class$org$netbeans$modules$java$j2seproject$ui$ProjectNode = ProjectNode.class$("org.netbeans.modules.java.j2seproject.ui.ProjectNode")) : class$org$netbeans$modules$java$j2seproject$ui$ProjectNode), (String)"TXT_UnknownProjectName") : info.getDisplayName());
        }

        private Set findJavadoc() {
            File scriptLocation = this.antArtifact.getScriptLocation();
            HashSet<URL> urls = new HashSet<URL>();
            try {
                URL artifactURL = scriptLocation.toURI().resolve(this.artifactLocation).normalize().toURL();
                if (FileUtil.isArchiveFile((URL)artifactURL)) {
                    artifactURL = FileUtil.getArchiveRoot((URL)artifactURL);
                }
                urls.addAll(Arrays.asList(JavadocForBinaryQuery.findJavadoc((URL)artifactURL).getRoots()));
            }
            catch (MalformedURLException mue) {
                ErrorManager.getDefault().notify((Throwable)mue);
            }
            return urls;
        }
    }
}

