/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.bridge;

import java.beans.PropertyChangeEvent;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.java.bridge.ClassElementImpl;
import org.netbeans.modules.java.bridge.DefaultLangModel;
import org.netbeans.modules.java.bridge.ElementImpl;
import org.netbeans.modules.java.bridge.SourceElementImpl;
import org.openide.ErrorManager;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.MemberElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.util.Utilities;

abstract class MemberElementImpl
extends ElementImpl {
    protected ClassElementImpl declaringClassImpl;
    protected transient Identifier cachedName = null;
    static final long serialVersionUID = 6388377681336329844L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MemberElementImpl(DefaultLangModel model, Feature javaElement) {
        super(model, (RefObject)javaElement);
        this.repository.beginTrans(false);
        try {
            String name;
            if (this.javaElement.isValid() && (name = javaElement.getName()) != null) {
                this.cachedName = this.createName(name);
            }
        }
        finally {
            this.repository.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setParent(ElementImpl impl) {
        if (impl instanceof ClassElementImpl) {
            this.declaringClassImpl = (ClassElementImpl)impl;
            this.repository.beginTrans(false);
            try {
                String name;
                if (this.javaElement.isValid() && (name = ((Feature)this.javaElement).getName()) != null) {
                    this.cachedName = this.createName(name);
                }
            }
            finally {
                this.repository.endTrans();
            }
        }
    }

    protected boolean parentValid() {
        return this.declaringClassImpl != null && this.declaringClassImpl.isValid();
    }

    protected void createFromModel(Element model) throws SourceException {
        MemberElement other = (MemberElement)model;
        this.setModifiers(other.getModifiers());
        this.setName(this.createName(other.getName().getName()));
    }

    protected Identifier createName(String n) {
        if (n == null) {
            n = "";
        }
        return Identifier.create((String)n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getModifiers() {
        this.repository.beginTrans(false);
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                int n = ((Feature)this.javaElement).getModifiers();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.repository.endTrans(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identifier getName() {
        this.repository.beginTrans(false);
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                Identifier identifier = this.createName(((Feature)this.javaElement).getName());
                return identifier;
            }
            Identifier identifier = this.cachedName != null ? this.cachedName : Identifier.create((String)"");
            return identifier;
        }
        finally {
            this.repository.endTrans(false);
        }
    }

    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        ClassElementImpl impl = this.getDeclaringImpl();
        return impl == null || impl.isValid();
    }

    protected void checkWritable(boolean unsafeOp) throws SourceException {
        SourceElementImpl source = this.findSource();
        if (source != null) {
            source.checkWritable(unsafeOp);
        }
    }

    public ClassElement[] getLocalClasses() {
        return new ClassElement[0];
    }

    protected void checkModifierConstraints(int newMods) throws SourceException {
    }

    protected void checkNameConstraints(Identifier name) throws SourceException {
    }

    protected final Type resolveType(Type t) {
        if (!this.isConstrained()) {
            return t;
        }
        if (t.isPrimitive()) {
            return t;
        }
        return this.getModelImpl().resolveType(this.getParent(), t);
    }

    protected final Identifier resolveIdent(Identifier i) {
        if (i == null || !this.isConstrained()) {
            return i;
        }
        return this.getModelImpl().resolveIdent(this.getParent(), i);
    }

    protected final Identifier[] resolveIdentifiers(Identifier[] ids) {
        if (!this.isConstrained()) {
            return ids;
        }
        Identifier[] newIds = null;
        for (int i = 0; i < ids.length; ++i) {
            Identifier n = this.resolveIdent(ids[i]);
            if (n == ids[i]) continue;
            if (newIds == null) {
                newIds = new Identifier[ids.length];
                System.arraycopy(ids, 0, newIds, 0, ids.length);
            }
            newIds[i] = n;
        }
        if (newIds == null) {
            return ids;
        }
        return newIds;
    }

    protected Element getParent() {
        return this.getDeclaringClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModifiers(int mod) throws SourceException {
        this.checkWritable(false);
        this.checkDocument();
        this.repository.beginTrans(true);
        boolean failed = true;
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                int old = this.getModifiers();
                if (old == mod) {
                    failed = false;
                    return;
                }
                if (this.isConstrained()) {
                    this.checkModifierConstraints(mod);
                }
                PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "modifiers", new Integer(old), new Integer(mod));
                this.checkVetoablePropertyChange(evt);
                ((Feature)this.javaElement).setModifiers(mod);
                failed = false;
            } else {
                failed = false;
                this.throwIsInvalid();
            }
        }
        finally {
            this.repository.endTrans(failed);
        }
    }

    protected void doSetName(Identifier id) throws SourceException {
        String s = id.getName();
        Identifier old = this.getName();
        if (this.isConstrained()) {
            this.checkNameConstraints(id);
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "name", old, id);
        this.checkVetoablePropertyChange(evt);
        if (this.javaElement instanceof Constructor) {
            if (!this.javaElement.isValid()) {
                this.throwIsInvalid();
            }
        } else {
            String name = id.getName();
            if (this.javaElement instanceof JavaClass) {
                ((JavaClass)this.javaElement).setSimpleName(name);
            } else {
                ((Feature)this.javaElement).setName(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(Identifier id) throws SourceException {
        this.checkWritable(false);
        this.checkDocument();
        boolean failed = true;
        this.repository.beginTrans(true);
        try {
            if (this.javaElement.isValid()) {
                this.setClassPath();
                this.doSetName(id);
                failed = false;
            } else {
                failed = false;
                this.throwIsInvalid();
            }
        }
        finally {
            this.repository.endTrans(failed);
        }
    }

    public void fireNameChange(String oldValue, String newValue) {
        Identifier oldName = null;
        Identifier newName = null;
        if (oldValue == null) {
            oldValue = "";
        }
        if (newValue == null) {
            newValue = "";
        }
        try {
            oldName = this.createName(oldValue);
        }
        catch (InvalidObjectException e) {
            oldName = Identifier.create((String)"");
        }
        try {
            newName = this.createName(newValue);
        }
        catch (InvalidObjectException e) {
            newName = Identifier.create((String)"");
        }
        this.cachedName = newName;
        PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "name", oldName, newName);
        if (!oldName.equals((Object)newName)) {
            this.fireOwnPropertyChange(evt);
        }
        MemberElement old = (MemberElement)this.cloneSelf();
        try {
            old.setName(oldName);
        }
        catch (SourceException e) {
            // empty catch block
        }
        this.notifyConnectionChange((Element)old);
    }

    public void fireModifiersChange(Integer oldValue, Integer newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this.getElement(), "modifiers", oldValue, newValue);
        this.fireOwnPropertyChange(evt);
        MemberElement old = (MemberElement)this.cloneSelf();
        try {
            old.setModifiers(oldValue.intValue());
        }
        catch (SourceException e) {
            // empty catch block
        }
        this.notifyConnectionChange((Element)old);
    }

    protected static boolean compareSourceIdentifiers(Identifier oldId, Identifier newId) {
        int newRes;
        if (oldId == newId) {
            return true;
        }
        if (oldId == null || newId == null) {
            return false;
        }
        if (!oldId.getSourceName().equals(newId.getSourceName())) {
            return false;
        }
        int oldRes = oldId.getResolutionStatus();
        boolean result = (oldRes == (newRes = newId.getResolutionStatus()) || newRes == 0) && oldId.getFullName().equals(newId.getFullName());
        return result;
    }

    protected static boolean compareSourceTypes(Type oldType, Type newType) {
        if (oldType == newType) {
            return true;
        }
        if (oldType == null || newType == null) {
            return false;
        }
        if (oldType.isPrimitive() || newType.isPrimitive()) {
            return false;
        }
        if (oldType.isArray()) {
            if (!newType.isArray()) {
                return false;
            }
            return MemberElementImpl.compareSourceTypes(oldType.getElementType(), newType.getElementType());
        }
        if (newType.isArray()) {
            return false;
        }
        if (!oldType.isClass() || !newType.isClass()) {
            throw new InternalError("Unexpected type combination.");
        }
        return MemberElementImpl.compareSourceIdentifiers(oldType.getTypeIdentifier(), newType.getTypeIdentifier());
    }

    protected SourceElementImpl findSource() {
        if (this.declaringClassImpl != null) {
            return this.declaringClassImpl.findSource();
        }
        return null;
    }

    protected ClassElementImpl getDeclaringImpl() {
        return this.declaringClassImpl;
    }

    protected ClassElement getDeclaringClass() {
        if (this.declaringClassImpl == null) {
            return null;
        }
        return (ClassElement)this.declaringClassImpl.getElement();
    }

    protected boolean isElementValid() {
        return super.isValid();
    }

    void updateJavadoc() {
        try {
            String javadocText = ((Feature)this.javaElement).getJavadocText();
            if (!Utilities.compareObjects((Object)javadocText, (Object)this.javadoc.getRawText())) {
                try {
                    this.javadoc.changeJavaDocText(javadocText, true);
                }
                catch (SourceException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }
        catch (InvalidObjectException invalidObjectException) {
            // empty catch block
        }
    }

    static class MemberElementListener
    extends ElementImpl.ElementListener {
        MemberElementListener(MemberElementImpl impl) {
            super(impl);
        }

        public void doChange(MDRChangeEvent event) {
            super.doChange(event);
            if (this.source == this.javaElement && event instanceof AttributeEvent) {
                AttributeEvent attrEvent = (AttributeEvent)event;
                String attrName = attrEvent.getAttributeName();
                if (attrName.equals("name")) {
                    ((MemberElementImpl)this.impl).fireNameChange((String)attrEvent.getOldElement(), (String)attrEvent.getNewElement());
                } else if (attrName.equals("modifiers")) {
                    ((MemberElementImpl)this.impl).fireModifiersChange((Integer)attrEvent.getOldElement(), (Integer)attrEvent.getNewElement());
                }
            }
        }
    }
}

