/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.bridge;

import org.netbeans.modules.java.bridge.ElementOrder;
import org.netbeans.modules.java.bridge.Positioner;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.FieldElement;
import org.openide.src.InitializerElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceElement;

class DefaultInsertStrategy
implements Positioner {
    DefaultInsertStrategy() {
    }

    public Element[] findInsertPositions(Element container, Element[] els, Positioner.Acceptor posAcceptor) {
        Object[] siblings = container instanceof SourceElement ? ((SourceElement)container).getClasses() : this.findElements((ClassElement)container, els[0]);
        Element[] refs = new Element[els.length];
        Object ref = siblings == null || siblings.length == 0 ? Positioner.FIRST : siblings[siblings.length - 1];
        refs[0] = ref = this.findSuitablePos(container, (Element)ref, posAcceptor);
        for (int i = 1; i < refs.length; ++i) {
            refs[i] = els[i - 1];
        }
        return refs;
    }

    private Element findSuitablePos(Element container, Element ref, Positioner.Acceptor acc) {
        if (acc.canInsertAfter(ref)) {
            return ref;
        }
        ElementOrder o = (ElementOrder)container.getCookie(ElementOrder.class);
        Element[] children = o.getElements();
        int prefPos = 0;
        for (int i = 0; i < children.length; ++i) {
            if (ref != children[i]) continue;
            prefPos = i;
            break;
        }
        int after = prefPos + 1;
        int before = prefPos - 1;
        while (before >= -1 || after < children.length) {
            if (after < children.length) {
                if (acc.canInsertAfter(children[after])) {
                    return children[after];
                }
                ++after;
            }
            if (before >= 0) {
                if (acc.canInsertAfter(children[before])) {
                    return children[before];
                }
                --before;
                continue;
            }
            if (before != -1) continue;
            if (acc.canInsertAfter(FIRST)) {
                return FIRST;
            }
            --before;
        }
        return null;
    }

    private Element[] findElements(ClassElement container, Element selector) {
        if (selector instanceof FieldElement) {
            return this.getFirstNonEmpty(container, 0);
        }
        if (selector instanceof ClassElement) {
            return this.getFirstNonEmpty(container, 4);
        }
        if (selector instanceof MethodElement) {
            return this.getFirstNonEmpty(container, 3);
        }
        if (selector instanceof ConstructorElement) {
            return this.getFirstNonEmpty(container, 2);
        }
        if (selector instanceof InitializerElement) {
            return this.getFirstNonEmpty(container, 1);
        }
        return null;
    }

    private Element[] getFirstNonEmpty(ClassElement container, int startPos) {
        ClassElement[] items;
        if (startPos > 3 && (items = container.getClasses()) != null && items.length > 0) {
            return items;
        }
        if (startPos > 2 && (items = container.getMethods()) != null && items.length > 0) {
            return items;
        }
        if (startPos > 1 && (items = container.getConstructors()) != null && items.length > 0) {
            return items;
        }
        if (startPos > 0 && (items = container.getInitializers()) != null && items.length > 0) {
            return items;
        }
        items = container.getFields();
        if (items != null && items.length > 0) {
            return items;
        }
        return null;
    }
}

