/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.util.Arrays;
import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.Encodings;
import org.tritonus.share.sampled.FloatSampleBuffer;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.convert.TSimpleFormatConversionProvider;
import org.tritonus.share.sampled.convert.TSynchronousFilteredAudioInputStream;

public class PCM2PCMConversionProvider
extends TSimpleFormatConversionProvider {
    public static AudioFormat.Encoding PCM_SIGNED = Encodings.getEncoding("PCM_SIGNED");
    public static AudioFormat.Encoding PCM_UNSIGNED = Encodings.getEncoding("PCM_UNSIGNED");
    private static final int ALL = -1;
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 24, -1, -1, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 24, -1, -1, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 32, -1, -1, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 32, -1, -1, -1.0f, true)};
    private static final int UNSIGNED8 = 1;
    private static final int SIGNED8 = 2;
    private static final int BIG_ENDIAN16 = 3;
    private static final int LITTLE_ENDIAN16 = 4;
    private static final int BIG_ENDIAN24 = 5;
    private static final int LITTLE_ENDIAN24 = 6;
    private static final int BIG_ENDIAN32 = 7;
    private static final int LITTLE_ENDIAN32 = 8;
    private static final int CONVERT_NOT_POSSIBLE = 0;
    private static final int CONVERT_SIGN = 1;
    private static final int CONVERT_BYTE_ORDER16 = 2;
    private static final int CONVERT_BYTE_ORDER24 = 3;
    private static final int CONVERT_BYTE_ORDER32 = 4;
    private static final int CONVERT_16LTO8S = 5;
    private static final int CONVERT_16LTO8U = 6;
    private static final int CONVERT_16BTO8S = 7;
    private static final int CONVERT_16BTO8U = 8;
    private static final int CONVERT_8STO16L = 9;
    private static final int CONVERT_8STO16B = 10;
    private static final int CONVERT_8UTO16L = 11;
    private static final int CONVERT_8UTO16B = 12;
    private static final int CONVERT_ONLY_EXPAND_CHANNELS = 13;
    private static final int CONVERT_FLOAT = 100;
    private static final int CONVERT_NONE = 101;

    public AudioInputStream getAudioInputStream(AudioFormat audioFormat, AudioInputStream audioInputStream) {
        AudioFormat audioFormat2 = audioInputStream.getFormat();
        if (AudioFormats.matches(audioFormat2, audioFormat)) {
            return audioInputStream;
        }
        if (PCM2PCMConversionProvider.doMatch(audioFormat.getFrameRate(), audioFormat2.getFrameRate()) && PCM2PCMConversionProvider.doMatch(audioFormat.getSampleRate(), audioFormat2.getSampleRate())) {
            audioFormat = this.replaceNotSpecified(audioFormat2, audioFormat);
            int n = this.getFormatType(audioFormat2);
            int n2 = this.getFormatType(audioFormat);
            int n3 = this.getConversionType(n, audioFormat2.getChannels(), n2, audioFormat.getChannels());
            if (TDebug.TraceAudioConverter) {
                TDebug.out("PCM2PCM: sourceType=" + PCM2PCMConversionProvider.formatType2Str(n) + ", " + audioFormat2.getChannels() + "ch targetType=" + PCM2PCMConversionProvider.formatType2Str(n2) + ", " + audioFormat.getChannels() + "ch conversionType=" + PCM2PCMConversionProvider.conversionType2Str(n3));
            }
            if (n3 == 0) {
                throw new IllegalArgumentException("format conversion not supported");
            }
            return new PCM2PCMStream(audioInputStream, audioFormat, n, n2, n3);
        }
        throw new IllegalArgumentException("format conversion not supported");
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding encoding, AudioFormat audioFormat) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">PCM2PCMFormatConversionProvider.getTargetFormats(AudioFormat.Encoding, AudioFormat):");
            TDebug.out("checking out possible target formats");
            TDebug.out("from: " + audioFormat);
            TDebug.out("to  : " + encoding);
        }
        if (this.isConversionSupported(encoding, audioFormat)) {
            ArraySet arraySet = new ArraySet();
            Iterator iterator = this.getCollectionTargetFormats().iterator();
            while (iterator.hasNext()) {
                AudioFormat audioFormat2 = (AudioFormat)iterator.next();
                if (!this.isConversionSupported(audioFormat2 = this.replaceNotSpecified(audioFormat, audioFormat2), audioFormat)) continue;
                arraySet.add(audioFormat2);
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("<found " + arraySet.size() + " matching formats.");
            }
            return (AudioFormat[])arraySet.toArray(EMPTY_FORMAT_ARRAY);
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<returning empty array.");
        }
        return EMPTY_FORMAT_ARRAY;
    }

    public boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormat2) {
        boolean bl;
        audioFormat = this.replaceNotSpecified(audioFormat2, audioFormat);
        boolean bl2 = false;
        if (AudioFormats.matches(audioFormat2, audioFormat) || PCM2PCMConversionProvider.doMatch(audioFormat.getFrameRate(), audioFormat2.getFrameRate()) && PCM2PCMConversionProvider.doMatch(audioFormat.getSampleRate(), audioFormat2.getSampleRate()) && this.getConversionType(this.getFormatType(audioFormat2), audioFormat2.getChannels(), this.getFormatType(audioFormat), audioFormat.getChannels()) != 0) {
            bl2 = bl = true;
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">PCM2PCM: isConversionSupported(AudioFormat, AudioFormat):");
            TDebug.out("checking if conversion possible");
            TDebug.out("from: " + audioFormat2);
            TDebug.out("to  : " + audioFormat);
            TDebug.out("< result : " + bl);
        }
        return bl;
    }

    private final int getFormatType(AudioFormat audioFormat) {
        int n = 0;
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        boolean bl = audioFormat.isBigEndian();
        int n2 = audioFormat.getSampleSizeInBits();
        if (encoding.equals(PCM_SIGNED)) {
            if (n2 == 32) {
                n = bl ? 7 : 8;
            } else if (n2 == 24) {
                n = bl ? 5 : 6;
            } else if (n2 == 16) {
                n = bl ? 3 : 4;
            } else if (n2 == 8) {
                n = 2;
            }
        } else if (encoding.equals(PCM_UNSIGNED) && n2 == 8) {
            n = 1;
        }
        return n;
    }

    private final int getConversionType(int n, int n2, int n3, int n4) {
        if (n == 0 || n3 == 0 || n2 != 1 && n4 != 1 && n4 != n2) {
            return 0;
        }
        if (n == n3) {
            if (n2 == n4) {
                return 101;
            }
            if (n2 == 1 && n4 > 1) {
                return 13;
            }
        }
        if (n2 == 1 && n4 >= 1 || n2 == n4) {
            if (n == 1 && n3 == 2 || n == 2 && n3 == 1) {
                return 1;
            }
            if (n == 3 && n3 == 4 || n == 4 && n3 == 3) {
                return 2;
            }
            if (n == 5 && n3 == 6 || n == 6 && n3 == 5) {
                return 3;
            }
            if (n == 7 && n3 == 8 || n == 8 && n3 == 7) {
                return 4;
            }
            if (n == 2 && n3 == 4) {
                return 9;
            }
            if (n == 2 && n3 == 3) {
                return 10;
            }
            if (n == 1 && n3 == 4) {
                return 11;
            }
            if (n == 1 && n3 == 3) {
                return 12;
            }
        }
        return 100;
    }

    private static final String formatType2Str(int n) {
        switch (n) {
            case 0: {
                return "unsupported";
            }
            case 1: {
                return "UNSIGNED8";
            }
            case 2: {
                return "SIGNED8";
            }
            case 3: {
                return "BIG_ENDIAN16";
            }
            case 4: {
                return "LITTLE_ENDIAN16";
            }
            case 5: {
                return "BIG_ENDIAN24";
            }
            case 6: {
                return "LITTLE_ENDIAN24";
            }
            case 7: {
                return "BIG_ENDIAN32";
            }
            case 8: {
                return "LITTLE_ENDIAN32";
            }
        }
        return "unknown";
    }

    private static final String conversionType2Str(int n) {
        switch (n) {
            case 0: {
                return "CONVERT_NOT_POSSIBLE";
            }
            case 1: {
                return "CONVERT_SIGN";
            }
            case 2: {
                return "CONVERT_BYTE_ORDER16";
            }
            case 3: {
                return "CONVERT_BYTE_ORDER24";
            }
            case 4: {
                return "CONVERT_BYTE_ORDER32";
            }
            case 5: {
                return "CONVERT_16LTO8S";
            }
            case 6: {
                return "CONVERT_16LTO8U";
            }
            case 7: {
                return "CONVERT_16BTO8S";
            }
            case 8: {
                return "CONVERT_16BTO8U";
            }
            case 9: {
                return "CONVERT_8STO16L";
            }
            case 10: {
                return "CONVERT_8STO16B";
            }
            case 11: {
                return "CONVERT_8UTO16L";
            }
            case 12: {
                return "CONVERT_8UTO16B";
            }
            case 13: {
                return "CONVERT_ONLY_EXPAND_CHANNELS";
            }
            case 100: {
                return "CONVERT_FLOAT";
            }
            case 101: {
                return "CONVERT_NONE";
            }
        }
        return "unknown";
    }

    static /* synthetic */ int access$1() {
        return 100;
    }

    static /* synthetic */ int access$2() {
        return 1;
    }

    static /* synthetic */ int access$3() {
        return 2;
    }

    static /* synthetic */ int access$4() {
        return 3;
    }

    static /* synthetic */ int access$5() {
        return 4;
    }

    static /* synthetic */ int access$6() {
        return 5;
    }

    static /* synthetic */ int access$7() {
        return 6;
    }

    static /* synthetic */ int access$8() {
        return 7;
    }

    static /* synthetic */ int access$9() {
        return 8;
    }

    static /* synthetic */ int access$10() {
        return 9;
    }

    static /* synthetic */ int access$11() {
        return 10;
    }

    static /* synthetic */ int access$12() {
        return 11;
    }

    static /* synthetic */ int access$13() {
        return 12;
    }

    static /* synthetic */ int access$14() {
        return 13;
    }

    public PCM2PCMConversionProvider() {
        super(Arrays.asList(OUTPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PCM2PCMStream
    extends TSynchronousFilteredAudioInputStream {
        private int conversionType;
        private int sourceType;
        private int targetType;
        private boolean needExpandChannels;
        private boolean needMixDown;
        private AudioFormat intermediateFloatBufferFormat;
        private FloatSampleBuffer floatBuffer;

        private final void do16BTO8S(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
            while (n3 > 0) {
                byArray2[n2++] = byArray[n++];
                --n3;
                ++n;
            }
        }

        private final void do16BTO8U(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
            while (n3 > 0) {
                byArray2[n2++] = (byte)(byArray[n++] + 128);
                --n3;
                ++n;
            }
        }

        private final void do8STO16L(byte[] byArray, byte[] byArray2, int n, int n2) {
            int n3 = 0;
            while (n2 > 0) {
                byArray2[n++] = 0;
                byArray2[n++] = byArray[n3++];
                --n2;
            }
        }

        private final void do8UTO16L(byte[] byArray, byte[] byArray2, int n, int n2) {
            int n3 = 0;
            while (n2 > 0) {
                byArray2[n++] = 0;
                byArray2[n++] = (byte)(byArray[n3++] + 128);
                --n2;
            }
        }

        private final void do8STO16B(byte[] byArray, byte[] byArray2, int n, int n2) {
            int n3 = 0;
            while (n2 > 0) {
                byArray2[n++] = byArray[n3++];
                byArray2[n++] = 0;
                --n2;
            }
        }

        private final void do8UTO16B(byte[] byArray, byte[] byArray2, int n, int n2) {
            int n3 = 0;
            while (n2 > 0) {
                byArray2[n++] = (byte)(byArray[n3++] + 128);
                byArray2[n++] = 0;
                --n2;
            }
        }

        /*
         * Unable to fully structure code
         */
        private final void expandChannels(byte[] var1_1, int var2_2, int var3_3, int var4_4, int var5_5) {
            var6_6 = var2_2 + var4_4 * var3_3;
            var7_7 = var2_2 + var4_4 * var5_5 * var3_3;
            switch (var4_4) {
                case 1: {
                    if (var5_5 != 2) ** GOTO lbl19
                    while (var3_3 > 0) {
                        var1_1[--var7_7] = var1_1[--var6_6];
                        var1_1[--var7_7] = var1_1[var6_6];
                        --var3_3;
                    }
                    break;
lbl-1000:
                    // 1 sources

                    {
                        --var6_6;
                        var8_8 = 0;
                        while (var8_8 < var5_5) {
                            var1_1[--var7_7] = var1_1[var6_6];
                            ++var8_8;
                        }
                        --var3_3;
lbl19:
                        // 2 sources

                        ** while (var3_3 > 0)
                    }
lbl20:
                    // 1 sources

                    break;
                }
                case 2: {
                    if (var5_5 != 2) ** GOTO lbl40
                    while (var3_3 > 0) {
                        var1_1[--var7_7] = var1_1[--var6_6];
                        var1_1[--var7_7] = var1_1[var6_6 - 1];
                        var1_1[--var7_7] = var1_1[var6_6];
                        var1_1[--var7_7] = var1_1[--var6_6];
                        --var3_3;
                    }
                    break;
lbl-1000:
                    // 1 sources

                    {
                        --var6_6;
                        var8_9 = 0;
                        while (var8_9 < var5_5) {
                            var1_1[--var7_7] = var1_1[var6_6];
                            var1_1[--var7_7] = var1_1[var6_6 - 1];
                            ++var8_9;
                        }
                        --var6_6;
                        --var3_3;
lbl40:
                        // 2 sources

                        ** while (var3_3 > 0)
                    }
lbl41:
                    // 1 sources

                    break;
                }
                default: {
                    while (var3_3 > 0) {
                        var8_10 = 0;
                        while (var8_10 < var5_5) {
                            var9_11 = 1;
                            while (var9_11 <= var4_4) {
                                var1_1[--var7_7] = var1_1[var6_6 - var9_11];
                                ++var9_11;
                            }
                            ++var8_10;
                        }
                        var6_6 -= var4_4;
                        --var3_3;
                    }
                    break block0;
                }
            }
        }

        private final void doFloatConversion(FloatSampleBuffer floatSampleBuffer, boolean bl) {
            if (this.needMixDown) {
                floatSampleBuffer.mixDownChannels();
            }
            if (bl) {
                floatSampleBuffer.expandChannel(this.getFormat().getChannels());
            }
        }

        private final void doFloatConversion(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
            int n4 = n3 * (this.getOriginalStream().getFormat().getSampleSizeInBits() / 8);
            if (this.floatBuffer == null) {
                this.floatBuffer = new FloatSampleBuffer();
            }
            this.floatBuffer.initFromByteArray(byArray, n, n4, this.getOriginalStream().getFormat());
            this.doFloatConversion(this.floatBuffer, false);
            this.floatBuffer.convertToByteArray(byArray2, n2, this.intermediateFloatBufferFormat);
        }

        protected int convert(byte[] byArray, byte[] byArray2, int n, int n2) {
            int n3 = n2 * this.getOriginalStream().getFormat().getChannels();
            switch (this.conversionType) {
                case 1: {
                    TConversionTool.convertSign8(byArray, 0, byArray2, n, n3);
                    break;
                }
                case 2: {
                    TConversionTool.swapOrder16(byArray, 0, byArray2, n, n3);
                    break;
                }
                case 3: {
                    TConversionTool.swapOrder24(byArray, 0, byArray2, n, n3);
                    break;
                }
                case 4: {
                    TConversionTool.swapOrder32(byArray, 0, byArray2, n, n3);
                    break;
                }
                case 5: {
                    this.do16BTO8S(byArray, 1, byArray2, n, n3);
                    break;
                }
                case 6: {
                    this.do16BTO8U(byArray, 1, byArray2, n, n3);
                    break;
                }
                case 7: {
                    this.do16BTO8S(byArray, 0, byArray2, n, n3);
                    break;
                }
                case 8: {
                    this.do16BTO8U(byArray, 0, byArray2, n, n3);
                    break;
                }
                case 9: {
                    this.do8STO16L(byArray, byArray2, n, n3);
                    break;
                }
                case 10: {
                    this.do8STO16B(byArray, byArray2, n, n3);
                    break;
                }
                case 11: {
                    this.do8UTO16L(byArray, byArray2, n, n3);
                    break;
                }
                case 12: {
                    this.do8UTO16B(byArray, byArray2, n, n3);
                    break;
                }
                case 13: {
                    System.arraycopy(byArray, 0, byArray2, n, n2 * this.getOriginalStream().getFormat().getFrameSize());
                    break;
                }
                case 100: {
                    this.doFloatConversion(byArray, 0, byArray2, n, n3);
                    break;
                }
                default: {
                    throw new RuntimeException("PCM2PCMStream: Call to convert with unknown conversionType.");
                }
            }
            if (this.needExpandChannels) {
                this.expandChannels(byArray2, n, n2, this.getFormat().getSampleSizeInBits() / 8, this.getFormat().getChannels());
            }
            return n2;
        }

        protected void convertInPlace(byte[] byArray, int n, int n2) {
            int n3 = n2 * this.getOriginalStream().getFormat().getChannels();
            switch (this.conversionType) {
                case 1: {
                    TConversionTool.convertSign8(byArray, n, n3);
                    break;
                }
                case 2: {
                    TConversionTool.swapOrder16(byArray, n, n3);
                    break;
                }
                case 3: {
                    TConversionTool.swapOrder24(byArray, n, n3);
                    break;
                }
                case 4: {
                    TConversionTool.swapOrder32(byArray, n, n3);
                    break;
                }
                case 100: {
                    this.doFloatConversion(byArray, n, byArray, n, n3);
                    if (!this.needExpandChannels) break;
                    this.expandChannels(byArray, n, n2, this.getFormat().getSampleSizeInBits() / 8, this.getFormat().getChannels());
                    break;
                }
                default: {
                    throw new RuntimeException("PCM2PCMStream: Call to convertInPlace, but it cannot convert in place.");
                }
            }
        }

        private final /* synthetic */ void this() {
            this.floatBuffer = null;
        }

        public PCM2PCMStream(AudioInputStream audioInputStream, AudioFormat audioFormat, int n, int n2, int n3) {
            super(audioInputStream, new AudioFormat(audioFormat.getEncoding(), audioInputStream.getFormat().getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getChannels() * audioFormat.getSampleSizeInBits() / 8, audioInputStream.getFormat().getFrameRate(), audioFormat.isBigEndian()));
            this.this();
            if (TDebug.TraceAudioConverter) {
                TDebug.out("PCM2PCMStream: constructor. ConversionType=" + PCM2PCMConversionProvider.conversionType2Str(n3));
            }
            this.conversionType = n3;
            this.sourceType = n;
            this.targetType = n2;
            boolean bl = false;
            if (audioInputStream.getFormat().getChannels() < audioFormat.getChannels()) {
                bl = true;
            }
            this.needExpandChannels = bl;
            boolean bl2 = false;
            if (audioInputStream.getFormat().getChannels() > audioFormat.getChannels()) {
                bl2 = this.needMixDown = true;
            }
            if (this.needMixDown && n3 != 100) {
                throw new IllegalArgumentException("PCM2PCMStream: MixDown only possible with CONVERT_FLOAT");
            }
            if (this.needMixDown && audioFormat.getChannels() != 1) {
                throw new IllegalArgumentException("PCM2PCMStream: MixDown only possible with target channel count=1");
            }
            if (this.needExpandChannels && audioInputStream.getFormat().getChannels() != 1) {
                throw new IllegalArgumentException("PCM2PCMStream: Expanding channels only possible with source channel count=1");
            }
            if (n3 == 100) {
                int n4 = 1;
                if (!this.needExpandChannels) {
                    n4 = audioFormat.getChannels();
                }
                int n5 = n4;
                this.intermediateFloatBufferFormat = new AudioFormat(audioFormat.getEncoding(), audioInputStream.getFormat().getSampleRate(), audioFormat.getSampleSizeInBits(), n5, n5 * audioFormat.getSampleSizeInBits() / 8, audioInputStream.getFormat().getFrameRate(), audioFormat.isBigEndian());
                this.enableConvertInPlace();
            }
            if (!(this.needExpandChannels || n3 != 1 && n3 != 2 && n3 != 3 && n3 != 4)) {
                this.enableConvertInPlace();
            }
        }
    }
}

