/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.FileNameMap;
import java.net.MimeTypeMapper;
import java.net.URL;
import java.net.UnknownServiceException;
import java.security.AllPermission;
import java.security.Permission;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class URLConnection {
    private static FileNameMap fileNameMap;
    private static ContentHandlerFactory factory;
    private static boolean defaultAllowUserInteraction;
    private static boolean defaultUseCaches;
    private static SimpleDateFormat[] dateFormats;
    private static boolean dateformats_initialized;
    protected boolean allowUserInteraction;
    protected boolean connected;
    protected boolean doInput;
    protected boolean doOutput;
    protected boolean useCaches;
    protected long ifModifiedSince;
    protected URL url;
    private ParsePosition position;

    public abstract void connect() throws IOException;

    public URL getURL() {
        return this.url;
    }

    public int getContentLength() {
        return this.getHeaderFieldInt("content-length", -1);
    }

    public String getContentType() {
        return this.getHeaderField("content-type");
    }

    public String getContentEncoding() {
        return this.getHeaderField("content-encoding");
    }

    public long getExpiration() {
        return this.getHeaderFieldDate("expires", 0L);
    }

    public long getDate() {
        return this.getHeaderFieldDate("date", 0L);
    }

    public long getLastModified() {
        return this.getHeaderFieldDate("last-modified", 0L);
    }

    public String getHeaderField(int n) {
        return null;
    }

    public String getHeaderField(String string) {
        return null;
    }

    public Map getHeaderFields() {
        return Collections.EMPTY_MAP;
    }

    public int getHeaderFieldInt(String string, int n) {
        String string2 = this.getHeaderField(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public long getHeaderFieldDate(String string, long l) {
        if (!dateformats_initialized) {
            URLConnection.initializeDateFormats();
        }
        if (this.position == null) {
            this.position = new ParsePosition(0);
        }
        long l2 = l;
        String string2 = this.getHeaderField(string);
        if (string2 != null) {
            int n = 0;
            while (n < dateFormats.length) {
                SimpleDateFormat simpleDateFormat = dateFormats[n];
                this.position.setIndex(0);
                this.position.setErrorIndex(0);
                Date date = simpleDateFormat.parse(string2, this.position);
                if (date != null) {
                    return date.getTime();
                }
                ++n;
            }
        }
        return l2;
    }

    public String getHeaderFieldKey(int n) {
        return null;
    }

    public Object getContent() throws IOException {
        String string;
        ContentHandler contentHandler;
        if (!this.connected) {
            this.connect();
        }
        if ((contentHandler = this.getContentHandler(string = this.getContentType())) != null) {
            return contentHandler.getContent(this);
        }
        return this.getInputStream();
    }

    public Object getContent(Class[] classArray) throws IOException {
        return this.getContent();
    }

    public Permission getPermission() throws IOException {
        return new AllPermission();
    }

    public InputStream getInputStream() throws IOException {
        throw new UnknownServiceException("Protocol " + this.url.getProtocol() + " does not support input.");
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException("Protocol " + this.url.getProtocol() + " does not support output.");
    }

    public String toString() {
        return this.getClass().getName() + ':' + this.url.toString();
    }

    public void setDoInput(boolean bl) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.doInput = bl;
    }

    public boolean getDoInput() {
        return this.doInput;
    }

    public void setDoOutput(boolean bl) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.doOutput = bl;
    }

    public boolean getDoOutput() {
        return this.doOutput;
    }

    public void setAllowUserInteraction(boolean bl) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.allowUserInteraction = bl;
    }

    public boolean getAllowUserInteraction() {
        return this.allowUserInteraction;
    }

    public static void setDefaultAllowUserInteraction(boolean bl) {
        defaultAllowUserInteraction = bl;
    }

    public static boolean getDefaultAllowUserInteraction() {
        return defaultAllowUserInteraction;
    }

    public void setUseCaches(boolean bl) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.useCaches = bl;
    }

    public boolean getUseCaches() {
        return this.useCaches;
    }

    public void setIfModifiedSince(long l) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.ifModifiedSince = l;
    }

    public long getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public boolean getDefaultUseCaches() {
        return defaultUseCaches;
    }

    public void setDefaultUseCaches(boolean bl) {
        defaultUseCaches = bl;
    }

    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (string == null) {
            throw new NullPointerException("key is null");
        }
    }

    public void addRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (string == null) {
            throw new NullPointerException("key is null");
        }
    }

    public String getRequestProperty(String string) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return null;
    }

    public Map getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return Collections.EMPTY_MAP;
    }

    public static void setDefaultRequestProperty(String string, String string2) {
    }

    public static String getDefaultRequestProperty(String string) {
        return null;
    }

    public static synchronized void setContentHandlerFactory(ContentHandlerFactory contentHandlerFactory) {
        if (factory != null) {
            throw new Error("ContentHandlerFactory already set");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        factory = contentHandlerFactory;
    }

    public static String guessContentTypeFromName(String string) {
        return URLConnection.getFileNameMap().getContentTypeFor(string.toLowerCase());
    }

    public static String guessContentTypeFromStream(InputStream inputStream) throws IOException {
        return "application/octet-stream";
    }

    public static synchronized FileNameMap getFileNameMap() {
        if (fileNameMap == null) {
            fileNameMap = new MimeTypeMapper();
        }
        return fileNameMap;
    }

    public static synchronized void setFileNameMap(FileNameMap fileNameMap) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        URLConnection.fileNameMap = fileNameMap;
    }

    private final ContentHandler getContentHandler(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        ContentHandler contentHandler = null;
        if (factory != null) {
            contentHandler = factory.createContentHandler(string);
        }
        try {
            Class clazz;
            Object object;
            String string2 = string.replace('/', '.');
            int n = string2.indexOf(59);
            if (n >= 1) {
                string2 = string2.substring(0, n);
            }
            if ((object = (clazz = Class.forName("gnu.java.net.content." + string2)).newInstance()) instanceof ContentHandler) {
                contentHandler = (ContentHandler)object;
                return contentHandler;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return contentHandler;
    }

    private static final synchronized void initializeDateFormats() {
        if (dateformats_initialized) {
            return;
        }
        Locale locale = new Locale("En", "Us", "Unix");
        dateFormats = new SimpleDateFormat[3];
        URLConnection.dateFormats[0] = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss 'GMT'", locale);
        URLConnection.dateFormats[1] = new SimpleDateFormat("EEEE, dd-MMM-yy hh:mm:ss 'GMT'", locale);
        URLConnection.dateFormats[2] = new SimpleDateFormat("EEE MMM d hh:mm:ss yyyy", locale);
        dateformats_initialized = true;
    }

    private final /* synthetic */ void this() {
        this.doInput = true;
    }

    protected URLConnection(URL uRL) {
        this.this();
        this.url = uRL;
        this.allowUserInteraction = defaultAllowUserInteraction;
        this.useCaches = defaultUseCaches;
    }

    static {
        defaultUseCaches = true;
    }
}

