/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.nio.channels.FileChannelImpl;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class RandomAccessFile
implements DataOutput,
DataInput {
    private FileChannelImpl ch;
    private FileDescriptor fd;
    private DataOutputStream out;
    private DataInputStream in;

    public void close() throws IOException {
        this.ch.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final FileDescriptor getFD() throws IOException {
        RandomAccessFile randomAccessFile = this;
        synchronized (randomAccessFile) {
            if (this.fd == null) {
                this.fd = new FileDescriptor(this.ch);
            }
            return this.fd;
        }
    }

    public long getFilePointer() throws IOException {
        return this.ch.position();
    }

    public void setLength(long l) throws IOException {
        if (l < this.length()) {
            this.ch.truncate(l);
        } else if (l > this.length()) {
            long l2 = this.getFilePointer();
            this.seek(l - 1L);
            this.write(0);
            this.seek(l2);
        }
    }

    public long length() throws IOException {
        return this.ch.size();
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.in.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    public final boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public final byte readByte() throws IOException {
        return this.in.readByte();
    }

    public final char readChar() throws IOException {
        return this.in.readChar();
    }

    public final double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public final float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.in.readFully(byArray);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.in.readFully(byArray, n, n2);
    }

    public final int readInt() throws IOException {
        return this.in.readInt();
    }

    public final String readLine() throws IOException {
        return this.in.readLine();
    }

    public final long readLong() throws IOException {
        return this.in.readLong();
    }

    public final short readShort() throws IOException {
        return this.in.readShort();
    }

    public final int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    public final int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public final String readUTF() throws IOException {
        return this.in.readUTF();
    }

    public void seek(long l) throws IOException {
        this.ch.position(l);
    }

    public int skipBytes(int n) throws IOException {
        long l;
        if (n < 0) {
            throw new IllegalArgumentException("Can't skip negative bytes: " + n);
        }
        if (n == 0) {
            return 0;
        }
        long l2 = this.ch.position();
        long l3 = l2 + (long)n;
        if (l3 > (l = this.ch.size())) {
            l3 = l;
        }
        this.ch.position(l3);
        return (int)(this.ch.position() - l2);
    }

    public void write(int n) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.write(byArray, n, n2);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeBoolean(bl);
    }

    public final void writeByte(int n) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeByte(n);
    }

    public final void writeShort(int n) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeShort(n);
    }

    public final void writeChar(int n) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeChar(n);
    }

    public final void writeInt(int n) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeInt(n);
    }

    public final void writeLong(long l) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeLong(l);
    }

    public final void writeFloat(float f) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeFloat(f);
    }

    public final void writeDouble(double d) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeDouble(d);
    }

    public final void writeBytes(String string) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeBytes(string);
    }

    public final void writeChars(String string) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeChars(string);
    }

    public final void writeUTF(String string) throws IOException {
        if (this.out == null) {
            throw new IOException("Bad file descriptor");
        }
        this.out.writeUTF(string);
    }

    public final synchronized FileChannel getChannel() {
        return this.ch;
    }

    public RandomAccessFile(File file, String string) throws FileNotFoundException {
        int n;
        if (string.equals("r")) {
            n = 1;
        } else if (string.equals("rw")) {
            n = 3;
        } else if (string.equals("rws")) {
            n = 19;
        } else if (string.equals("rwd")) {
            n = 35;
        } else {
            throw new IllegalArgumentException("invalid mode: " + string);
        }
        String string2 = file.getPath();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string2);
            if ((n & 2) != 0) {
                securityManager.checkWrite(string2);
            }
        }
        this.ch = FileChannelImpl.create(file, n);
        this.fd = new FileDescriptor(this.ch);
        this.out = (n & 2) != 0 ? new DataOutputStream(new FileOutputStream(this.fd)) : null;
        this.in = new DataInputStream(new FileInputStream(this.fd));
    }

    public RandomAccessFile(String string, String string2) throws FileNotFoundException {
        this(new File(string), string2);
    }
}

