/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import sun.misc.ClassFileTransformer;
import sun.misc.CompoundEnumeration;
import sun.misc.Launcher;
import sun.misc.Resource;
import sun.misc.URLClassPath;
import sun.misc.VM;
import sun.reflect.Reflection;
import sun.security.util.SecurityConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassLoader {
    private boolean initialized = false;
    private ClassLoader parent;
    private Hashtable<String, Certificate[]> package2certs = new Hashtable(11);
    Certificate[] nocerts;
    private Vector<Class<?>> classes = new Vector();
    private Set<ProtectionDomain> domains = new HashSet<ProtectionDomain>();
    private HashMap<String, Package> packages = new HashMap();
    private static URLClassPath bootstrapClassPath;
    private static ClassLoader scl;
    private static boolean sclSet;
    private ProtectionDomain defaultDomain = null;
    private static Vector<String> loadedLibraryNames;
    private static Vector<NativeLibrary> systemNativeLibraries;
    private Vector<NativeLibrary> nativeLibraries = new Vector();
    private static Stack<NativeLibrary> nativeLibraryContext;
    private static String[] usr_paths;
    private static String[] sys_paths;
    private boolean defaultAssertionStatus = false;
    private Map<String, Boolean> packageAssertionStatus = null;
    Map<String, Boolean> classAssertionStatus = null;

    private static native void registerNatives();

    void addClass(Class clazz) {
        this.classes.addElement(clazz);
    }

    protected ClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.parent = classLoader;
        this.initialized = true;
    }

    protected ClassLoader() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.parent = ClassLoader.getSystemClassLoader();
        this.initialized = true;
    }

    public Class<?> loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    protected synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.parent != null ? this.parent.loadClass(string, false) : this.findBootstrapClass0(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.findClass(string);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private synchronized Class loadClassInternal(String string) throws ClassNotFoundException {
        return this.loadClass(string);
    }

    private void checkPackageAccess(Class clazz, ProtectionDomain protectionDomain) {
        String string;
        int n;
        final SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = (string = clazz.getName()).lastIndexOf(46)) != -1) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    securityManager.checkPackageAccess(string.substring(0, n));
                    return null;
                }
            }, new AccessControlContext(new ProtectionDomain[]{protectionDomain}));
        }
        this.domains.add(protectionDomain);
    }

    protected Class<?> findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException(string);
    }

    @Deprecated
    protected final Class<?> defineClass(byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(null, byArray, n, n2, null);
    }

    protected final Class<?> defineClass(String string, byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(string, byArray, n, n2, null);
    }

    private ProtectionDomain preDefineClass(String string, ProtectionDomain protectionDomain) {
        if (!this.checkName(string)) {
            throw new NoClassDefFoundError("IllegalName: " + string);
        }
        if (string != null && string.startsWith("java.")) {
            throw new SecurityException("Prohibited package name: " + string.substring(0, string.lastIndexOf(46)));
        }
        if (protectionDomain == null) {
            protectionDomain = this.getDefaultDomain();
        }
        if (string != null) {
            this.checkCerts(string, protectionDomain.getCodeSource());
        }
        return protectionDomain;
    }

    private String defineClassSourceLocation(ProtectionDomain protectionDomain) {
        CodeSource codeSource = protectionDomain.getCodeSource();
        String string = null;
        if (codeSource != null && codeSource.getLocation() != null) {
            string = codeSource.getLocation().toString();
        }
        return string;
    }

    private Class defineTransformedClass(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain, ClassFormatError classFormatError, String string2) throws ClassFormatError {
        ClassFileTransformer[] classFileTransformerArray = ClassFileTransformer.getTransformers();
        Class clazz = null;
        if (classFileTransformerArray != null) {
            for (ClassFileTransformer classFileTransformer : classFileTransformerArray) {
                try {
                    byte[] byArray2 = classFileTransformer.transform(byArray, n, n2);
                    clazz = this.defineClass1(string, byArray2, 0, byArray2.length, protectionDomain, string2);
                    break;
                }
                catch (ClassFormatError classFormatError2) {
                }
            }
        }
        if (clazz == null) {
            throw classFormatError;
        }
        return clazz;
    }

    private void postDefineClass(Class clazz, ProtectionDomain protectionDomain) {
        Object[] objectArray;
        if (protectionDomain.getCodeSource() != null && (objectArray = protectionDomain.getCodeSource().getCertificates()) != null) {
            this.setSigners(clazz, objectArray);
        }
    }

    protected final Class<?> defineClass(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain) throws ClassFormatError {
        this.check();
        protectionDomain = this.preDefineClass(string, protectionDomain);
        Class clazz = null;
        String string2 = this.defineClassSourceLocation(protectionDomain);
        try {
            clazz = this.defineClass1(string, byArray, n, n2, protectionDomain, string2);
        }
        catch (ClassFormatError classFormatError) {
            clazz = this.defineTransformedClass(string, byArray, n, n2, protectionDomain, classFormatError, string2);
        }
        this.postDefineClass(clazz, protectionDomain);
        return clazz;
    }

    protected final Class<?> defineClass(String string, ByteBuffer byteBuffer, ProtectionDomain protectionDomain) throws ClassFormatError {
        this.check();
        int n = byteBuffer.remaining();
        if (!byteBuffer.isDirect()) {
            if (byteBuffer.hasArray()) {
                return this.defineClass(string, byteBuffer.array(), byteBuffer.position() + byteBuffer.arrayOffset(), n, protectionDomain);
            }
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            return this.defineClass(string, byArray, 0, n, protectionDomain);
        }
        protectionDomain = this.preDefineClass(string, protectionDomain);
        Class clazz = null;
        String string2 = this.defineClassSourceLocation(protectionDomain);
        try {
            clazz = this.defineClass2(string, byteBuffer, byteBuffer.position(), n, protectionDomain, string2);
        }
        catch (ClassFormatError classFormatError) {
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            clazz = this.defineTransformedClass(string, byArray, 0, n, protectionDomain, classFormatError, string2);
        }
        this.postDefineClass(clazz, protectionDomain);
        return clazz;
    }

    private native Class defineClass0(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5);

    private native Class defineClass1(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5, String var6);

    private native Class defineClass2(String var1, ByteBuffer var2, int var3, int var4, ProtectionDomain var5, String var6);

    private boolean checkName(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        return string.indexOf(47) == -1 && (VM.allowArraySyntax() || string.charAt(0) != '[');
    }

    private synchronized void checkCerts(String string, CodeSource codeSource) {
        int n = string.lastIndexOf(46);
        String string2 = n == -1 ? "" : string.substring(0, n);
        Certificate[] certificateArray = this.package2certs.get(string2);
        if (certificateArray == null) {
            if (codeSource != null) {
                certificateArray = codeSource.getCertificates();
            }
            if (certificateArray == null) {
                if (this.nocerts == null) {
                    this.nocerts = new Certificate[0];
                }
                certificateArray = this.nocerts;
            }
            this.package2certs.put(string2, certificateArray);
        } else {
            Certificate[] certificateArray2 = null;
            if (codeSource != null) {
                certificateArray2 = codeSource.getCertificates();
            }
            if (!this.compareCerts(certificateArray, certificateArray2)) {
                throw new SecurityException("class \"" + string + "\"'s signer information does not match signer information of other classes in the same package");
            }
        }
    }

    private boolean compareCerts(Certificate[] certificateArray, Certificate[] certificateArray2) {
        int n;
        boolean bl;
        int n2;
        if (certificateArray2 == null || certificateArray2.length == 0) {
            return certificateArray.length == 0;
        }
        if (certificateArray2.length != certificateArray.length) {
            return false;
        }
        for (n2 = 0; n2 < certificateArray2.length; ++n2) {
            bl = false;
            for (n = 0; n < certificateArray.length; ++n) {
                if (!certificateArray2[n2].equals(certificateArray[n])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        for (n2 = 0; n2 < certificateArray.length; ++n2) {
            bl = false;
            for (n = 0; n < certificateArray2.length; ++n) {
                if (!certificateArray[n2].equals(certificateArray2[n])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    protected final void resolveClass(Class<?> clazz) {
        this.check();
        this.resolveClass0(clazz);
    }

    private native void resolveClass0(Class var1);

    protected final Class<?> findSystemClass(String string) throws ClassNotFoundException {
        this.check();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            if (!this.checkName(string)) {
                throw new ClassNotFoundException(string);
            }
            return this.findBootstrapClass(string);
        }
        return classLoader.loadClass(string);
    }

    private Class findBootstrapClass0(String string) throws ClassNotFoundException {
        this.check();
        if (!this.checkName(string)) {
            throw new ClassNotFoundException(string);
        }
        return this.findBootstrapClass(string);
    }

    private native Class findBootstrapClass(String var1) throws ClassNotFoundException;

    private void check() {
        if (!this.initialized) {
            throw new SecurityException("ClassLoader object not initialized");
        }
    }

    protected final Class<?> findLoadedClass(String string) {
        this.check();
        if (!this.checkName(string)) {
            return null;
        }
        return this.findLoadedClass0(string);
    }

    private final native Class findLoadedClass0(String var1);

    protected final void setSigners(Class<?> clazz, Object[] objectArray) {
        this.check();
        clazz.setSigners(objectArray);
    }

    public URL getResource(String string) {
        URL uRL = this.parent != null ? this.parent.getResource(string) : ClassLoader.getBootstrapResource(string);
        if (uRL == null) {
            uRL = this.findResource(string);
        }
        return uRL;
    }

    public Enumeration<URL> getResources(String string) throws IOException {
        Enumeration[] enumerationArray = new Enumeration[]{this.parent != null ? this.parent.getResources(string) : ClassLoader.getBootstrapResources(string), this.findResources(string)};
        return new CompoundEnumeration<URL>(enumerationArray);
    }

    protected URL findResource(String string) {
        return null;
    }

    protected Enumeration<URL> findResources(String string) throws IOException {
        return Collections.emptyEnumeration();
    }

    public static URL getSystemResource(String string) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.getBootstrapResource(string);
        }
        return classLoader.getResource(string);
    }

    public static Enumeration<URL> getSystemResources(String string) throws IOException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.getBootstrapResources(string);
        }
        return classLoader.getResources(string);
    }

    private static URL getBootstrapResource(String string) {
        URLClassPath uRLClassPath = ClassLoader.getBootstrapClassPath();
        Resource resource = uRLClassPath.getResource(string);
        return resource != null ? resource.getURL() : null;
    }

    private static Enumeration<URL> getBootstrapResources(String string) throws IOException {
        final Enumeration<Resource> enumeration = ClassLoader.getBootstrapClassPath().getResources(string);
        return new Enumeration<URL>(){

            @Override
            public URL nextElement() {
                return ((Resource)enumeration.nextElement()).getURL();
            }

            @Override
            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }
        };
    }

    static URLClassPath getBootstrapClassPath() {
        if (bootstrapClassPath == null) {
            bootstrapClassPath = Launcher.getBootstrapClassPath();
        }
        return bootstrapClassPath;
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static InputStream getSystemResourceAsStream(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public final ClassLoader getParent() {
        ClassLoader classLoader;
        if (this.parent == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && !this.isAncestor(classLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return this.parent;
    }

    public static ClassLoader getSystemClassLoader() {
        ClassLoader classLoader;
        ClassLoader.initSystemClassLoader();
        if (scl == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && classLoader != scl && !scl.isAncestor(classLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return scl;
    }

    private static synchronized void initSystemClassLoader() {
        if (!sclSet) {
            if (scl != null) {
                throw new IllegalStateException("recursive invocation");
            }
            Launcher launcher = Launcher.getLauncher();
            if (launcher != null) {
                Throwable throwable;
                block7: {
                    throwable = null;
                    scl = launcher.getClassLoader();
                    try {
                        scl = AccessController.doPrivileged(new SystemClassLoaderAction(scl));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throwable = privilegedActionException.getCause();
                        if (!(throwable instanceof InvocationTargetException)) break block7;
                        throwable = throwable.getCause();
                    }
                }
                if (throwable != null) {
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    throw new Error(throwable);
                }
            }
            sclSet = true;
        }
    }

    boolean isAncestor(ClassLoader classLoader) {
        ClassLoader classLoader2 = this;
        do {
            if (classLoader != (classLoader2 = classLoader2.parent)) continue;
            return true;
        } while (classLoader2 != null);
        return false;
    }

    static ClassLoader getCallerClassLoader() {
        Class clazz = Reflection.getCallerClass(3);
        if (clazz == null) {
            return null;
        }
        return clazz.getClassLoader0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        HashMap<String, Package> hashMap = this.packages;
        synchronized (hashMap) {
            Package package_ = this.getPackage(string);
            if (package_ != null) {
                throw new IllegalArgumentException(string);
            }
            package_ = new Package(string, string2, string3, string4, string5, string6, string7, uRL, this);
            this.packages.put(string, package_);
            return package_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackage(String string) {
        HashMap<String, Package> hashMap = this.packages;
        synchronized (hashMap) {
            Package package_ = this.packages.get(string);
            if (package_ == null && (package_ = this.parent != null ? this.parent.getPackage(string) : Package.getSystemPackage(string)) != null) {
                this.packages.put(string, package_);
            }
            return package_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package[] getPackages() {
        Package[] packageArray = this.packages;
        synchronized (this.packages) {
            HashMap<String, Package> hashMap = new HashMap<String, Package>(this.packages);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            packageArray = this.parent != null ? this.parent.getPackages() : Package.getSystemPackages();
            if (packageArray != null) {
                for (int i = 0; i < packageArray.length; ++i) {
                    String string = packageArray[i].getName();
                    if (hashMap.get(string) != null) continue;
                    hashMap.put(string, packageArray[i]);
                }
            }
            return hashMap.values().toArray(new Package[hashMap.size()]);
        }
    }

    protected String findLibrary(String string) {
        return null;
    }

    private synchronized ProtectionDomain getDefaultDomain() {
        if (this.defaultDomain == null) {
            CodeSource codeSource = new CodeSource(null, (Certificate[])null);
            this.defaultDomain = new ProtectionDomain(codeSource, null, this, null);
        }
        return this.defaultDomain;
    }

    private static String[] initializePath(String string) {
        String string2 = System.getProperty(string, "");
        String string3 = File.pathSeparator;
        int n = string2.length();
        int n2 = string2.indexOf(string3);
        int n3 = 0;
        while (n2 >= 0) {
            ++n3;
            n2 = string2.indexOf(string3, n2 + 1);
        }
        String[] stringArray = new String[n3 + 1];
        n2 = 0;
        n3 = 0;
        int n4 = string2.indexOf(string3);
        while (n4 >= 0) {
            if (n4 - n2 > 0) {
                stringArray[n3++] = string2.substring(n2, n4);
            } else if (n4 - n2 == 0) {
                stringArray[n3++] = ".";
            }
            n2 = n4 + 1;
            n4 = string2.indexOf(string3, n2);
        }
        stringArray[n3] = string2.substring(n2, n);
        return stringArray;
    }

    static void loadLibrary(Class clazz, String string, boolean bl) {
        File file;
        int n;
        String string2;
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = clazz == null ? null : clazz.getClassLoader();
        if (sys_paths == null) {
            usr_paths = ClassLoader.initializePath("java.library.path");
            sys_paths = ClassLoader.initializePath("sun.boot.library.path");
        }
        if (bl) {
            if (ClassLoader.loadLibrary0(clazz, new File(string))) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load library: " + string);
        }
        if (classLoader != null && (string2 = classLoader.findLibrary(string)) != null) {
            File file2 = new File(string2);
            if (!file2.isAbsolute()) {
                throw new UnsatisfiedLinkError("ClassLoader.findLibrary failed to return an absolute path: " + string2);
            }
            if (ClassLoader.loadLibrary0(clazz, file2)) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load " + string2);
        }
        for (n = 0; n < sys_paths.length; ++n) {
            file = new File(sys_paths[n], System.mapLibraryName(string));
            if (!ClassLoader.loadLibrary0(clazz, file)) continue;
            return;
        }
        if (classLoader != null) {
            for (n = 0; n < usr_paths.length; ++n) {
                file = new File(usr_paths[n], System.mapLibraryName(string));
                if (!ClassLoader.loadLibrary0(clazz, file)) continue;
                return;
            }
        }
        throw new UnsatisfiedLinkError("no " + string + " in java.library.path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadLibrary0(Class clazz, final File file) {
        Vector<NativeLibrary> vector;
        String string;
        File file2 = (File)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Object[] objectArray;
                File file2;
                if (file.exists()) {
                    return file;
                }
                if (file.getName().endsWith(".so") && (file2 = file.getParentFile()) != null && (objectArray = file2.list(new LibraryFileFilter(file.getName()))) != null && objectArray.length > 0) {
                    Arrays.sort(objectArray);
                    return new File(file2, (String)objectArray[objectArray.length - 1]);
                }
                return null;
            }

            class LibraryFileFilter
            implements FilenameFilter {
                String lib_name;

                LibraryFileFilter(String string) {
                    this.lib_name = string;
                }

                public boolean accept(File file, String string) {
                    if (string.startsWith(this.lib_name)) {
                        return string.substring(this.lib_name.length()).matches(".[0-9]+.[0-9]+$");
                    }
                    return false;
                }
            }
        });
        if (file2 == null) {
            return false;
        }
        try {
            string = file2.getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
        Vector<NativeLibrary> vector2 = vector = classLoader != null ? classLoader.nativeLibraries : systemNativeLibraries;
        synchronized (vector2) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                NativeLibrary nativeLibrary = vector.elementAt(i);
                if (!string.equals(nativeLibrary.name)) continue;
                return true;
            }
            Vector<String> vector3 = loadedLibraryNames;
            synchronized (vector3) {
                if (loadedLibraryNames.contains(string)) {
                    throw new UnsatisfiedLinkError("Native Library " + string + " already loaded in another classloader");
                }
                int n2 = nativeLibraryContext.size();
                for (int i = 0; i < n2; ++i) {
                    NativeLibrary nativeLibrary = (NativeLibrary)nativeLibraryContext.elementAt(i);
                    if (!string.equals(nativeLibrary.name)) continue;
                    if (classLoader == nativeLibrary.fromClass.getClassLoader()) {
                        return true;
                    }
                    throw new UnsatisfiedLinkError("Native Library " + string + " is being loaded in another classloader");
                }
                NativeLibrary nativeLibrary = new NativeLibrary(clazz, string);
                nativeLibraryContext.push(nativeLibrary);
                try {
                    nativeLibrary.load(string);
                }
                finally {
                    nativeLibraryContext.pop();
                }
                if (nativeLibrary.handle != 0L) {
                    loadedLibraryNames.addElement(string);
                    vector.addElement(nativeLibrary);
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long findNative(ClassLoader classLoader, String string) {
        Vector<NativeLibrary> vector;
        Vector<NativeLibrary> vector2 = vector = classLoader != null ? classLoader.nativeLibraries : systemNativeLibraries;
        synchronized (vector2) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                NativeLibrary nativeLibrary = vector.elementAt(i);
                long l = nativeLibrary.find(string);
                if (l == 0L) continue;
                return l;
            }
        }
        return 0L;
    }

    public synchronized void setDefaultAssertionStatus(boolean bl) {
        if (this.classAssertionStatus == null) {
            this.initializeJavaAssertionMaps();
        }
        this.defaultAssertionStatus = bl;
    }

    public synchronized void setPackageAssertionStatus(String string, boolean bl) {
        if (this.packageAssertionStatus == null) {
            this.initializeJavaAssertionMaps();
        }
        this.packageAssertionStatus.put(string, bl);
    }

    public synchronized void setClassAssertionStatus(String string, boolean bl) {
        if (this.classAssertionStatus == null) {
            this.initializeJavaAssertionMaps();
        }
        this.classAssertionStatus.put(string, bl);
    }

    public synchronized void clearAssertionStatus() {
        this.classAssertionStatus = new HashMap<String, Boolean>();
        this.packageAssertionStatus = new HashMap<String, Boolean>();
        this.defaultAssertionStatus = false;
    }

    synchronized boolean desiredAssertionStatus(String string) {
        Boolean bl = this.classAssertionStatus.get(string);
        if (bl != null) {
            return bl;
        }
        int n = string.lastIndexOf(".");
        if (n < 0 && (bl = this.packageAssertionStatus.get(null)) != null) {
            return bl;
        }
        while (n > 0) {
            bl = this.packageAssertionStatus.get(string = string.substring(0, n));
            if (bl != null) {
                return bl;
            }
            n = string.lastIndexOf(".", n - 1);
        }
        return this.defaultAssertionStatus;
    }

    private void initializeJavaAssertionMaps() {
        int n;
        this.classAssertionStatus = new HashMap<String, Boolean>();
        this.packageAssertionStatus = new HashMap<String, Boolean>();
        AssertionStatusDirectives assertionStatusDirectives = ClassLoader.retrieveDirectives();
        for (n = 0; n < assertionStatusDirectives.classes.length; ++n) {
            this.classAssertionStatus.put(assertionStatusDirectives.classes[n], assertionStatusDirectives.classEnabled[n]);
        }
        for (n = 0; n < assertionStatusDirectives.packages.length; ++n) {
            this.packageAssertionStatus.put(assertionStatusDirectives.packages[n], assertionStatusDirectives.packageEnabled[n]);
        }
        this.defaultAssertionStatus = assertionStatusDirectives.deflt;
    }

    private static native AssertionStatusDirectives retrieveDirectives();

    static {
        ClassLoader.registerNatives();
        loadedLibraryNames = new Vector();
        systemNativeLibraries = new Vector();
        nativeLibraryContext = new Stack();
    }

    static class NativeLibrary {
        long handle;
        private int jniVersion;
        private Class fromClass;
        String name;

        native void load(String var1);

        native long find(String var1);

        native void unload();

        public NativeLibrary(Class clazz, String string) {
            this.name = string;
            this.fromClass = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            Vector vector = loadedLibraryNames;
            synchronized (vector) {
                if (this.fromClass.getClassLoader() != null && this.handle != 0L) {
                    int n = loadedLibraryNames.size();
                    for (int i = 0; i < n; ++i) {
                        if (!this.name.equals(loadedLibraryNames.elementAt(i))) continue;
                        loadedLibraryNames.removeElementAt(i);
                        break;
                    }
                    nativeLibraryContext.push(this);
                    try {
                        this.unload();
                    }
                    finally {
                        nativeLibraryContext.pop();
                    }
                }
            }
        }

        static Class getFromClass() {
            return ((NativeLibrary)nativeLibraryContext.peek()).fromClass;
        }
    }
}

