/*
 * Decompiled with CFR 0.152.
 */
package sun.management.counter.perf;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.management.counter.AbstractCounter;
import sun.management.counter.Counter;
import sun.management.counter.Units;
import sun.management.counter.perf.InstrumentationException;
import sun.management.counter.perf.PerfByteArrayCounter;
import sun.management.counter.perf.PerfDataEntry;
import sun.management.counter.perf.PerfDataType;
import sun.management.counter.perf.PerfLongArrayCounter;
import sun.management.counter.perf.PerfLongCounter;
import sun.management.counter.perf.PerfStringCounter;
import sun.management.counter.perf.Prologue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfInstrumentation {
    private ByteBuffer buffer;
    private Prologue prologue;
    private long lastModificationTime;
    private long lastUsed;
    private int nextEntry;
    private SortedMap<String, Counter> map;

    public PerfInstrumentation(ByteBuffer byteBuffer) {
        this.prologue = new Prologue(byteBuffer);
        this.buffer = byteBuffer;
        this.buffer.order(this.prologue.getByteOrder());
        int n = this.getMajorVersion();
        int n2 = this.getMinorVersion();
        if (n < 2) {
            throw new InstrumentationException("Unsupported version: " + n + "." + n2);
        }
        this.rewind();
    }

    public int getMajorVersion() {
        return this.prologue.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.prologue.getMinorVersion();
    }

    public long getModificationTimeStamp() {
        return this.prologue.getModificationTimeStamp();
    }

    void rewind() {
        this.buffer.rewind();
        this.buffer.position(this.prologue.getEntryOffset());
        this.nextEntry = this.buffer.position();
        this.map = new TreeMap<String, Counter>();
    }

    boolean hasNext() {
        return this.nextEntry < this.prologue.getUsed();
    }

    Counter getNextCounter() {
        if (!this.hasNext()) {
            return null;
        }
        if (this.nextEntry % 4 != 0) {
            throw new InstrumentationException("Entry index not properly aligned: " + this.nextEntry);
        }
        if (this.nextEntry < 0 || this.nextEntry > this.buffer.limit()) {
            throw new InstrumentationException("Entry index out of bounds: nextEntry = " + this.nextEntry + ", limit = " + this.buffer.limit());
        }
        this.buffer.position(this.nextEntry);
        PerfDataEntry perfDataEntry = new PerfDataEntry(this.buffer);
        this.nextEntry += perfDataEntry.size();
        AbstractCounter abstractCounter = null;
        PerfDataType perfDataType = perfDataEntry.type();
        if (perfDataType == PerfDataType.BYTE) {
            if (perfDataEntry.units() == Units.STRING && perfDataEntry.vectorLength() > 0) {
                abstractCounter = new PerfStringCounter(perfDataEntry.name(), perfDataEntry.variability(), perfDataEntry.flags(), perfDataEntry.vectorLength(), perfDataEntry.byteData());
            } else if (perfDataEntry.vectorLength() > 0) {
                abstractCounter = new PerfByteArrayCounter(perfDataEntry.name(), perfDataEntry.units(), perfDataEntry.variability(), perfDataEntry.flags(), perfDataEntry.vectorLength(), perfDataEntry.byteData());
            } else assert (false);
        } else if (perfDataType == PerfDataType.LONG) {
            abstractCounter = perfDataEntry.vectorLength() == 0 ? new PerfLongCounter(perfDataEntry.name(), perfDataEntry.units(), perfDataEntry.variability(), perfDataEntry.flags(), perfDataEntry.longData()) : new PerfLongArrayCounter(perfDataEntry.name(), perfDataEntry.units(), perfDataEntry.variability(), perfDataEntry.flags(), perfDataEntry.vectorLength(), perfDataEntry.longData());
        } else assert (false);
        return abstractCounter;
    }

    public synchronized List<Counter> getAllCounters() {
        while (this.hasNext()) {
            Counter counter = this.getNextCounter();
            if (counter == null) continue;
            this.map.put(counter.getName(), counter);
        }
        return new ArrayList<Counter>(this.map.values());
    }

    public synchronized List<Counter> findByPattern(String string) {
        Serializable serializable;
        while (this.hasNext()) {
            serializable = this.getNextCounter();
            if (serializable == null) continue;
            this.map.put(serializable.getName(), (Counter)serializable);
        }
        serializable = Pattern.compile(string);
        Matcher matcher = ((Pattern)serializable).matcher("");
        ArrayList<Counter> arrayList = new ArrayList<Counter>();
        for (Map.Entry<String, Counter> entry : this.map.entrySet()) {
            String string2 = entry.getKey();
            matcher.reset(string2);
            if (!matcher.lookingAt()) continue;
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }
}

