/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server;

import com.sun.xml.internal.ws.server.DocInfo;
import com.sun.xml.internal.ws.server.RuntimeEndpointInfo;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.wsdl.parser.WSDLConstants;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLPatcher {
    private static final String NS_XSD = "http://www.w3.org/2001/XMLSchema";
    private static final QName QNAME_SCHEMA = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    private static final QName SCHEMA_INCLUDE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "include");
    private static final QName SCHEMA_IMPORT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "import");
    private static final QName ATTR_NAME_QNAME = new QName("", "name");
    private static final QName ATTR_TARGETNS_QNAME = new QName("", "targetNamespace");
    private static final QName WSDL_LOCATION_QNAME = new QName("", "location");
    private static final QName SCHEMA_LOCATION_QNAME = new QName("", "schemaLocation");
    private static final XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private static final XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    private static final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.wsdl.patcher");
    private DocInfo docInfo;
    private String baseAddress;
    private RuntimeEndpointInfo targetEndpoint;
    private List<RuntimeEndpointInfo> endpoints;

    public WSDLPatcher(DocInfo docInfo, String string, RuntimeEndpointInfo runtimeEndpointInfo, List<RuntimeEndpointInfo> list) {
        this.docInfo = docInfo;
        this.baseAddress = string;
        this.targetEndpoint = runtimeEndpointInfo;
        this.endpoints = list;
    }

    public void patchDoc(InputStream inputStream, OutputStream outputStream) {
        XMLEventReader xMLEventReader = null;
        XMLEventWriter xMLEventWriter = null;
        try {
            xMLEventReader = inputFactory.createXMLEventReader(inputStream);
            StartElement startElement = null;
            QName qName = null;
            QName qName2 = null;
            String string = null;
            while (xMLEventReader.hasNext()) {
                Object object;
                Object object2;
                XMLEvent xMLEvent = xMLEventReader.nextEvent();
                if (xMLEvent.isStartDocument()) {
                    object2 = (StartDocument)xMLEvent;
                    object = object2.encodingSet() ? object2.getCharacterEncodingScheme() : null;
                    xMLEventWriter = object != null ? outputFactory.createXMLEventWriter(outputStream, (String)object) : outputFactory.createXMLEventWriter(outputStream);
                } else if (xMLEvent.isStartElement()) {
                    startElement = xMLEvent.asStartElement();
                    object2 = startElement.getName();
                    if (((QName)object2).equals(SCHEMA_INCLUDE_QNAME)) {
                        xMLEvent = this.handleSchemaInclude(startElement);
                    } else if (((QName)object2).equals(SCHEMA_IMPORT_QNAME)) {
                        xMLEvent = this.handleSchemaImport(startElement);
                    } else if (((QName)object2).equals(WSDLConstants.QNAME_IMPORT)) {
                        xMLEvent = this.handleWSDLImport(startElement);
                    } else if (((QName)object2).equals(WSDLConstants.NS_SOAP_BINDING_ADDRESS) || ((QName)object2).equals(WSDLConstants.NS_SOAP12_BINDING_ADDRESS)) {
                        xMLEvent = this.handleSoapAddress(qName, qName2, startElement);
                    } else if (((QName)object2).equals(WSDLConstants.QNAME_DEFINITIONS)) {
                        object = startElement.getAttributeByName(ATTR_TARGETNS_QNAME);
                        if (object != null) {
                            string = object.getValue();
                        }
                    } else if (((QName)object2).equals(WSDLConstants.QNAME_SERVICE)) {
                        object = startElement.getAttributeByName(ATTR_NAME_QNAME);
                        if (object != null) {
                            qName = new QName(string, object.getValue());
                        }
                    } else if (((QName)object2).equals(WSDLConstants.QNAME_PORT) && (object = startElement.getAttributeByName(ATTR_NAME_QNAME)) != null) {
                        qName2 = new QName(string, object.getValue());
                    }
                } else if (xMLEvent.isEndElement()) {
                    startElement = null;
                }
                xMLEventWriter.add(xMLEvent);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ServerRtException("runtime.wsdl.patcher", new Object[]{xMLStreamException});
        }
        finally {
            if (xMLEventReader != null) {
                try {
                    xMLEventReader.close();
                }
                catch (XMLStreamException xMLStreamException) {
                    xMLStreamException.printStackTrace();
                }
            }
            if (xMLEventWriter != null) {
                try {
                    xMLEventWriter.close();
                }
                catch (XMLStreamException xMLStreamException) {
                    xMLStreamException.printStackTrace();
                }
            }
        }
    }

    private String getPatchedImportLocation(String string) {
        try {
            URL uRL = new URL(this.docInfo.getUrl(), string);
            String string2 = this.targetEndpoint.getQueryString(uRL);
            if (string2 == null) {
                return null;
            }
            String string3 = this.baseAddress + this.targetEndpoint.getUrlPatternWithoutStar() + "?" + string2;
            return string3;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private XMLEvent patchImport(StartElement startElement, QName qName) throws XMLStreamException {
        XMLEvent xMLEvent;
        Attribute attribute = startElement.getAttributeByName(qName);
        if (attribute == null) {
            return startElement;
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        Iterator iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            xMLEvent = (Attribute)iterator.next();
            String string = xMLEvent.getValue();
            if (xMLEvent.getName().equals(qName)) {
                String string2 = xMLEvent.getValue();
                String string3 = this.getPatchedImportLocation(string2);
                if (string3 == null) {
                    return startElement;
                }
                logger.fine("Fixing the relative location:" + string2 + " with absolute location:" + string3);
                Attribute attribute2 = eventFactory.createAttribute(qName, string3);
                arrayList.add(attribute2);
                continue;
            }
            arrayList.add((Attribute)xMLEvent);
        }
        xMLEvent = eventFactory.createStartElement(startElement.getName().getPrefix(), startElement.getName().getNamespaceURI(), startElement.getName().getLocalPart(), arrayList.iterator(), startElement.getNamespaces(), startElement.getNamespaceContext());
        return xMLEvent;
    }

    private XMLEvent handleSchemaImport(StartElement startElement) throws XMLStreamException {
        return this.patchImport(startElement, SCHEMA_LOCATION_QNAME);
    }

    private XMLEvent handleSchemaInclude(StartElement startElement) throws XMLStreamException {
        return this.patchImport(startElement, SCHEMA_LOCATION_QNAME);
    }

    private XMLEvent handleWSDLImport(StartElement startElement) throws XMLStreamException {
        return this.patchImport(startElement, WSDL_LOCATION_QNAME);
    }

    private XMLEvent handleSoapAddress(QName qName, QName qName2, StartElement startElement) throws XMLStreamException {
        XMLEvent xMLEvent;
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        Iterator iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            xMLEvent = (Attribute)iterator.next();
            String string = xMLEvent.getValue();
            if (xMLEvent.getName().equals(WSDL_LOCATION_QNAME)) {
                String string2 = this.getAddressLocation(qName, qName2);
                if (string2 == null) {
                    return startElement;
                }
                logger.fine("Fixing service:" + qName + " port:" + qName2 + " address with " + string2);
                Attribute attribute = eventFactory.createAttribute(WSDL_LOCATION_QNAME, string2);
                arrayList.add(attribute);
                continue;
            }
            arrayList.add((Attribute)xMLEvent);
        }
        xMLEvent = eventFactory.createStartElement(startElement.getName().getPrefix(), startElement.getName().getNamespaceURI(), startElement.getName().getLocalPart(), arrayList.iterator(), startElement.getNamespaces(), startElement.getNamespaceContext());
        return xMLEvent;
    }

    private String getAddressLocation(QName qName, QName qName2) {
        for (RuntimeEndpointInfo runtimeEndpointInfo : this.endpoints) {
            QName qName3 = runtimeEndpointInfo.getServiceName();
            QName qName4 = runtimeEndpointInfo.getPortName();
            if (qName3 == null || qName4 == null || qName == null || qName2 == null || !qName3.equals(qName) || !qName2.equals(qName4)) continue;
            return this.baseAddress + runtimeEndpointInfo.getUrlPatternWithoutStar();
        }
        return null;
    }
}

