/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jinfo;

import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import sun.tools.attach.HotSpotVirtualMachine;

public class JInfo {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            JInfo.usage();
        }
        boolean bl = true;
        String string = stringArray[0];
        if (string.startsWith("-")) {
            if (string.equals("-flags") || string.equals("-sysprops")) {
                if (stringArray.length != 2 && stringArray.length != 3) {
                    JInfo.usage();
                }
            } else if (string.equals("-flag")) {
                bl = false;
            } else {
                JInfo.usage();
            }
        }
        if (bl) {
            JInfo.runTool(stringArray);
        } else if (stringArray.length == 3) {
            String string2 = stringArray[2];
            String string3 = stringArray[1];
            JInfo.flag(string2, string3);
        } else {
            JInfo.usage();
        }
    }

    private static void runTool(String[] stringArray) throws Exception {
        String string = "sun.jvm.hotspot.tools.JInfo";
        Class clazz = JInfo.loadClass(string);
        if (clazz == null) {
            JInfo.usage();
        }
        Class[] classArray = new Class[]{String[].class};
        Method method = clazz.getDeclaredMethod("main", classArray);
        Object[] objectArray = new Object[]{stringArray};
        method.invoke(null, objectArray);
    }

    private static Class loadClass(String string) {
        try {
            return Class.forName(string, true, ClassLoader.getSystemClassLoader());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void flag(String string, String string2) throws IOException {
        InputStream inputStream;
        VirtualMachine virtualMachine = JInfo.attach(string);
        int n = string2.indexOf(61);
        if (n != -1) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            inputStream = ((HotSpotVirtualMachine)virtualMachine).setFlag(string3, string4);
        } else {
            char c = string2.charAt(0);
            switch (c) {
                case '+': {
                    String string5 = string2.substring(1);
                    inputStream = ((HotSpotVirtualMachine)virtualMachine).setFlag(string5, "1");
                    break;
                }
                case '-': {
                    String string6 = string2.substring(1);
                    inputStream = ((HotSpotVirtualMachine)virtualMachine).setFlag(string6, "0");
                    break;
                }
                default: {
                    String string7 = string2;
                    inputStream = ((HotSpotVirtualMachine)virtualMachine).printFlag(string7);
                }
            }
        }
        JInfo.drain(virtualMachine, inputStream);
    }

    private static VirtualMachine attach(String string) {
        try {
            return VirtualMachine.attach(string);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            if (string2 != null) {
                System.err.println(string + ": " + string2);
            } else {
                exception.printStackTrace();
            }
            System.exit(1);
            return null;
        }
    }

    private static void drain(VirtualMachine virtualMachine, InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[256];
        do {
            if ((n = inputStream.read(byArray)) <= 0) continue;
            String string = new String(byArray, 0, n, "UTF-8");
            System.out.print(string);
        } while (n > 0);
        inputStream.close();
        virtualMachine.detach();
    }

    private static void usage() {
        Class clazz = JInfo.loadClass("sun.jvm.hotspot.tools.JInfo");
        boolean bl = clazz != null;
        System.out.println("Usage:");
        if (bl) {
            System.out.println("    jinfo [option] <pid>");
            System.out.println("        (to connect to running process)");
            System.out.println("    jinfo [option] <executable <core>");
            System.out.println("        (to connect to a core file)");
            System.out.println("    jinfo [option] [server_id@]<remote server IP or hostname>");
            System.out.println("        (to connect to remote debug server)");
            System.out.println("");
            System.out.println("where <option> is one of:");
            System.out.println("    -flag <name>         to print the value of the named VM flag");
            System.out.println("    -flag [+|-]<name>    to enable or disable the named VM flag");
            System.out.println("    -flag <name>=<value> to set the named VM flag to the given value");
            System.out.println("    -flags               to print VM flags");
            System.out.println("    -sysprops            to print Java system properties");
            System.out.println("    <no option>          to print both of the above");
            System.out.println("    -h | -help           to print this help message");
        } else {
            System.out.println("    jinfo <option> <pid>");
            System.out.println("       (to connect to a running process)");
            System.out.println("");
            System.out.println("where <option> is one of:");
            System.out.println("    -flag <name>         to print the value of the named VM flag");
            System.out.println("    -flag [+|-]<name>    to enable or disable the named VM flag");
            System.out.println("    -flag <name>=<value> to set the named VM flag to the given value");
            System.out.println("    -h | -help           to print this help message");
        }
        System.exit(1);
    }
}

