/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.xsom.impl.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;

public class Uri {
    private static String utf8 = "UTF-8";
    private static final String HEX_DIGITS = "0123456789abcdef";
    private static String excluded = "<>\"{}|\\^`";

    public static boolean isValid(String string) {
        return Uri.isValidPercent(string) && Uri.isValidFragment(string) && Uri.isValidScheme(string);
    }

    public static String escapeDisallowedChars(String string) {
        StringBuffer stringBuffer = null;
        int n = string.length();
        int n2 = 0;
        while (true) {
            byte[] byArray;
            int n3 = n2;
            while (true) {
                if (n3 == n) {
                    if (n2 != 0) break;
                    return string;
                }
                if (Uri.isExcluded(string.charAt(n3))) break;
                ++n3;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            if (n3 > n2) {
                stringBuffer.append(string.substring(n2, n3));
                n2 = n3;
            }
            if (n3 == n) break;
            ++n3;
            while (n3 < n && Uri.isExcluded(string.charAt(n3))) {
                ++n3;
            }
            String string2 = string.substring(n2, n3);
            try {
                byArray = string2.getBytes(utf8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                utf8 = "UTF8";
                try {
                    byArray = string2.getBytes(utf8);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    return string;
                }
            }
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append('%');
                stringBuffer.append(HEX_DIGITS.charAt((byArray[i] & 0xFF) >> 4));
                stringBuffer.append(HEX_DIGITS.charAt(byArray[i] & 0xF));
            }
            n2 = n3;
        }
        return stringBuffer.toString();
    }

    private static boolean isExcluded(char c) {
        return c <= ' ' || c >= '\u007f' || excluded.indexOf(c) >= 0;
    }

    private static boolean isAlpha(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private static boolean isHexDigit(char c) {
        return 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F' || Uri.isDigit(c);
    }

    private static boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private static boolean isSchemeChar(char c) {
        return Uri.isAlpha(c) || Uri.isDigit(c) || c == '+' || c == '-' || c == '.';
    }

    private static boolean isValidPercent(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '%') continue;
            if (i + 2 >= n) {
                return false;
            }
            if (Uri.isHexDigit(string.charAt(i + 1)) && Uri.isHexDigit(string.charAt(i + 2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidFragment(String string) {
        int n = string.indexOf(35);
        return n < 0 || string.indexOf(35, n + 1) < 0;
    }

    private static boolean isValidScheme(String string) {
        if (!Uri.isAbsolute(string)) {
            return true;
        }
        int n = string.indexOf(58);
        if (n == 0 || n + 1 == string.length() || !Uri.isAlpha(string.charAt(0))) {
            return false;
        }
        while (--n > 0) {
            if (Uri.isSchemeChar(string.charAt(n))) continue;
            return false;
        }
        return true;
    }

    public static String resolve(String string, String string2) throws IOException {
        if (Uri.isAbsolute(string2)) {
            return string2;
        }
        if (string == null) {
            throw new IOException("Unable to resolve relative URI " + string2 + " without a base URI");
        }
        if (!Uri.isAbsolute(string)) {
            throw new IOException("Unable to resolve relative URI " + string2 + " because base URI is not absolute: " + string);
        }
        return new URL(new URL(string), string2).toString();
    }

    public static boolean hasFragmentId(String string) {
        return string.indexOf(35) >= 0;
    }

    public static boolean isAbsolute(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return false;
        }
        while (--n >= 0) {
            switch (string.charAt(n)) {
                case '#': 
                case '/': 
                case '?': {
                    return false;
                }
            }
        }
        return true;
    }
}

