/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.generator.bean;

import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JDefinedClass;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JPackage;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlElementDeclWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlRegistryWriter;
import com.sun.tools.internal.xjc.generator.bean.BeanGenerator;
import com.sun.tools.internal.xjc.generator.bean.ClassOutlineImpl;
import com.sun.tools.internal.xjc.generator.bean.Messages;
import com.sun.tools.internal.xjc.generator.bean.ObjectFactoryGenerator;
import com.sun.tools.internal.xjc.model.CClassInfo;
import com.sun.tools.internal.xjc.model.CElementInfo;
import com.sun.tools.internal.xjc.model.CPropertyInfo;
import com.sun.tools.internal.xjc.model.Constructor;
import com.sun.tools.internal.xjc.model.Model;
import com.sun.tools.internal.xjc.outline.Aspect;
import com.sun.tools.internal.xjc.outline.FieldAccessor;
import com.sun.tools.internal.xjc.outline.FieldOutline;
import com.sun.xml.internal.bind.v2.TODO;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;

abstract class ObjectFactoryGeneratorImpl
extends ObjectFactoryGenerator {
    private final BeanGenerator outline;
    private final Model model;
    private final JCodeModel codeModel;
    private final JClass classRef;
    private final JDefinedClass objectFactory;
    private final HashMap<QName, JFieldVar> qnameMap = new HashMap();
    private final Map<String, CElementInfo> elementFactoryNames = new HashMap<String, CElementInfo>();
    private final Map<String, ClassOutlineImpl> valueFactoryNames = new HashMap<String, ClassOutlineImpl>();

    public JDefinedClass getObjectFactory() {
        return this.objectFactory;
    }

    public ObjectFactoryGeneratorImpl(BeanGenerator beanGenerator, Model model, JPackage jPackage) {
        this.outline = beanGenerator;
        this.model = model;
        this.codeModel = this.model.codeModel;
        this.classRef = this.codeModel.ref(Class.class);
        this.objectFactory = this.outline.getClassFactory().createClass(jPackage, "ObjectFactory", null);
        this.objectFactory.annotate2(XmlRegistryWriter.class);
        JMethod jMethod = this.objectFactory.constructor(1);
        jMethod.javadoc().append("Create a new ObjectFactory that can be used to create new instances of schema derived classes for package: " + jPackage.name());
        this.objectFactory.javadoc().append("This object contains factory methods for each \nJava content interface and Java element interface \ngenerated in the " + jPackage.name() + " package. \n" + "<p>An ObjectFactory allows you to programatically \n" + "construct new instances of the Java representation \n" + "for XML content. The Java representation of XML \n" + "content can consist of schema derived interfaces \n" + "and classes representing the binding of schema \n" + "type definitions, element declarations and model \n" + "groups.  Factory methods for each of these are \n" + "provided in this class.");
    }

    protected final void populate(CElementInfo cElementInfo, Aspect aspect, Aspect aspect2) {
        Object object;
        JType jType = cElementInfo.toType(this.outline, aspect2);
        JType jType2 = cElementInfo.getContentInMemoryType().toType(this.outline, aspect2);
        JType jType3 = cElementInfo.getContentInMemoryType().toType(this.outline, aspect);
        String string = cElementInfo.getElementName().getNamespaceURI();
        String string2 = cElementInfo.getElementName().getLocalPart();
        JClass jClass = null;
        if (cElementInfo.getScope() != null) {
            jClass = this.outline.getClazz((CClassInfo)cElementInfo.getScope()).implRef;
        }
        if (cElementInfo.isAbstract()) {
            TODO.checkSpec();
        }
        if ((object = this.elementFactoryNames.put(cElementInfo.getSqueezedName(), cElementInfo)) != null) {
            this.outline.getErrorReceiver().error(((CElementInfo)object).getLocator(), Messages.OBJECT_FACTORY_CONFLICT.format(cElementInfo.getSqueezedName()));
            this.outline.getErrorReceiver().error(cElementInfo.getLocator(), Messages.OBJECT_FACTORY_CONFLICT_RELATED.format(new Object[0]));
            return;
        }
        JMethod jMethod = this.objectFactory.method(1, jType, "create" + cElementInfo.getSqueezedName());
        object = jMethod.param(jType2, "value");
        JExpression jExpression = jType3.boxify().isParameterized() || !jType2.equals(jType3) ? JExpr.cast(this.classRef, jType3.boxify().dotclass()) : jType3.boxify().dotclass();
        JExpression jExpression2 = jClass == null ? JExpr._null() : jClass.dotclass();
        JInvocation jInvocation = JExpr._new(jType);
        if (!cElementInfo.hasClass()) {
            jInvocation.arg(this.getQNameInvocation(cElementInfo));
            jInvocation.arg(jExpression);
            jInvocation.arg(jExpression2);
        }
        if (jType3 == jType2) {
            jInvocation.arg((JExpression)object);
        } else {
            jInvocation.arg(JExpr.cast(jType3, (JExpression)object));
        }
        jMethod.body()._return(jInvocation);
        jMethod.javadoc().append("Create an instance of ").append(jType).append("}");
        XmlElementDeclWriter xmlElementDeclWriter = jMethod.annotate2(XmlElementDeclWriter.class);
        xmlElementDeclWriter.namespace(string).name(string2);
        if (jClass != null) {
            xmlElementDeclWriter.scope(jClass);
        }
        if (cElementInfo.getSubstitutionHead() != null) {
            QName qName = cElementInfo.getSubstitutionHead().getElementName();
            xmlElementDeclWriter.substitutionHeadNamespace(qName.getNamespaceURI());
            xmlElementDeclWriter.substitutionHeadName(qName.getLocalPart());
        }
        if (cElementInfo.getDefaultValue() != null) {
            xmlElementDeclWriter.defaultValue(cElementInfo.getDefaultValue());
        }
        this.outline.generateAdapterIfNecessary(cElementInfo.getProperty(), jMethod);
    }

    private JExpression getQNameInvocation(CElementInfo cElementInfo) {
        QName qName = cElementInfo.getElementName();
        if (this.qnameMap.containsKey(qName)) {
            return this.qnameMap.get(qName);
        }
        if (this.qnameMap.size() > 1024) {
            return this.createQName(qName);
        }
        JFieldVar jFieldVar = this.objectFactory.field(28, QName.class, '_' + cElementInfo.getSqueezedName() + "_QNAME", (JExpression)this.createQName(qName));
        this.qnameMap.put(qName, jFieldVar);
        return jFieldVar;
    }

    private JInvocation createQName(QName qName) {
        return JExpr._new(this.codeModel.ref(QName.class)).arg(qName.getNamespaceURI()).arg(qName.getLocalPart());
    }

    protected final void populate(ClassOutlineImpl classOutlineImpl, JClass jClass) {
        Object object;
        Object object2;
        Object object3;
        if (!classOutlineImpl.target.isAbstract()) {
            object3 = this.objectFactory.method(1, jClass, "create" + classOutlineImpl.target.getSqueezedName());
            ((JMethod)object3).body()._return(JExpr._new(classOutlineImpl.implRef));
            ((JMethod)object3).javadoc().append("Create an instance of ").append(classOutlineImpl.ref);
        }
        if ((object3 = classOutlineImpl.target.getConstructors()).size() != 0) {
            classOutlineImpl.implClass.constructor(1);
        }
        if ((object2 = this.valueFactoryNames.put((String)(object = classOutlineImpl.target.getSqueezedName()), classOutlineImpl)) != null) {
            this.outline.getErrorReceiver().error(((ClassOutlineImpl)object2).target.getLocator(), Messages.OBJECT_FACTORY_CONFLICT.format(object));
            this.outline.getErrorReceiver().error(classOutlineImpl.target.getLocator(), Messages.OBJECT_FACTORY_CONFLICT_RELATED.format(new Object[0]));
            return;
        }
        object = object3.iterator();
        while (object.hasNext()) {
            object2 = (Constructor)object.next();
            JMethod jMethod = this.objectFactory.method(1, classOutlineImpl.ref, "create" + classOutlineImpl.target.getSqueezedName());
            JInvocation jInvocation = JExpr._new(classOutlineImpl.implRef);
            jMethod.body()._return(jInvocation);
            jMethod.javadoc().append("Create an instance of ").append(classOutlineImpl.ref).addThrows(JAXBException.class).append("if an error occurs");
            JMethod jMethod2 = classOutlineImpl.implClass.constructor(1);
            for (String string : ((Constructor)object2).fields) {
                CPropertyInfo cPropertyInfo = classOutlineImpl.target.getProperty(string);
                if (cPropertyInfo == null) {
                    this.outline.getErrorReceiver().error(classOutlineImpl.target.getLocator(), Messages.ILLEGAL_CONSTRUCTOR_PARAM.format(string));
                    continue;
                }
                string = ObjectFactoryGeneratorImpl.camelize(string);
                FieldOutline fieldOutline = this.outline.getField(cPropertyInfo);
                FieldAccessor fieldAccessor = fieldOutline.create(JExpr._this());
                jInvocation.arg(jMethod.param(fieldOutline.getRawType(), string));
                JVar jVar = jMethod2.param(fieldOutline.getRawType(), string);
                fieldAccessor.fromRawValue(jMethod2.body(), '_' + string, jVar);
            }
        }
    }

    private static String camelize(String string) {
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }
}

