/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc;

import com.sun.codemodel.internal.CodeWriter;
import com.sun.codemodel.internal.JPackage;
import com.sun.codemodel.internal.writer.FilterCodeWriter;
import com.sun.tools.internal.xjc.XJCListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

final class ProgressCodeWriter
extends FilterCodeWriter {
    private int current;
    private final int totalFileCount;
    private final XJCListener progress;

    public ProgressCodeWriter(CodeWriter codeWriter, XJCListener xJCListener, int n) {
        super(codeWriter);
        this.progress = xJCListener;
        this.totalFileCount = n;
        if (xJCListener == null) {
            throw new IllegalArgumentException();
        }
    }

    public Writer openSource(JPackage jPackage, String string) throws IOException {
        this.report(jPackage, string);
        return super.openSource(jPackage, string);
    }

    public OutputStream openBinary(JPackage jPackage, String string) throws IOException {
        this.report(jPackage, string);
        return super.openBinary(jPackage, string);
    }

    private void report(JPackage jPackage, String string) {
        String string2 = jPackage.name().replace('.', File.separatorChar);
        if (string2.length() != 0) {
            string2 = string2 + File.separatorChar;
        }
        string2 = string2 + string;
        this.progress.generatedFile(string2, this.current++, this.totalFileCount);
    }
}

