/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.connection.internal.ui.wizards.helper;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.rdb.connection.internal.ui.providers.IServerConnectionUIProvider;


public class ConnectionUIHelper
{
    private Map providerConnectionMap;
 
    private Map driverNameContribution = new HashMap ();
    private Map configurationElement = new HashMap ();

    private String product;
    private String version;
    private String defaultDriver = ""; //$NON-NLS-1$
    
    public ConnectionUIHelper (String product, String version, HashMap providerConnectionMap)
    {
        this.product = product;
        this.version = version;
        this.providerConnectionMap = providerConnectionMap;
    }
    
    /**
     * @return true if the definition is being supported
     */
    private boolean isDefinitionSupported(IConfigurationElement definition)
    {
        if (definition.getAttribute("version").equals(version) && definition.getAttribute("product").equals(product) || //$NON-NLS-1$ //$NON-NLS-2$
                definition.getAttribute("version").equals("*") && definition.getAttribute("product").equals("*")) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
        {
            return true;
        }
        return false;
    }

    private void registerDriverNames (IConfigurationElement element)
    {
        String driverName = element.getAttribute("driverName"); //$NON-NLS-1$
        String uiContributor = element.getAttribute("uiContributor"); //$NON-NLS-1$
        String isDefault = element.getAttribute("isDefault"); //$NON-NLS-1$
        
        if ((isDefault != null) && (isDefault.equals("true"))){ //$NON-NLS-1$
            defaultDriver = driverName;
        }
        driverNameContribution.put (driverName, uiContributor);
        configurationElement.put(uiContributor, element);
    }
    
    public String [] getDriverNames ()
    {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.wst.rdb.connection.ui", "connectionUIProvider"); //$NON-NLS-1$ //$NON-NLS-2$
        IExtension[] extensions = extensionPoint.getExtensions();
        for (int i = 0; i < extensions.length; ++i)
        {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            for (int j = 0; j < configElements.length; ++j)
            {
                if (configElements[j].getName().equals("databaseDefinition")) //$NON-NLS-1$
                {
                    if (isDefinitionSupported(configElements[j]))
                    {
                        for (int k = 0; k < configElements.length; k++)
                        {
                            if (configElements[k].getName().equals("driverContribution")) //$NON-NLS-1$
                            {
                                registerDriverNames (configElements[k]);
                            }
                        }
                        break;
                    }
                }
            }
        }
        return (String[]) driverNameContribution.keySet().toArray(new String [driverNameContribution.keySet().size()]);
    }

    public IServerConnectionUIProvider getUIProvider (String driverName)
    {
        if (driverName == null || driverName.equals("")) //$NON-NLS-1$
        {
            return null;
        }
        try
        {
            String uiContributor = (String) driverNameContribution.get(driverName);
            if (providerConnectionMap.containsKey(uiContributor))
            {
                return (IServerConnectionUIProvider) providerConnectionMap.get(uiContributor);
            }
            else
            {
                IConfigurationElement element = (IConfigurationElement) configurationElement.get(uiContributor);
                IServerConnectionUIProvider provider = (IServerConnectionUIProvider) element.createExecutableExtension("uiContributor"); //$NON-NLS-1$
                providerConnectionMap.put(uiContributor, provider);
                return provider;
            }
        }
        catch (CoreException e)
        {
            e.printStackTrace();
            return null;
        }
    }
    
    public String getDefaultDriver(){
        return defaultDriver;
    }
}
