/*******************************************************************************
* Copyright (c) 2000, 2005 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/

package org.eclipse.wst.rdb.internal.outputview;

public interface IXMLResult
{
	/**
	 * Initializes the object to hold the XML result.
	 * <p>
	 * This method will be called first by the Extension-point
	 * @param xResult the ResultSet or ProcedureCallCache containing the
	 * XML document
	 * @param column the column in the result set that the document resides
	 * @exception throws exception if the ResultSet or ProcedureCallCache were closed
	 */
	public void initXMLResult(Object xResult, int column) throws Exception;
	
	/**
	 * Gets the vendor-specific implementation of the XML object
	 * @return the vendor-specific XML object
	 */
	public Object getXMLObject();
	
	/**
	 * Gets the initial content of an XML document
	 * @param numChars the number of characters to retrieve
	 * @return the initial content of the document from beginning up to numChars length
	 */
	public String getInitialValue(int numChars);
	
	/**
	 * Gets the entire content of the XML document
	 * @return the content of the whole XML document
	 */
	public String getEntireDocument();
}
