/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.sqleditor.internal.editor;

import org.eclipse.jface.text.DefaultAutoIndentStrategy;
import org.eclipse.jface.text.IAutoIndentStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditor;
import org.eclipse.wst.rdb.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.wst.rdb.sqleditor.internal.sql.ISQLDBProposalsService;
import org.eclipse.wst.rdb.sqleditor.internal.sql.SQLAnnotationHover;
import org.eclipse.wst.rdb.sqleditor.internal.sql.SQLAutoIndentStrategy;
import org.eclipse.wst.rdb.sqleditor.internal.sql.SQLCompletionProcessor;
import org.eclipse.wst.rdb.sqleditor.internal.sql.SQLDoubleClickStrategy;
import org.eclipse.wst.rdb.sqleditor.internal.sql.SQLTextHover;
import org.eclipse.wst.rdb.sqleditor.internal.sql.SQLUpperCaseFormattingStrategy;
import org.eclipse.wst.rdb.sqleditor.internal.utils.SQLColorProvider;

public class SQLSourceViewerConfiguration
extends SourceViewerConfiguration {
    private SQLEditor fEditor;
    private SQLCompletionProcessor fCompletionProcessor;
    private ISQLDBProposalsService fDBProposalsService;

    public SQLSourceViewerConfiguration(SQLEditor editor) {
        this.fEditor = editor;
        this.fCompletionProcessor = new SQLCompletionProcessor();
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new SQLAnnotationHover();
    }

    public IAutoIndentStrategy getAutoIndentStrategy(ISourceViewer sourceViewer, String contentType) {
        return "__dftl_partition_content_type".equals(contentType) ? new SQLAutoIndentStrategy() : new DefaultAutoIndentStrategy();
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__sql_partitioning";
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        this.fCompletionProcessor = new SQLCompletionProcessor();
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fCompletionProcessor, "__dftl_partition_content_type");
        ISQLDBProposalsService proposalsService = this.getDBProposalsService();
        if (proposalsService != null) {
            this.fCompletionProcessor.setDBProposalsService(proposalsService);
        }
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(12);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setContextInformationPopupBackground(SQLEditorPlugin.getDefault().getSQLColorProvider().getColor(new RGB(150, 150, 0)));
        return assistant;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        ContentFormatter formatter = new ContentFormatter();
        formatter.setDocumentPartitioning("__sql_partitioning");
        SQLUpperCaseFormattingStrategy formattingStrategy = new SQLUpperCaseFormattingStrategy();
        formatter.setFormattingStrategy((IFormattingStrategy)formattingStrategy, "__dftl_partition_content_type");
        return formatter;
    }

    public ISQLDBProposalsService getDBProposalsService() {
        return this.fDBProposalsService;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new SQLDoubleClickStrategy();
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        SQLColorProvider colorProvider = this.getSQLEditor().getSQLColorProvider();
        PresentationReconciler reconciler = new PresentationReconciler();
        String docPartitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
        reconciler.setDocumentPartitioning(docPartitioning);
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getSQLEditor().getSQLCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_COMMENT_COLOR))));
        reconciler.setDamager((IPresentationDamager)dr, "__sql_comment__");
        reconciler.setRepairer((IPresentationRepairer)dr, "__sql_comment__");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_QUOTED_LITERAL_COLOR))));
        reconciler.setDamager((IPresentationDamager)dr, "__sql_quoted_literal__");
        reconciler.setRepairer((IPresentationRepairer)dr, "__sql_quoted_literal__");
        dr = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(colorProvider.getColor(SQLColorProvider.SQL_DELIMITED_IDENTIFIER_COLOR))));
        reconciler.setDamager((IPresentationDamager)dr, "__sql_delimited_identifier__");
        reconciler.setRepairer((IPresentationRepairer)dr, "__sql_delimited_identifier__");
        return reconciler;
    }

    public SQLEditor getSQLEditor() {
        return this.fEditor;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new SQLTextHover();
    }

    public void setDBProposalsService(ISQLDBProposalsService dbProposalsService) {
        this.fDBProposalsService = dbProposalsService;
        if (this.fCompletionProcessor != null) {
            this.fCompletionProcessor.setDBProposalsService(dbProposalsService);
        }
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

