/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions;

import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Part;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.XMLUtils;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions.WSDLPropertiesFormAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLOperationElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.InvokeWSDLOperationTool;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SynchronizeFragmentViewsAction
extends WSDLPropertiesFormAction {
    public SynchronizeFragmentViewsAction(Controller controller) {
        super(controller);
    }

    protected boolean processParsedResults(MultipartFormDataParser parser) throws MultipartFormDataException {
        super.processParsedResults(parser);
        Node selectedNode = this.getSelectedNavigatorNode();
        WSDLOperationElement operElement = (WSDLOperationElement)selectedNode.getTreeElement();
        Iterator it = operElement.getOrderedBodyParts().iterator();
        InvokeWSDLOperationTool invokeWSDLOperationTool = (InvokeWSDLOperationTool)selectedNode.getCurrentToolManager().getSelectedTool();
        String viewID = parser.getParameter("::fragmentViewID");
        this.propertyTable_.put("::fragmentViewID", viewID);
        if (viewID.equals("::fragmentViewSwitchFormToSource")) {
            invokeWSDLOperationTool.setFragmentViewID("::fragmentViewSwitchFormToSource");
            return this.processFormViewParsedResults(parser, operElement, it);
        }
        invokeWSDLOperationTool.setFragmentViewID("::fragmentViewSwitchSourceToForm");
        return this.processSourceViewParsedResults(parser, operElement, it);
    }

    private boolean processFormViewParsedResults(MultipartFormDataParser parser, WSDLOperationElement operElement, Iterator it) throws MultipartFormDataException {
        operElement.setPropertyAsObject("propSourceContent", null);
        operElement.setPropertyAsObject("propSourceContentNS", null);
        boolean resultsValid = true;
        while (it.hasNext()) {
            Part part = (Part)it.next();
            IXSDFragment frag = operElement.getFragment(part);
            if (frag.processParameterValues(parser)) continue;
            resultsValid = false;
        }
        if (resultsValid) {
            operElement.setPropertyAsString("propSourceContent", null);
        }
        return resultsValid;
    }

    private boolean processSourceViewParsedResults(MultipartFormDataParser parser, WSDLOperationElement operElement, Iterator it) throws MultipartFormDataException {
        String[] nsDeclarations;
        String sourceContent = parser.getParameter("::sourceContent");
        if (sourceContent != null) {
            operElement.setPropertyAsString("propSourceContent", sourceContent);
        }
        if ((nsDeclarations = parser.getParameterValues("::sourceContentNS")) != null) {
            operElement.setPropertyAsObject("propSourceContentNS", nsDeclarations);
        }
        sourceContent = this.addRootElement(sourceContent);
        try {
            Element sourceElements = XMLUtils.stringToElement(sourceContent);
            NodeList nl = sourceElements.getChildNodes();
            Vector<org.w3c.dom.Node> elementsVector = new Vector<org.w3c.dom.Node>();
            int i = 0;
            while (i < nl.getLength()) {
                org.w3c.dom.Node node = nl.item(i);
                if (node != null && node instanceof Element) {
                    elementsVector.add(node);
                }
                ++i;
            }
            Object[] instanceDocuments = new Element[elementsVector.size()];
            elementsVector.copyInto(instanceDocuments);
            boolean sourceElementsValid = true;
            while (it.hasNext()) {
                Part part = (Part)it.next();
                IXSDFragment frag = operElement.getFragment(part);
                if (frag.setParameterValuesFromInstanceDocuments((Element[])instanceDocuments)) continue;
                sourceElementsValid = false;
            }
            return sourceElementsValid;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private String addRootElement(String element) {
        StringBuffer sb = new StringBuffer();
        sb.append("<root>");
        sb.append(element);
        sb.append("</root>");
        return sb.toString();
    }

    public boolean run() {
        return true;
    }
}

