/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;

public final class MultipartFormDataParser {
    private Hashtable paramTable_;
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_MULTIPART = "multipart";
    private static final String HEADER_BOUNDARY = "boundary=";
    private static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition: form-data";
    private static final String HEADER_NAME = "name=\"";
    private static final byte PARSER_STATE_INITIAL = 0;
    private static final byte PARSER_STATE_BOUNDARY = 1;
    private static final byte PARSER_STATE_PARAMETER = 2;
    private static final byte PARSER_STATE_BLANK = 3;
    private static final byte PARSER_STATE_DATA = 4;
    private static String[] parserStates = new String[]{"initial", "boundary", "parameter name", "blank line", "data"};

    public MultipartFormDataParser() {
    }

    public MultipartFormDataParser(Hashtable parameters) {
        this.paramTable_ = new Hashtable();
        Iterator it = parameters.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = parameters.get(key);
            if (value instanceof List) {
                List list = (List)value;
                Iterator it2 = list.iterator();
                while (it2.hasNext()) {
                    this.saveData(key.toString(), it2.next().toString());
                }
                continue;
            }
            if (value.getClass().isArray()) {
                Object[] array = (Object[])value;
                int i = 0;
                while (i < array.length) {
                    this.saveData(key.toString(), array[i].toString());
                    ++i;
                }
                continue;
            }
            this.saveData(key.toString(), value.toString());
        }
    }

    public final void parseRequest(HttpServletRequest request, String encoding) throws MultipartFormDataException {
        String contentType = request.getHeader(HEADER_CONTENT_TYPE);
        if (contentType == null || !contentType.startsWith(HEADER_MULTIPART) || contentType.indexOf(HEADER_BOUNDARY) == -1) {
            throw new MultipartFormDataException("Content-Type is not multipart/form-data");
        }
        String boundary = contentType.substring(contentType.indexOf(HEADER_BOUNDARY) + HEADER_BOUNDARY.length(), contentType.length());
        if (boundary.charAt(0) == '\"' && boundary.charAt(boundary.length() - 1) == '\"') {
            boundary = boundary.substring(1, boundary.length() - 1);
        }
        String delimiter = "--" + boundary;
        if (this.paramTable_ == null) {
            this.paramTable_ = new Hashtable();
        } else {
            this.paramTable_.clear();
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), encoding));
            String line = null;
            String parameterName = null;
            StringBuffer parameterValue = new StringBuffer();
            int currentParserState = 0;
            while ((line = br.readLine()) != null) {
                byte[] expectedParserStates;
                if (line.startsWith(delimiter)) {
                    byte[] byArray = new byte[2];
                    byArray[1] = 4;
                    expectedParserStates = byArray;
                    if (this.isValidParserState((byte)currentParserState, expectedParserStates)) {
                        if (parameterName != null) {
                            this.saveData(parameterName, parameterValue.toString());
                            parameterName = null;
                            parameterValue.setLength(0);
                        }
                        currentParserState = 1;
                        continue;
                    }
                    throw new MultipartFormDataException(this.getParserExceptionMessage((byte)currentParserState, expectedParserStates));
                }
                if (line.startsWith(HEADER_CONTENT_DISPOSITION)) {
                    expectedParserStates = new byte[]{1};
                    if (!this.isValidParserState((byte)currentParserState, expectedParserStates)) continue;
                    int parameterNameStartingPosition = line.indexOf(HEADER_NAME) + HEADER_NAME.length();
                    parameterName = line.substring(parameterNameStartingPosition, parameterNameStartingPosition + line.substring(parameterNameStartingPosition).indexOf(34));
                    currentParserState = 2;
                    continue;
                }
                if (currentParserState == 2) {
                    currentParserState = 3;
                    continue;
                }
                if (parameterValue.length() > 0) {
                    parameterValue.append('\n');
                }
                parameterValue.append(line);
                currentParserState = 4;
            }
        }
        catch (Throwable t) {
            throw new MultipartFormDataException(t.getMessage());
        }
    }

    public final String getParameter(String parameter) throws MultipartFormDataException {
        if (this.paramTable_ == null) {
            throw new MultipartFormDataException("Parser contains no parsed data");
        }
        Vector values = (Vector)this.paramTable_.get(parameter);
        return values != null ? (String)values.elementAt(0) : null;
    }

    public final String[] getParameterValues(String parameter) throws MultipartFormDataException {
        if (this.paramTable_ == null) {
            throw new MultipartFormDataException("Parser contains no parsed data");
        }
        Vector valuesVector = (Vector)this.paramTable_.get(parameter);
        if (valuesVector == null) {
            return null;
        }
        String[] valuesArray = new String[valuesVector.size()];
        int i = 0;
        while (i < valuesArray.length) {
            valuesArray[i] = (String)valuesVector.elementAt(i);
            ++i;
        }
        return valuesArray;
    }

    public final String[] getParameterNames() throws MultipartFormDataException {
        if (this.paramTable_ == null) {
            throw new MultipartFormDataException("Parser contains no parsed data");
        }
        int size = this.paramTable_.size();
        if (size == 0) {
            return null;
        }
        String[] names = new String[size];
        Enumeration keys = this.paramTable_.keys();
        int i = 0;
        while (i < size) {
            names[i] = (String)keys.nextElement();
            ++i;
        }
        return names;
    }

    private final void saveData(String parameterName, String parameterValue) {
        Vector<String> values = (Vector<String>)this.paramTable_.get(parameterName);
        if (values == null) {
            values = new Vector<String>();
        }
        values.addElement(parameterValue);
        this.paramTable_.put(parameterName, values);
    }

    private final boolean isValidParserState(byte currentState, byte[] expectedStates) {
        boolean validity = false;
        int i = 0;
        while (i < expectedStates.length) {
            if (currentState == expectedStates[i]) {
                validity = true;
                break;
            }
            ++i;
        }
        return validity;
    }

    private final String getParserExceptionMessage(byte currentState, byte[] expectedStates) {
        StringBuffer msg = new StringBuffer("Parser state inconsistency!");
        msg.append('\n');
        msg.append("Current state    : ").append(parserStates[currentState]).append('\n');
        msg.append("Expected state(s): ");
        int i = 0;
        while (i < expectedStates.length) {
            msg.append(parserStates[expectedStates[i]]);
            if (i != expectedStates.length - 1) {
                msg.append(", ");
            }
            ++i;
        }
        msg.append('\n');
        return msg.toString();
    }
}

