/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.audio;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.audio.Sound;
import org.osgi.framework.Bundle;

public class AudioCore {
    protected static AudioCore instance;
    public static final String PREF_SOUND_ENABLED = "soundEnabled";
    public static final String PREF_VOLUME = "volume";
    public static final String SOUNDS_FILE = "sounds.xml";
    public static final String DISABLED_FILE = "disabled-sounds.xml";
    private Map categories;
    private Map sounds;
    private List disabledSounds;
    private List disabledCategories;
    private Map userSoundMap;
    static /* synthetic */ Class class$0;

    private AudioCore() {
        this.loadExtensionPoints();
        this.loadSoundMap();
        this.loadDisabledLists();
    }

    protected Map getCategories() {
        return this.categories;
    }

    protected static Clip getClip(URL url) {
        try {
            Class<?> clazz;
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(url);
            AudioFormat format = audioInputStream.getFormat();
            if (format.getEncoding() == AudioFormat.Encoding.ULAW || format.getEncoding() == AudioFormat.Encoding.ALAW) {
                AudioFormat tmp = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), format.getSampleSizeInBits() * 2, format.getChannels(), format.getFrameSize() * 2, format.getFrameRate(), true);
                audioInputStream = AudioSystem.getAudioInputStream(tmp, audioInputStream);
                format = tmp;
            }
            if ((clazz = class$0) == null) {
                try {
                    clazz = class$0 = Class.forName("javax.sound.sampled.Clip");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            DataLine.Info info = new DataLine.Info(clazz, audioInputStream.getFormat(), (int)audioInputStream.getFrameLength() * format.getFrameSize());
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(audioInputStream);
            return clip;
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not get clip: " + url, e);
            return null;
        }
    }

    protected static boolean isAudioSupported() {
        try {
            boolean sound = false;
            Mixer.Info[] info2 = AudioSystem.getMixerInfo();
            if (info2 != null) {
                int size = info2.length;
                int i = 0;
                while (i < size) {
                    Mixer mixer = AudioSystem.getMixer(info2[i]);
                    if (mixer != null) {
                        try {
                            Line.Info info = mixer.getLineInfo();
                            Line line = mixer.getLine(info);
                            if (line != null && line.toString().indexOf("Output") >= 0) {
                                sound = true;
                            }
                        }
                        catch (Exception exception) {}
                    }
                    ++i;
                }
            }
            return sound;
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not verify audio status", e);
            return true;
        }
    }

    public boolean getDefaultSoundsEnabled() {
        return this.getPreferenceStore().getDefaultBoolean(PREF_SOUND_ENABLED);
    }

    public int getDefaultVolume() {
        return this.getPreferenceStore().getDefaultInt(PREF_VOLUME);
    }

    public static AudioCore getInstance() {
        if (instance == null) {
            instance = new AudioCore();
        }
        return instance;
    }

    protected IPreferenceStore getPreferenceStore() {
        return ServerUIPlugin.getInstance().getPreferenceStore();
    }

    protected Sound getSound(String id) {
        try {
            return (Sound)this.sounds.get(id);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Map getSounds() {
        return this.sounds;
    }

    protected Map getUserSoundMap() {
        if (this.userSoundMap == null) {
            this.loadSoundMap();
        }
        return this.userSoundMap;
    }

    protected IPath getUserSoundPath(String id) {
        try {
            IPath path;
            if (this.userSoundMap == null) {
                this.loadSoundMap();
            }
            if ((path = (IPath)this.userSoundMap.get(id)) != null) {
                return path;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not get sound URL: " + id, e);
        }
        return null;
    }

    public int getVolume() {
        return this.getPreferenceStore().getInt(PREF_VOLUME);
    }

    public static void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(PREF_VOLUME, 18);
    }

    public boolean isCategoryEnabled(String id) {
        if (id == null) {
            return false;
        }
        if (this.disabledCategories == null) {
            this.loadDisabledLists();
        }
        return !this.disabledCategories.contains(id);
    }

    public boolean isSoundEnabled() {
        return this.getPreferenceStore().getBoolean(PREF_SOUND_ENABLED);
    }

    public boolean isSoundEnabled(String id) {
        if (id == null) {
            return false;
        }
        if (this.disabledSounds == null) {
            this.loadDisabledLists();
        }
        return !this.disabledSounds.contains(id);
    }

    /*
     * Exception decompiling
     */
    private void loadDisabledLists() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 270->274)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadExtensionPoints() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.ui", "audio");
        int size = cf.length;
        this.categories = new HashMap();
        this.sounds = new HashMap();
        int i = 0;
        while (i < size) {
            try {
                String elementName = cf[i].getName();
                String id = cf[i].getAttribute("id");
                String name = cf[i].getAttribute("name");
                if ("category".equals(elementName)) {
                    this.categories.put(id, name);
                } else if ("sound".equals(elementName)) {
                    String category = cf[i].getAttribute("category");
                    String location = cf[i].getAttribute("location");
                    URL realURL = null;
                    if (location != null && location.length() > 0) {
                        String pluginId = cf[i].getDeclaringExtension().getContributor().getName();
                        URL url = FileLocator.find((Bundle)Platform.getBundle((String)pluginId), (IPath)new Path(location), null);
                        realURL = FileLocator.resolve((URL)url);
                    }
                    Sound sound = new Sound(id, category, name, realURL);
                    this.sounds.put(id, sound);
                }
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "Could not load audio: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    private void loadSoundMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 181->185)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void playSound(String id) {
        if (!this.isSoundEnabled()) {
            return;
        }
        if (!this.isSoundEnabled(id)) {
            return;
        }
        try {
            Sound sound = (Sound)this.sounds.get(id);
            String category = sound.getCategory();
            if (category != null && this.categories.containsKey(category) && !this.isCategoryEnabled(category)) {
                return;
            }
            URL url = sound.getLocation();
            IPath path = this.getUserSoundPath(id);
            if (path != null) {
                url = path.toFile().toURL();
            }
            AudioCore.playSound(url, this.getVolume());
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error playing audio: " + id, e);
        }
    }

    protected static void playSound(URL url, final int volume) {
        try {
            Trace.trace(Trace.FINEST, "playSound");
            if (url == null || volume <= 0) {
                return;
            }
            final Clip clip = AudioCore.getClip(url);
            if (clip == null) {
                return;
            }
            Trace.trace(Trace.FINEST, "playing");
            Thread t = new Thread("Sound Thread"){

                public void run() {
                    FloatControl gainControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
                    double value = (double)volume / 20.0;
                    float dB = (float)(Math.log(value == 0.0 ? 1.0E-4 : value) / Math.log(10.0) * 20.0);
                    gainControl.setValue(dB);
                    Trace.trace(Trace.FINEST, "start");
                    clip.start();
                    try {
                        1.sleep(99L);
                    }
                    catch (Exception exception) {}
                    while (clip.isActive()) {
                        try {
                            1.sleep(99L);
                        }
                        catch (Exception exception) {
                            break;
                        }
                    }
                    clip.stop();
                    clip.close();
                    Trace.trace(Trace.FINEST, "stop");
                }
            };
            t.setDaemon(true);
            t.start();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error playing audio: " + url, e);
        }
    }

    /*
     * Exception decompiling
     */
    private void saveDisabledLists() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 221->225)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void saveSoundMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 178->182)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setCategoryEnabled(String id, boolean b) {
        if (id == null) {
            return;
        }
        if (this.disabledCategories == null) {
            this.loadDisabledLists();
        }
        if (b) {
            if (this.disabledCategories.contains(id)) {
                this.disabledCategories.remove(id);
                this.saveDisabledLists();
            }
        } else if (!this.disabledCategories.contains(id)) {
            this.disabledCategories.add(id);
            this.saveDisabledLists();
        }
    }

    public void setSoundEnabled(String id, boolean b) {
        if (id == null) {
            return;
        }
        if (this.disabledSounds == null) {
            this.loadDisabledLists();
        }
        if (b) {
            if (this.disabledSounds.contains(id)) {
                this.disabledSounds.remove(id);
                this.saveDisabledLists();
            }
        } else if (!this.disabledSounds.contains(id)) {
            this.disabledSounds.add(id);
            this.saveDisabledLists();
        }
    }

    public void setSoundsEnabled(boolean enabled) {
        this.getPreferenceStore().setValue(PREF_SOUND_ENABLED, enabled);
    }

    protected void setSoundURL(String id, IPath path) {
        if (id == null || path == null) {
            return;
        }
        try {
            if (this.userSoundMap == null) {
                this.loadSoundMap();
            }
            this.userSoundMap.put(id, path);
            this.saveSoundMap();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not get sound URL: " + id, e);
        }
    }

    protected void setUserSoundMap(Map map) {
        if (map != null) {
            this.userSoundMap = map;
            this.saveSoundMap();
        }
    }

    public void setVolume(int volume) {
        this.getPreferenceStore().setValue(PREF_VOLUME, volume);
    }
}

