/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.common;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.wst.javascript.ui.internal.common.HTMLTextPresenter;
import org.eclipse.wst.javascript.ui.internal.common.autoedit.AutoEditStrategyForTabs;
import org.eclipse.wst.javascript.ui.internal.common.contentassist.JavaScriptContentAssistProcessor;
import org.eclipse.wst.javascript.ui.internal.common.taginfo.JavaScriptInformationPresenter;
import org.eclipse.wst.javascript.ui.internal.common.taginfo.JavaScriptTagInfoHoverProcessor;
import org.eclipse.wst.sse.ui.internal.reconcile.DocumentRegionProcessor;

public class JSSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private ITextHover fTextHover = null;
    private IContentAssistant fContentAssistant = null;
    private InformationPresenter fInformationPresenter = null;
    private IReconciler fReconciler = null;

    public JSSourceViewerConfiguration() {
    }

    public JSSourceViewerConfiguration(IPreferenceStore store) {
        super(store);
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        Vector<String> vector = new Vector<String>();
        int indentationWidth = this.fPreferenceStore.getInt("indentationSize");
        String indentCharPref = this.fPreferenceStore.getString("indentationChar");
        boolean useSpaces = "space".equals(indentCharPref);
        int i = 0;
        while (i <= indentationWidth) {
            int j;
            StringBuffer prefix = new StringBuffer();
            boolean appendTab = false;
            if (useSpaces) {
                j = 0;
                while (j + i < indentationWidth) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    appendTab = true;
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != indentationWidth) {
                    appendTab = true;
                }
            }
            if (appendTab) {
                prefix.append('\t');
                vector.add(prefix.toString());
                prefix.deleteCharAt(prefix.length() - 1);
            }
            vector.add(prefix.toString());
            ++i;
        }
        vector.add("");
        return vector.toArray(new String[vector.size()]);
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.fContentAssistant == null) {
            ContentAssistant contentAssistant = new ContentAssistant();
            contentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            JavaScriptContentAssistProcessor contentAssistantProcessor = new JavaScriptContentAssistProcessor();
            contentAssistant.setContentAssistProcessor((IContentAssistProcessor)contentAssistantProcessor, "__dftl_partition_content_type");
            contentAssistant.enableAutoActivation(true);
            contentAssistant.setAutoActivationDelay(500);
            contentAssistant.setProposalPopupOrientation(10);
            contentAssistant.setContextInformationPopupOrientation(20);
            contentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            this.fContentAssistant = contentAssistant;
        }
        return this.fContentAssistant;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int style = 0;
                return new DefaultInformationControl(parent, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        if (this.fTextHover == null) {
            this.fTextHover = new JavaScriptTagInfoHoverProcessor();
        }
        return this.fTextHover;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 255);
    }

    private IInformationControlCreator getInformationPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int style = 768;
                return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        if (this.fInformationPresenter == null) {
            this.fInformationPresenter = new JavaScriptInformationPresenter(this.getInformationPresenterControlCreator(sourceViewer));
            this.fInformationPresenter.setSizeConstraints(60, 10, true, true);
            this.fInformationPresenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        }
        return this.fInformationPresenter;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        ArrayList<IAutoEditStrategy> allStrategies = new ArrayList<IAutoEditStrategy>(0);
        IAutoEditStrategy[] superStrategies = super.getAutoEditStrategies(sourceViewer, contentType);
        int i = 0;
        while (i < superStrategies.length) {
            allStrategies.add(superStrategies[i]);
            ++i;
        }
        allStrategies.add(new AutoEditStrategyForTabs());
        return allStrategies.toArray(new IAutoEditStrategy[allStrategies.size()]);
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fReconciler == null) {
            this.fReconciler = new DocumentRegionProcessor(){

                protected String getContentType(IDocument doc) {
                    return "org.eclipse.wst.javascript.core.javascriptsource";
                }
            };
        }
        return this.fReconciler;
    }
}

