/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.actions;

import java.util.Iterator;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.common.actions.XSDBaseAction;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddXSDAnyElementCommand;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDWildcard;

public class AddXSDAnyElementAction
extends XSDBaseAction {
    public static String ID = "org.eclipse.wst.xsd.ui.AddXSDAnyElementAction";

    public AddXSDAnyElementAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages._UI_ACTION_ADD_ANY_ELEMENT);
        this.setId(ID);
    }

    public void run() {
        XSDModelGroup modelGroup = this.getModelGroup();
        if (modelGroup != null) {
            AddXSDAnyElementCommand command = new AddXSDAnyElementCommand(this.getText(), modelGroup);
            this.getCommandStack().execute((Command)command);
        }
    }

    private XSDModelGroup getModelGroup() {
        Object selection = ((IStructuredSelection)this.getSelection()).getFirstElement();
        if (selection instanceof XSDBaseAdapter) {
            selection = ((XSDBaseAdapter)selection).getTarget();
        }
        if (selection instanceof XSDModelGroup) {
            return (XSDModelGroup)selection;
        }
        return null;
    }

    protected boolean calculateEnabled() {
        XSDModelGroup modelGroup;
        boolean rc = super.calculateEnabled();
        if (rc && (modelGroup = this.getModelGroup()) != null) {
            boolean hasAnyElement = false;
            Iterator i = modelGroup.getContents().iterator();
            while (i.hasNext()) {
                XSDParticle obj = (XSDParticle)i.next();
                if (!(obj.getContent() instanceof XSDWildcard)) continue;
                hasAnyElement = true;
                break;
            }
            return !hasAnyElement;
        }
        return rc;
    }
}

