/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.ui.dialog;

import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jst.ws.internal.common.Filter;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.ui.WSUIPluginMessages;
import org.eclipse.jst.ws.internal.ui.dialog.ResourceSelectionDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public final class DialogUtils {
    public static String browseContainers(Shell parentShell, String initialPathname) {
        String selectedPathname = null;
        Path initialPath = new Path(initialPathname);
        IResource initialResource = ResourceUtils.getWorkspaceRoot().findMember((IPath)initialPath);
        if (initialResource == null) {
            if (initialPath.segmentCount() == 1) {
                initialResource = ResourceUtils.getWorkspaceRoot().getProject(initialPath.segment(0));
            } else if (initialPath.segmentCount() > 1) {
                initialResource = ResourceUtils.getWorkspaceRoot().getFolder((IPath)initialPath);
            }
        } else if (initialResource.getType() == 1) {
            initialResource = initialResource.getParent();
        }
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(parentShell, (IContainer)initialResource, true, null);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length > 0 && result[0] instanceof IPath) {
            IPath path = (IPath)result[0];
            selectedPathname = path.toString();
        }
        return selectedPathname;
    }

    public static IResource browseResources(Shell parentShell, IResource topResource, IResource initialSelection, Filter filter) {
        IResource[] resources;
        ResourceSelectionDialog rds = new ResourceSelectionDialog(parentShell, topResource, initialSelection, filter);
        rds.setMultipleSelectionEnabled(false);
        if (rds.open() == 0 && (resources = rds.getResult()) != null && resources.length > 0) {
            return resources[0];
        }
        return null;
    }

    public static String browseClasses(Shell parentShell, IProject project) {
        return DialogUtils.browseClasses(parentShell, project, null);
    }

    public static String browseClasses(Shell parentShell, IProject project, IWizardContainer container) {
        return DialogUtils.browseClasses(parentShell, project, (IRunnableContext)container);
    }

    public static String browseClasses(Shell parentShell, IProject project, IRunnableContext ctxt) {
        return DialogUtils.browseClasses(parentShell, new IResource[]{project}, ctxt);
    }

    public static String browseClasses(Shell parentShell, IResource[] resources, IRunnableContext ctxt) {
        IType itype = DialogUtils.browseClassesAsIType(parentShell, resources, ctxt);
        if (itype != null) {
            return itype.getFullyQualifiedName();
        }
        return null;
    }

    public static IType browseClassesAsIType(Shell parentShell, IResource[] resources, IRunnableContext ctxt) {
        Vector<IJavaElement> javaElements = new Vector<IJavaElement>();
        int i = 0;
        while (i < resources.length) {
            IJavaElement javaElement = JavaCore.create((IResource)resources[i]);
            if (javaElement != null) {
                javaElements.add(javaElement);
            }
            ++i;
        }
        IJavaElement[] elements = javaElements.toArray(new IJavaElement[0]);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        scope.setIncludesClasspaths(true);
        scope.setIncludesBinaries(true);
        try {
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)parentShell, (IRunnableContext)ctxt, (IJavaSearchScope)scope, (int)2, (boolean)false);
            dialog.setTitle(WSUIPluginMessages.DIALOG_TITLE_CLASS_BROWSE);
            dialog.setMessage(WSUIPluginMessages.DIALOG_TITLE_CLASS_BROWSE);
            dialog.open();
            Object[] results = dialog.getResult();
            if (results != null && results.length > 0 && results[0] instanceof IType) {
                return (IType)results[0];
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static String browseInterfaces(Shell parentShell, IProject project, IWizardContainer container) {
        String interfaceName = null;
        IResource[] resources = new IResource[]{project};
        IJavaElement[] elements = new IJavaElement[]{JavaCore.create((IResource)resources[0])};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
        scope.setIncludesClasspaths(true);
        scope.setIncludesBinaries(true);
        try {
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)parentShell, (IRunnableContext)container, (IJavaSearchScope)scope, (int)6, (boolean)false);
            dialog.setTitle(WSUIPluginMessages.DIALOG_TITLE_INTERFACE_BROWSE);
            dialog.setMessage(WSUIPluginMessages.DIALOG_TITLE_INTERFACE_BROWSE);
            dialog.open();
            Object[] results = dialog.getResult();
            if (results != null && results.length > 0 && results[0] instanceof IType) {
                IType resultInterface = (IType)results[0];
                interfaceName = resultInterface.getFullyQualifiedName();
            }
        }
        catch (JavaModelException javaModelException) {}
        return interfaceName;
    }
}

