/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.DefaultWorkingCopyOwner;
import org.rubypeople.rdt.internal.core.LoadpathEntry;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.OpenableElementInfo;
import org.rubypeople.rdt.internal.core.RubyElement;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProjectElementInfo;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.builder.ProjectFileFinder;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class RubyProject
extends Openable
implements IProjectNature,
IRubyElement,
IRubyProject {
    protected IProject project;
    protected List loadPathEntries;
    protected boolean scratched;
    private static final String PREF_FILENAME = ".rprefs";

    public RubyProject() {
        super(null);
    }

    public RubyProject(IProject iProject, RubyElement rubyElement) {
        super(rubyElement);
        this.setProject(iProject);
    }

    public void configure() throws CoreException {
        this.addToBuildSpec("org.rubypeople.rdt.core.rubybuilder");
    }

    public boolean upgrade() throws CoreException {
        return this.addToBuildSpec("org.rubypeople.rdt.core.rubybuilder");
    }

    protected boolean addToBuildSpec(String string) throws CoreException {
        IProjectDescription iProjectDescription = this.project.getDescription();
        int n = this.getRubyCommandIndex(iProjectDescription.getBuildSpec());
        if (n == -1) {
            ICommand iCommand = iProjectDescription.newCommand();
            iCommand.setBuilderName(string);
            this.setRubyCommand(iProjectDescription, iCommand);
            return true;
        }
        return false;
    }

    private int getRubyCommandIndex(ICommand[] iCommandArray) {
        int n = 0;
        while (n < iCommandArray.length) {
            if (iCommandArray[n].getBuilderName().equals("org.rubypeople.rdt.core.rubybuilder")) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void setRubyCommand(IProjectDescription iProjectDescription, ICommand iCommand) throws CoreException {
        ICommand[] iCommandArray;
        ICommand[] iCommandArray2 = iProjectDescription.getBuildSpec();
        int n = this.getRubyCommandIndex(iCommandArray2);
        if (n == -1) {
            iCommandArray = new ICommand[iCommandArray2.length + 1];
            System.arraycopy(iCommandArray2, 0, iCommandArray, 1, iCommandArray2.length);
            iCommandArray[0] = iCommand;
        } else {
            iCommandArray2[n] = iCommand;
            iCommandArray = iCommandArray2;
        }
        iProjectDescription.setBuildSpec(iCommandArray);
        this.project.setDescription(iProjectDescription, null);
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec("org.rubypeople.rdt.core.rubybuilder");
    }

    protected void removeFromBuildSpec(String string) throws CoreException {
        IProjectDescription iProjectDescription = this.project.getDescription();
        ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
        int n = 0;
        while (n < iCommandArray.length) {
            if (iCommandArray[n].getBuilderName().equals(string)) {
                ICommand[] iCommandArray2 = new ICommand[iCommandArray.length - 1];
                System.arraycopy(iCommandArray, 0, iCommandArray2, 0, n);
                System.arraycopy(iCommandArray, n + 1, iCommandArray2, n, iCommandArray.length - n - 1);
                iProjectDescription.setBuildSpec(iCommandArray2);
                this.project.setDescription(iProjectDescription, null);
                return;
            }
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RubyProject)) {
            return false;
        }
        RubyProject rubyProject = (RubyProject)object;
        return this.project.equals((Object)rubyProject.getProject());
    }

    public int hashCode() {
        return this.project.hashCode();
    }

    public boolean exists() {
        return RubyProject.hasRubyNature(this.project);
    }

    public RubyModelManager.PerProjectInfo getPerProjectInfo() throws RubyModelException {
        return RubyModelManager.getRubyModelManager().getPerProjectInfoCheckExistence(this.project);
    }

    private IPath getPluginWorkingLocation() {
        return this.project.getWorkingLocation("org.rubypeople.rdt.core");
    }

    public IProject getProject() {
        return this.project;
    }

    public IPath getPath() {
        return this.project.getFullPath();
    }

    protected IProject getProject(String string) {
        return RubyCore.getWorkspace().getRoot().getProject(string);
    }

    public void setProject(IProject iProject) {
        this.project = iProject;
    }

    public IResource getResource() {
        return this.project;
    }

    public void addLoadPathEntry(IProject iProject) {
        this.scratched = true;
        LoadpathEntry loadpathEntry = new LoadpathEntry(iProject);
        this.getLoadPathEntries().add(loadpathEntry);
    }

    public void removeLoadPathEntry(IProject iProject) {
        Iterator iterator = this.getLoadPathEntries().iterator();
        while (iterator.hasNext()) {
            LoadpathEntry loadpathEntry = (LoadpathEntry)iterator.next();
            if (loadpathEntry.getEntryKind() != 2 || !loadpathEntry.getProject().getName().equals(iProject.getName())) continue;
            this.getLoadPathEntries().remove(loadpathEntry);
            this.scratched = true;
            break;
        }
    }

    public List getLoadPathEntries() {
        if (this.loadPathEntries == null) {
            this.loadLoadPathEntries();
        }
        return this.loadPathEntries;
    }

    public List getReferencedProjects() {
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        Iterator iterator = this.getLoadPathEntries().iterator();
        while (iterator.hasNext()) {
            LoadpathEntry loadpathEntry = (LoadpathEntry)iterator.next();
            if (loadpathEntry.getEntryKind() != 2) continue;
            arrayList.add(loadpathEntry.getProject());
        }
        return arrayList;
    }

    public String[] getRequiredProjectNames() throws RubyModelException {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this.getLoadPathEntries();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            if (stringArray.getEntryKind() != 2) continue;
            arrayList.add(stringArray.getPath().lastSegment());
        }
        int n = arrayList.size();
        if (n == 0) {
            return new String[0];
        }
        stringArray = new String[n];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    protected void loadLoadPathEntries() {
        this.loadPathEntries = new ArrayList();
        IFile iFile = this.getLoadPathEntriesFile();
        XMLReader xMLReader = null;
        try {
            xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            xMLReader.setContentHandler(this.getLoadPathEntriesContentHandler());
            xMLReader.parse(new InputSource(iFile.getContents()));
        }
        catch (Exception exception) {}
    }

    protected ContentHandler getLoadPathEntriesContentHandler() {
        return new ContentHandler(){

            public void characters(char[] cArray, int n, int n2) throws SAXException {
            }

            public void endDocument() throws SAXException {
            }

            public void endElement(String string, String string2, String string3) throws SAXException {
            }

            public void endPrefixMapping(String string) throws SAXException {
            }

            public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            }

            public void processingInstruction(String string, String string2) throws SAXException {
            }

            public void setDocumentLocator(Locator locator) {
            }

            public void skippedEntity(String string) throws SAXException {
            }

            public void startDocument() throws SAXException {
            }

            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                if ("pathentry".equals(string3) && "project".equals(attributes.getValue("type"))) {
                    Path path = new Path(attributes.getValue("path"));
                    IProject iProject = RubyProject.this.getProject(path.lastSegment());
                    RubyProject.this.loadPathEntries.add(new LoadpathEntry(iProject));
                }
            }

            public void startPrefixMapping(String string, String string2) throws SAXException {
            }
        };
    }

    protected IFile getLoadPathEntriesFile() {
        return this.project.getFile(".loadpath");
    }

    public void save() throws CoreException {
        if (this.scratched) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getLoadPathXML().getBytes());
            IFile iFile = this.getLoadPathEntriesFile();
            if (!iFile.exists()) {
                iFile.create((InputStream)byteArrayInputStream, true, null);
            } else {
                iFile.setContents((InputStream)byteArrayInputStream, true, false, null);
            }
            this.scratched = false;
        }
    }

    protected String getLoadPathXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><loadpath>");
        Iterator iterator = this.loadPathEntries.iterator();
        while (iterator.hasNext()) {
            LoadpathEntry loadpathEntry = (LoadpathEntry)iterator.next();
            stringBuffer.append(loadpathEntry.toXML());
        }
        stringBuffer.append("</loadpath>");
        return stringBuffer.toString();
    }

    public IResource getUnderlyingResource() throws RubyModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.project;
    }

    public IEclipsePreferences getEclipsePreferences() {
        if (!RubyProject.hasRubyNature(this.project)) {
            return null;
        }
        RubyModelManager.PerProjectInfo perProjectInfo = RubyModelManager.getRubyModelManager().getPerProjectInfo(this.project, true);
        if (perProjectInfo.preferences != null) {
            return perProjectInfo.preferences;
        }
        ProjectScope projectScope = new ProjectScope(this.getProject());
        final IEclipsePreferences iEclipsePreferences = projectScope.getNode("org.rubypeople.rdt.core");
        this.updatePreferences(iEclipsePreferences);
        perProjectInfo.preferences = iEclipsePreferences;
        IEclipsePreferences.INodeChangeListener iNodeChangeListener = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent nodeChangeEvent) {
            }

            public void removed(IEclipsePreferences.NodeChangeEvent nodeChangeEvent) {
                if (nodeChangeEvent.getChild() == iEclipsePreferences) {
                    RubyModelManager.getRubyModelManager().resetProjectPreferences(RubyProject.this);
                }
            }
        };
        ((IEclipsePreferences)iEclipsePreferences.parent()).addNodeChangeListener(iNodeChangeListener);
        IEclipsePreferences.IPreferenceChangeListener iPreferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent) {
                RubyModelManager.getRubyModelManager().resetProjectOptions(RubyProject.this);
            }
        };
        iEclipsePreferences.addPreferenceChangeListener(iPreferenceChangeListener);
        return iEclipsePreferences;
    }

    public String getElementName() {
        return this.project.getName();
    }

    public int getElementType() {
        return 1;
    }

    public boolean hasChildren() {
        return true;
    }

    public IType findType(String string) {
        int n = string.lastIndexOf("::");
        String string2 = null;
        if (n == -1) {
            string2 = string;
        } else {
            string.substring(0, n);
            string2 = string.substring(n + 2);
        }
        return this.searchChildren(this, string2);
    }

    private IType searchChildren(IRubyElement iRubyElement, String string) {
        if (iRubyElement.isType(3) && iRubyElement.getElementName().equals(string)) {
            return (IType)iRubyElement;
        }
        if (!(iRubyElement instanceof IParent)) {
            return null;
        }
        try {
            IRubyElement[] iRubyElementArray = ((IParent)((Object)iRubyElement)).getChildren();
            int n = 0;
            while (n < iRubyElementArray.length) {
                IRubyElement iRubyElement2 = iRubyElementArray[n];
                IType iType = this.searchChildren(iRubyElement2, string);
                if (iType != null) {
                    return iType;
                }
                ++n;
            }
        }
        catch (RubyModelException rubyModelException) {
            RubyCore.log((Exception)((Object)rubyModelException));
        }
        return null;
    }

    public static boolean hasRubyNature(IProject iProject) {
        try {
            return iProject.hasNature("org.rubypeople.rdt.core.rubynature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected boolean buildStructure(OpenableElementInfo openableElementInfo, IProgressMonitor iProgressMonitor, Map map, IResource iResource) throws RubyModelException {
        if (!iResource.isAccessible()) {
            throw this.newNotPresentException();
        }
        openableElementInfo.setChildren(this.getScripts());
        return true;
    }

    private IRubyElement[] getScripts() {
        ProjectFileFinder projectFileFinder = new ProjectFileFinder(this.project);
        try {
            List list = projectFileFinder.findFiles();
            IRubyElement[] iRubyElementArray = new IRubyElement[list.size()];
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IResource iResource = (IResource)iterator.next();
                iRubyElementArray[n] = new RubyScript(this, (IFile)iResource, iResource.getName(), DefaultWorkingCopyOwner.PRIMARY);
                ++n;
            }
            return iRubyElementArray;
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            return new IRubyElement[0];
        }
    }

    public String rootID() {
        return "[PRJ]" + this.project.getFullPath();
    }

    protected Object createElementInfo() {
        return new RubyProjectElementInfo();
    }

    public ILoadpathEntry[] getLoadpaths() {
        List list = this.getLoadPathEntries();
        if (list.isEmpty()) {
            return new ILoadpathEntry[0];
        }
        ILoadpathEntry[] iLoadpathEntryArray = new ILoadpathEntry[list.size()];
        System.arraycopy(list.toArray(), 0, iLoadpathEntryArray, 0, list.size());
        return iLoadpathEntryArray;
    }

    public String getOption(String string, boolean bl) {
        String string2 = string;
        if (RubyModelManager.getRubyModelManager().optionNames.contains(string2)) {
            String string3;
            IEclipsePreferences iEclipsePreferences = this.getEclipsePreferences();
            String string4 = string3 = bl ? RubyCore.getOption(string2) : null;
            if (iEclipsePreferences == null) {
                return string3;
            }
            String string5 = iEclipsePreferences.get(string2, string3);
            return string5 == null ? null : string5.trim();
        }
        return null;
    }

    public Map getOptions(boolean bl) {
        Object object;
        Object object2;
        Hashtable hashtable = bl ? RubyCore.getOptions() : new Hashtable(5);
        RubyModelManager.PerProjectInfo perProjectInfo = null;
        Hashtable<String, String> hashtable2 = null;
        HashSet hashSet = RubyModelManager.getRubyModelManager().optionNames;
        try {
            perProjectInfo = this.getPerProjectInfo();
            hashtable2 = perProjectInfo.options;
            if (hashtable2 == null) {
                object2 = this.getEclipsePreferences();
                if (object2 == null) {
                    return hashtable;
                }
                object = object2.keys();
                hashtable2 = new Hashtable(((String[])object).length);
                int n = 0;
                while (n < ((String[])object).length) {
                    String string = object[n];
                    String string2 = object2.get(string, null);
                    if (string2 != null && hashSet.contains(string)) {
                        hashtable2.put(string, string2.trim());
                    }
                    ++n;
                }
                perProjectInfo.options = hashtable2;
            }
        }
        catch (RubyModelException rubyModelException) {
            hashtable2 = new Hashtable<String, String>();
        }
        catch (BackingStoreException backingStoreException) {
            hashtable2 = new Hashtable();
        }
        if (bl) {
            object2 = hashtable2.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                String string = (String)hashtable2.get(object);
                if (string == null || !hashSet.contains(object)) continue;
                hashtable.put(object, string.trim());
            }
            return hashtable;
        }
        return hashtable2;
    }

    private void updatePreferences(IEclipsePreferences iEclipsePreferences) {
        Preferences preferences = this.loadPreferences();
        if (preferences != null) {
            String[] stringArray = preferences.propertyNames();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                String string2 = preferences.getString(string);
                if (!"".equals(string2)) {
                    iEclipsePreferences.put(string, string2);
                }
                ++n;
            }
            try {
                iEclipsePreferences.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Preferences loadPreferences() {
        File file;
        Preferences preferences;
        block8: {
            preferences = new Preferences();
            IPath iPath = this.getPluginWorkingLocation();
            if (iPath == null) return null;
            file = iPath.append(PREF_FILENAME).toFile();
            if (!file.exists()) return null;
            BufferedInputStream bufferedInputStream = null;
            try {
                try {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                    preferences.load((InputStream)bufferedInputStream);
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (bufferedInputStream == null) throw throwable;
                try {
                    ((InputStream)bufferedInputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (bufferedInputStream == null) break block8;
            }
            try {}
            catch (IOException iOException) {}
            ((InputStream)bufferedInputStream).close();
        }
        file.delete();
        return preferences;
    }

    public void resetCaches() {
    }

    public IRubyScript[] getRubyScripts() throws RubyModelException {
        IRubyElement[] iRubyElementArray = this.getChildren();
        int n = iRubyElementArray.length;
        IRubyScript[] iRubyScriptArray = new IRubyScript[n];
        System.arraycopy(iRubyElementArray, 0, iRubyScriptArray, 0, n);
        return iRubyScriptArray;
    }

    public Object[] getNonRubyResources() throws RubyModelException {
        return ((RubyProjectElementInfo)this.getElementInfo()).getNonRubyResources(this);
    }

    public boolean isOnLoadpath(IRubyScript iRubyScript) {
        return true;
    }

    public IRubyScript getRubyScript(IFile iFile) {
        return new RubyScript(this, iFile, iFile.getName(), DefaultWorkingCopyOwner.PRIMARY);
    }
}

