/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.epic.debug.PerlDebugPlugin;

public class WorkingDirectoryBlock
extends AbstractLaunchConfigurationTab {
    private Text fWorkingDirText;
    private Button fWorkspaceButton;
    private Button fFileSystemButton;
    private Button fVariablesButton;
    private Button fUseDefaultWorkingDirButton;
    protected ILaunchConfiguration fLaunchConfiguration;
    private WidgetListener fListener = new WidgetListener();

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        GridLayout workingDirLayout = new GridLayout();
        workingDirLayout.numColumns = 2;
        workingDirLayout.makeColumnsEqualWidth = false;
        group.setLayout((Layout)workingDirLayout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setFont(font);
        group.setText("Working directory:");
        this.setControl((Control)group);
        this.fWorkingDirText = new Text((Composite)group, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fWorkingDirText.setLayoutData((Object)gd);
        this.fWorkingDirText.setFont(font);
        this.fWorkingDirText.addModifyListener((ModifyListener)this.fListener);
        this.fUseDefaultWorkingDirButton = new Button((Composite)group, 32);
        this.fUseDefaultWorkingDirButton.setText("Use default wor&king directory");
        gd = new GridData(768);
        this.fUseDefaultWorkingDirButton.setLayoutData((Object)gd);
        this.fUseDefaultWorkingDirButton.setFont(font);
        this.fUseDefaultWorkingDirButton.addSelectionListener((SelectionListener)this.fListener);
        Composite buttonComp = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComp.setLayout((Layout)layout);
        gd = new GridData(128);
        buttonComp.setLayoutData((Object)gd);
        buttonComp.setFont(font);
        this.fWorkspaceButton = this.createPushButton(buttonComp, "W&orkspace...", null);
        this.fWorkspaceButton.addSelectionListener((SelectionListener)this.fListener);
        this.fFileSystemButton = this.createPushButton(buttonComp, "File S&ystem...", null);
        this.fFileSystemButton.addSelectionListener((SelectionListener)this.fListener);
        this.fVariablesButton = this.createPushButton(buttonComp, "Variabl&es...", null);
        this.fVariablesButton.addSelectionListener((SelectionListener)this.fListener);
    }

    public void dispose() {
    }

    protected void handleWorkingDirBrowseButtonSelected() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage("Select a working directory for the launch configuration:");
        String currentWorkingDir = this.fWorkingDirText.getText();
        if (!currentWorkingDir.trim().equals("") && (path = new File(currentWorkingDir)).exists()) {
            dialog.setFilterPath(currentWorkingDir);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.fWorkingDirText.setText(selectedDirectory);
        }
    }

    protected void handleWorkspaceDirBrowseButtonSelected() {
        IContainer currentContainer = this.getContainer();
        if (currentContainer == null) {
            currentContainer = ResourcesPlugin.getWorkspace().getRoot();
        }
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), currentContainer, false, "Select a &workspace relative working directory:");
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IPath) {
            IPath path = (IPath)results[0];
            String containerName = path.makeRelative().toString();
            this.fWorkingDirText.setText("${workspace_loc:" + containerName + "}");
        }
    }

    protected IContainer getContainer() {
        String path = this.fWorkingDirText.getText().trim();
        if (path.length() > 0) {
            IResource res = null;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            if (path.startsWith("${workspace_loc:")) {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                try {
                    path = manager.performStringSubstitution(path, false);
                    IContainer[] containers = root.findContainersForLocation((IPath)new Path(path));
                    if (containers.length > 0) {
                        res = containers[0];
                    }
                }
                catch (CoreException coreException) {}
            } else {
                res = root.findMember(path);
            }
            if (res instanceof IContainer) {
                return (IContainer)res;
            }
        }
        return null;
    }

    protected void handleUseDefaultWorkingDirButtonSelected() {
        boolean def = this.isDefaultWorkingDirectory();
        if (def) {
            this.setDefaultWorkingDir();
        }
        this.fWorkingDirText.setEnabled(!def);
        this.fWorkspaceButton.setEnabled(!def);
        this.fVariablesButton.setEnabled(!def);
        this.fFileSystemButton.setEnabled(!def);
    }

    protected void handleWorkingDirVariablesButtonSelected() {
        String variableText = this.getVariable();
        if (variableText != null) {
            this.fWorkingDirText.insert(variableText);
        }
    }

    private String getVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        return dialog.getVariableExpression();
    }

    protected void setDefaultWorkingDir() {
        this.fWorkingDirText.setText("${resource_loc}");
    }

    public boolean isValid(ILaunchConfiguration config) {
        IContainer container;
        this.setErrorMessage(null);
        this.setMessage(null);
        String workingDirPath = this.fWorkingDirText.getText().trim();
        if (workingDirPath.indexOf("${") >= 0) {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                manager.validateStringVariables(workingDirPath);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
                return false;
            }
        } else if (workingDirPath.length() > 0 && (container = this.getContainer()) == null) {
            File dir = new File(workingDirPath);
            if (dir.isDirectory()) {
                return true;
            }
            this.setErrorMessage("Working directory does not exist");
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("ATTR_WORKING_DIRECTORY", null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setLaunchConfiguration(configuration);
        try {
            String wd = configuration.getAttribute("ATTR_WORKING_DIRECTORY", null);
            this.fWorkingDirText.setText("");
            if (wd == null) {
                this.fUseDefaultWorkingDirButton.setSelection(true);
            } else {
                this.fWorkingDirText.setText(wd);
                this.fUseDefaultWorkingDirButton.setSelection(false);
            }
            this.handleUseDefaultWorkingDirButtonSelected();
        }
        catch (CoreException e) {
            this.setErrorMessage("Exception occurred reading configuration: " + e.getStatus().getMessage());
            PerlDebugPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String wd = null;
        if (!this.isDefaultWorkingDirectory()) {
            wd = this.getAttributeValueFrom(this.fWorkingDirText);
        }
        configuration.setAttribute("ATTR_WORKING_DIRECTORY", wd);
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        return content.length() > 0 ? content : null;
    }

    public String getName() {
        return "Working Directory";
    }

    protected boolean isDefaultWorkingDirectory() {
        return this.fUseDefaultWorkingDirButton.getSelection();
    }

    protected void setLaunchConfiguration(ILaunchConfiguration config) {
        this.fLaunchConfiguration = config;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    private class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            WorkingDirectoryBlock.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == WorkingDirectoryBlock.this.fWorkspaceButton) {
                WorkingDirectoryBlock.this.handleWorkspaceDirBrowseButtonSelected();
            } else if (source == WorkingDirectoryBlock.this.fFileSystemButton) {
                WorkingDirectoryBlock.this.handleWorkingDirBrowseButtonSelected();
            } else if (source == WorkingDirectoryBlock.this.fUseDefaultWorkingDirButton) {
                WorkingDirectoryBlock.this.handleUseDefaultWorkingDirButtonSelected();
            } else if (source == WorkingDirectoryBlock.this.fVariablesButton) {
                WorkingDirectoryBlock.this.handleWorkingDirVariablesButtonSelected();
            }
        }
    }
}

