/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.PerlLineBreakpoint;

public class PerlDebugModel {
    public static IBreakpoint lineBreakpointExists(IResource resource, int lineNumber) throws CoreException {
        String modelId = PerlDebugPlugin.getUniqueIdentifier();
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = manager.getBreakpoints(modelId);
        int i = 0;
        while (i < breakpoints.length) {
            PerlLineBreakpoint breakpoint = (PerlLineBreakpoint)breakpoints[i];
            IMarker marker = breakpoint.getMarker();
            if (PerlDebugModel.isValidMarker(marker) && breakpoint.getLineNumber() == lineNumber && resource.equals((Object)marker.getResource())) {
                return breakpoint;
            }
            ++i;
        }
        return null;
    }

    private static boolean isValidMarker(IMarker marker) {
        return marker != null && marker.exists();
    }
}

