/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.undo;

import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.event.PlayPenComponentEvent;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePaneLocationEdit
extends AbstractUndoableEdit {
    private static final Logger logger = Logger.getLogger(TablePaneLocationEdit.class);
    ArrayList<PlayPenComponentEvent> list = new ArrayList();

    public TablePaneLocationEdit(PlayPenComponentEvent e) {
        this.list.add(e);
    }

    public TablePaneLocationEdit(Collection<PlayPenComponentEvent> list) {
        this.list.addAll(list);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        for (PlayPenComponentEvent componentEvent : this.list) {
            this.changeLocation(componentEvent, componentEvent.getOldPoint());
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        for (PlayPenComponentEvent componentEvent : this.list) {
            this.changeLocation(componentEvent, componentEvent.getNewPoint());
        }
    }

    private void changeLocation(PlayPenComponentEvent componentEvent, Point newPoint) {
        logger.debug((Object)("Changing the location of " + componentEvent.getSource() + " to " + newPoint));
        if (componentEvent.getSource() instanceof TablePane) {
            ((TablePane)componentEvent.getSource()).setLocation(newPoint);
            ((TablePane)componentEvent.getSource()).repaint();
            ((TablePane)componentEvent.getSource()).getPlayPen().revalidate();
        }
    }

    @Override
    public String getPresentationName() {
        return "Move";
    }

    @Override
    public String toString() {
        return "Changing the location of " + this.list;
    }
}

