# Generated from the Telepathy spec
""" Copyright (C) 2005, 2006 Collabora Limited 
 Copyright (C) 2005, 2006 Nokia Corporation 
 Copyright (C) 2006 INdT 

    This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
  
"""

import dbus.service


class ChannelTypeContactSearch(dbus.service.Interface):
    """\
    A channel type for searching server-stored user directories. A new channel
    should be requested by a client for each search attempt, and it should be
    closed when the search is completed or the required result has been found
    in order to free unused handles. The search can be cancelled at any time
    by calling the channel Close method, although depending upon the protocol
    the connection manager may not be able to prevent the server from sending
    further results.

    Before searching, the GetSearchKeys method should be used to discover any
    instructions sent by the server, and the valid search keys which can be
    provided to the Search method. A search request is then started by
    providing some of these terms to the Search method, and the search status
    will be set to CHANNEL_CONTACT_SEARCH_STATE_DURING. When results are
    returned by the server, the SearchResultReceived signal is emitted for each
    contact found, and when the search is complete, the search status will be
    set to CHANNEL_SEARCH_STATE_AFTER.
    """

    @dbus.service.method('org.freedesktop.Telepathy.Channel.Type.ContactSearch', in_signature='', out_signature='sa{s(bg)}')
    def GetSearchKeys(self):
        """
        Returns any instructions from the server along with a dictionary of
        search key names to their types, and a boolean indicating if the key is
        mandatory. The following well-known search key names should be used
        where appropriate:
        
          s:firstThe desired contact's given name
          s:lastThe desired contact's family name
          s:nickThe desired contact's nickname
          s:emailThe e-mail address of the desired contact
        
      
        """
        raise NotImplementedError
  
    @dbus.service.method('org.freedesktop.Telepathy.Channel.Type.ContactSearch', in_signature='', out_signature='u')
    def GetSearchState(self):
        """
        Returns the current state of this search channel object.
      
        """
        raise NotImplementedError
  
    @dbus.service.method('org.freedesktop.Telepathy.Channel.Type.ContactSearch', in_signature='a{sv}', out_signature='')
    def Search(self, terms):
        """
        Send a request to start a search for contacts on this connection. A
        valid search request will cause the SearchStateChanged signal to be
        emitted with the status CHANNEL_CONTACT_SEARCH_STATE_DURING.
      
        """
        raise NotImplementedError
  
    @dbus.service.signal('org.freedesktop.Telepathy.Channel.Type.ContactSearch', signature='ua{sv}')
    def SearchResultReceived(self, contact, values):
        """
        Emitted when a search result is received from the server.
      
        """
        pass
  
    @dbus.service.signal('org.freedesktop.Telepathy.Channel.Type.ContactSearch', signature='u')
    def SearchStateChanged(self, state):
        """
        Emitted when the search state (as returned by the GetSearchState
        method) changes.
      
        """
        pass
  