require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__MACH64_DRV_H__)) {
    eval 'sub __MACH64_DRV_H__ () {1;}' unless defined(&__MACH64_DRV_H__);
    eval 'sub DRIVER_AUTHOR () {"Gareth Hughes, Leif Delgass, José Fonseca";}' unless defined(&DRIVER_AUTHOR);
    eval 'sub DRIVER_NAME () {"mach64";}' unless defined(&DRIVER_NAME);
    eval 'sub DRIVER_DESC () {"DRM module for the ATI Rage Pro";}' unless defined(&DRIVER_DESC);
    eval 'sub DRIVER_DATE () {"20060718";}' unless defined(&DRIVER_DATE);
    eval 'sub DRIVER_MAJOR () {2;}' unless defined(&DRIVER_MAJOR);
    eval 'sub DRIVER_MINOR () {0;}' unless defined(&DRIVER_MINOR);
    eval 'sub DRIVER_PATCHLEVEL () {0;}' unless defined(&DRIVER_PATCHLEVEL);
    eval 'sub MACH64_EXTRA_CHECKING () {0;}' unless defined(&MACH64_EXTRA_CHECKING);
    eval 'sub MACH64_VERBOSE () {0;}' unless defined(&MACH64_VERBOSE);
    eval 'sub MACH64_AGP_BASE () {0x148;}' unless defined(&MACH64_AGP_BASE);
    eval 'sub MACH64_AGP_CNTL () {0x14c;}' unless defined(&MACH64_AGP_CNTL);
    eval 'sub MACH64_ALPHA_TST_CNTL () {0x550;}' unless defined(&MACH64_ALPHA_TST_CNTL);
    eval 'sub MACH64_DSP_CONFIG () {0x420;}' unless defined(&MACH64_DSP_CONFIG);
    eval 'sub MACH64_DSP_ON_OFF () {0x424;}' unless defined(&MACH64_DSP_ON_OFF);
    eval 'sub MACH64_EXT_MEM_CNTL () {0x4ac;}' unless defined(&MACH64_EXT_MEM_CNTL);
    eval 'sub MACH64_GEN_TEST_CNTL () {0x4d0;}' unless defined(&MACH64_GEN_TEST_CNTL);
    eval 'sub MACH64_HW_DEBUG () {0x47c;}' unless defined(&MACH64_HW_DEBUG);
    eval 'sub MACH64_MEM_ADDR_CONFIG () {0x434;}' unless defined(&MACH64_MEM_ADDR_CONFIG);
    eval 'sub MACH64_MEM_BUF_CNTL () {0x42c;}' unless defined(&MACH64_MEM_BUF_CNTL);
    eval 'sub MACH64_MEM_CNTL () {0x4b0;}' unless defined(&MACH64_MEM_CNTL);
    eval 'sub MACH64_BM_ADDR () {0x648;}' unless defined(&MACH64_BM_ADDR);
    eval 'sub MACH64_BM_COMMAND () {0x188;}' unless defined(&MACH64_BM_COMMAND);
    eval 'sub MACH64_BM_DATA () {0x648;}' unless defined(&MACH64_BM_DATA);
    eval 'sub MACH64_BM_FRAME_BUF_OFFSET () {0x180;}' unless defined(&MACH64_BM_FRAME_BUF_OFFSET);
    eval 'sub MACH64_BM_GUI_TABLE () {0x1b8;}' unless defined(&MACH64_BM_GUI_TABLE);
    eval 'sub MACH64_BM_GUI_TABLE_CMD () {0x64c;}' unless defined(&MACH64_BM_GUI_TABLE_CMD);
    eval 'sub MACH64_CIRCULAR_BUF_SIZE_16KB () {(0<< 0);}' unless defined(&MACH64_CIRCULAR_BUF_SIZE_16KB);
    eval 'sub MACH64_CIRCULAR_BUF_SIZE_32KB () {(1<< 0);}' unless defined(&MACH64_CIRCULAR_BUF_SIZE_32KB);
    eval 'sub MACH64_CIRCULAR_BUF_SIZE_64KB () {(2<< 0);}' unless defined(&MACH64_CIRCULAR_BUF_SIZE_64KB);
    eval 'sub MACH64_CIRCULAR_BUF_SIZE_128KB () {(3<< 0);}' unless defined(&MACH64_CIRCULAR_BUF_SIZE_128KB);
    eval 'sub MACH64_LAST_DESCRIPTOR () {(1<< 31);}' unless defined(&MACH64_LAST_DESCRIPTOR);
    eval 'sub MACH64_BM_HOSTDATA () {0x644;}' unless defined(&MACH64_BM_HOSTDATA);
    eval 'sub MACH64_BM_STATUS () {0x18c;}' unless defined(&MACH64_BM_STATUS);
    eval 'sub MACH64_BM_SYSTEM_MEM_ADDR () {0x184;}' unless defined(&MACH64_BM_SYSTEM_MEM_ADDR);
    eval 'sub MACH64_BM_SYSTEM_TABLE () {0x1bc;}' unless defined(&MACH64_BM_SYSTEM_TABLE);
    eval 'sub MACH64_BUS_CNTL () {0x4a0;}' unless defined(&MACH64_BUS_CNTL);
    eval 'sub MACH64_BUS_MSTR_RESET () {(1<< 1);}' unless defined(&MACH64_BUS_MSTR_RESET);
    eval 'sub MACH64_BUS_APER_REG_DIS () {(1<< 4);}' unless defined(&MACH64_BUS_APER_REG_DIS);
    eval 'sub MACH64_BUS_FLUSH_BUF () {(1<< 2);}' unless defined(&MACH64_BUS_FLUSH_BUF);
    eval 'sub MACH64_BUS_MASTER_DIS () {(1<< 6);}' unless defined(&MACH64_BUS_MASTER_DIS);
    eval 'sub MACH64_BUS_EXT_REG_EN () {(1<< 27);}' unless defined(&MACH64_BUS_EXT_REG_EN);
    eval 'sub MACH64_CLR_CMP_CLR () {0x700;}' unless defined(&MACH64_CLR_CMP_CLR);
    eval 'sub MACH64_CLR_CMP_CNTL () {0x708;}' unless defined(&MACH64_CLR_CMP_CNTL);
    eval 'sub MACH64_CLR_CMP_MASK () {0x704;}' unless defined(&MACH64_CLR_CMP_MASK);
    eval 'sub MACH64_CONFIG_CHIP_ID () {0x4e0;}' unless defined(&MACH64_CONFIG_CHIP_ID);
    eval 'sub MACH64_CONFIG_CNTL () {0x4dc;}' unless defined(&MACH64_CONFIG_CNTL);
    eval 'sub MACH64_CONFIG_STAT0 () {0x4e4;}' unless defined(&MACH64_CONFIG_STAT0);
    eval 'sub MACH64_CONFIG_STAT1 () {0x494;}' unless defined(&MACH64_CONFIG_STAT1);
    eval 'sub MACH64_CONFIG_STAT2 () {0x498;}' unless defined(&MACH64_CONFIG_STAT2);
    eval 'sub MACH64_CONTEXT_LOAD_CNTL () {0x72c;}' unless defined(&MACH64_CONTEXT_LOAD_CNTL);
    eval 'sub MACH64_CONTEXT_MASK () {0x720;}' unless defined(&MACH64_CONTEXT_MASK);
    eval 'sub MACH64_COMPOSITE_SHADOW_ID () {0x798;}' unless defined(&MACH64_COMPOSITE_SHADOW_ID);
    eval 'sub MACH64_CRC_SIG () {0x4e8;}' unless defined(&MACH64_CRC_SIG);
    eval 'sub MACH64_CUSTOM_MACRO_CNTL () {0x4d4;}' unless defined(&MACH64_CUSTOM_MACRO_CNTL);
    eval 'sub MACH64_DP_BKGD_CLR () {0x6c0;}' unless defined(&MACH64_DP_BKGD_CLR);
    eval 'sub MACH64_DP_FOG_CLR () {0x6c4;}' unless defined(&MACH64_DP_FOG_CLR);
    eval 'sub MACH64_DP_FGRD_BKGD_CLR () {0x6e0;}' unless defined(&MACH64_DP_FGRD_BKGD_CLR);
    eval 'sub MACH64_DP_FRGD_CLR () {0x6c4;}' unless defined(&MACH64_DP_FRGD_CLR);
    eval 'sub MACH64_DP_FGRD_CLR_MIX () {0x6dc;}' unless defined(&MACH64_DP_FGRD_CLR_MIX);
    eval 'sub MACH64_DP_MIX () {0x6d4;}' unless defined(&MACH64_DP_MIX);
    eval 'sub BKGD_MIX_NOT_D () {(0<< 0);}' unless defined(&BKGD_MIX_NOT_D);
    eval 'sub BKGD_MIX_ZERO () {(1<< 0);}' unless defined(&BKGD_MIX_ZERO);
    eval 'sub BKGD_MIX_ONE () {(2<< 0);}' unless defined(&BKGD_MIX_ONE);
    eval 'sub MACH64_BKGD_MIX_D () {(3<< 0);}' unless defined(&MACH64_BKGD_MIX_D);
    eval 'sub BKGD_MIX_NOT_S () {(4<< 0);}' unless defined(&BKGD_MIX_NOT_S);
    eval 'sub BKGD_MIX_D_XOR_S () {(5<< 0);}' unless defined(&BKGD_MIX_D_XOR_S);
    eval 'sub BKGD_MIX_NOT_D_XOR_S () {(6<< 0);}' unless defined(&BKGD_MIX_NOT_D_XOR_S);
    eval 'sub MACH64_BKGD_MIX_S () {(7<< 0);}' unless defined(&MACH64_BKGD_MIX_S);
    eval 'sub BKGD_MIX_NOT_D_OR_NOT_S () {(8<< 0);}' unless defined(&BKGD_MIX_NOT_D_OR_NOT_S);
    eval 'sub BKGD_MIX_D_OR_NOT_S () {(9<< 0);}' unless defined(&BKGD_MIX_D_OR_NOT_S);
    eval 'sub BKGD_MIX_NOT_D_OR_S () {(10<< 0);}' unless defined(&BKGD_MIX_NOT_D_OR_S);
    eval 'sub BKGD_MIX_D_OR_S () {(11<< 0);}' unless defined(&BKGD_MIX_D_OR_S);
    eval 'sub BKGD_MIX_D_AND_S () {(12<< 0);}' unless defined(&BKGD_MIX_D_AND_S);
    eval 'sub BKGD_MIX_NOT_D_AND_S () {(13<< 0);}' unless defined(&BKGD_MIX_NOT_D_AND_S);
    eval 'sub BKGD_MIX_D_AND_NOT_S () {(14<< 0);}' unless defined(&BKGD_MIX_D_AND_NOT_S);
    eval 'sub BKGD_MIX_NOT_D_AND_NOT_S () {(15<< 0);}' unless defined(&BKGD_MIX_NOT_D_AND_NOT_S);
    eval 'sub BKGD_MIX_D_PLUS_S_DIV2 () {(23<< 0);}' unless defined(&BKGD_MIX_D_PLUS_S_DIV2);
    eval 'sub FRGD_MIX_NOT_D () {(0<< 16);}' unless defined(&FRGD_MIX_NOT_D);
    eval 'sub FRGD_MIX_ZERO () {(1<< 16);}' unless defined(&FRGD_MIX_ZERO);
    eval 'sub FRGD_MIX_ONE () {(2<< 16);}' unless defined(&FRGD_MIX_ONE);
    eval 'sub FRGD_MIX_D () {(3<< 16);}' unless defined(&FRGD_MIX_D);
    eval 'sub FRGD_MIX_NOT_S () {(4<< 16);}' unless defined(&FRGD_MIX_NOT_S);
    eval 'sub FRGD_MIX_D_XOR_S () {(5<< 16);}' unless defined(&FRGD_MIX_D_XOR_S);
    eval 'sub FRGD_MIX_NOT_D_XOR_S () {(6<< 16);}' unless defined(&FRGD_MIX_NOT_D_XOR_S);
    eval 'sub MACH64_FRGD_MIX_S () {(7<< 16);}' unless defined(&MACH64_FRGD_MIX_S);
    eval 'sub FRGD_MIX_NOT_D_OR_NOT_S () {(8<< 16);}' unless defined(&FRGD_MIX_NOT_D_OR_NOT_S);
    eval 'sub FRGD_MIX_D_OR_NOT_S () {(9<< 16);}' unless defined(&FRGD_MIX_D_OR_NOT_S);
    eval 'sub FRGD_MIX_NOT_D_OR_S () {(10<< 16);}' unless defined(&FRGD_MIX_NOT_D_OR_S);
    eval 'sub FRGD_MIX_D_OR_S () {(11<< 16);}' unless defined(&FRGD_MIX_D_OR_S);
    eval 'sub FRGD_MIX_D_AND_S () {(12<< 16);}' unless defined(&FRGD_MIX_D_AND_S);
    eval 'sub FRGD_MIX_NOT_D_AND_S () {(13<< 16);}' unless defined(&FRGD_MIX_NOT_D_AND_S);
    eval 'sub FRGD_MIX_D_AND_NOT_S () {(14<< 16);}' unless defined(&FRGD_MIX_D_AND_NOT_S);
    eval 'sub FRGD_MIX_NOT_D_AND_NOT_S () {(15<< 16);}' unless defined(&FRGD_MIX_NOT_D_AND_NOT_S);
    eval 'sub FRGD_MIX_D_PLUS_S_DIV2 () {(23<< 16);}' unless defined(&FRGD_MIX_D_PLUS_S_DIV2);
    eval 'sub MACH64_DP_PIX_WIDTH () {0x6d0;}' unless defined(&MACH64_DP_PIX_WIDTH);
    eval 'sub MACH64_HOST_TRIPLE_ENABLE () {(1<< 13);}' unless defined(&MACH64_HOST_TRIPLE_ENABLE);
    eval 'sub MACH64_BYTE_ORDER_MSB_TO_LSB () {(0<< 24);}' unless defined(&MACH64_BYTE_ORDER_MSB_TO_LSB);
    eval 'sub MACH64_BYTE_ORDER_LSB_TO_MSB () {(1<< 24);}' unless defined(&MACH64_BYTE_ORDER_LSB_TO_MSB);
    eval 'sub MACH64_DP_SRC () {0x6d8;}' unless defined(&MACH64_DP_SRC);
    eval 'sub MACH64_BKGD_SRC_BKGD_CLR () {(0<< 0);}' unless defined(&MACH64_BKGD_SRC_BKGD_CLR);
    eval 'sub MACH64_BKGD_SRC_FRGD_CLR () {(1<< 0);}' unless defined(&MACH64_BKGD_SRC_FRGD_CLR);
    eval 'sub MACH64_BKGD_SRC_HOST () {(2<< 0);}' unless defined(&MACH64_BKGD_SRC_HOST);
    eval 'sub MACH64_BKGD_SRC_BLIT () {(3<< 0);}' unless defined(&MACH64_BKGD_SRC_BLIT);
    eval 'sub MACH64_BKGD_SRC_PATTERN () {(4<< 0);}' unless defined(&MACH64_BKGD_SRC_PATTERN);
    eval 'sub MACH64_BKGD_SRC_3D () {(5<< 0);}' unless defined(&MACH64_BKGD_SRC_3D);
    eval 'sub MACH64_FRGD_SRC_BKGD_CLR () {(0<< 8);}' unless defined(&MACH64_FRGD_SRC_BKGD_CLR);
    eval 'sub MACH64_FRGD_SRC_FRGD_CLR () {(1<< 8);}' unless defined(&MACH64_FRGD_SRC_FRGD_CLR);
    eval 'sub MACH64_FRGD_SRC_HOST () {(2<< 8);}' unless defined(&MACH64_FRGD_SRC_HOST);
    eval 'sub MACH64_FRGD_SRC_BLIT () {(3<< 8);}' unless defined(&MACH64_FRGD_SRC_BLIT);
    eval 'sub MACH64_FRGD_SRC_PATTERN () {(4<< 8);}' unless defined(&MACH64_FRGD_SRC_PATTERN);
    eval 'sub MACH64_FRGD_SRC_3D () {(5<< 8);}' unless defined(&MACH64_FRGD_SRC_3D);
    eval 'sub MACH64_MONO_SRC_ONE () {(0<< 16);}' unless defined(&MACH64_MONO_SRC_ONE);
    eval 'sub MACH64_MONO_SRC_PATTERN () {(1<< 16);}' unless defined(&MACH64_MONO_SRC_PATTERN);
    eval 'sub MACH64_MONO_SRC_HOST () {(2<< 16);}' unless defined(&MACH64_MONO_SRC_HOST);
    eval 'sub MACH64_MONO_SRC_BLIT () {(3<< 16);}' unless defined(&MACH64_MONO_SRC_BLIT);
    eval 'sub MACH64_DP_WRITE_MASK () {0x6c8;}' unless defined(&MACH64_DP_WRITE_MASK);
    eval 'sub MACH64_DST_CNTL () {0x530;}' unless defined(&MACH64_DST_CNTL);
    eval 'sub MACH64_DST_X_RIGHT_TO_LEFT () {(0<< 0);}' unless defined(&MACH64_DST_X_RIGHT_TO_LEFT);
    eval 'sub MACH64_DST_X_LEFT_TO_RIGHT () {(1<< 0);}' unless defined(&MACH64_DST_X_LEFT_TO_RIGHT);
    eval 'sub MACH64_DST_Y_BOTTOM_TO_TOP () {(0<< 1);}' unless defined(&MACH64_DST_Y_BOTTOM_TO_TOP);
    eval 'sub MACH64_DST_Y_TOP_TO_BOTTOM () {(1<< 1);}' unless defined(&MACH64_DST_Y_TOP_TO_BOTTOM);
    eval 'sub MACH64_DST_X_MAJOR () {(0<< 2);}' unless defined(&MACH64_DST_X_MAJOR);
    eval 'sub MACH64_DST_Y_MAJOR () {(1<< 2);}' unless defined(&MACH64_DST_Y_MAJOR);
    eval 'sub MACH64_DST_X_TILE () {(1<< 3);}' unless defined(&MACH64_DST_X_TILE);
    eval 'sub MACH64_DST_Y_TILE () {(1<< 4);}' unless defined(&MACH64_DST_Y_TILE);
    eval 'sub MACH64_DST_LAST_PEL () {(1<< 5);}' unless defined(&MACH64_DST_LAST_PEL);
    eval 'sub MACH64_DST_POLYGON_ENABLE () {(1<< 6);}' unless defined(&MACH64_DST_POLYGON_ENABLE);
    eval 'sub MACH64_DST_24_ROTATION_ENABLE () {(1<< 7);}' unless defined(&MACH64_DST_24_ROTATION_ENABLE);
    eval 'sub MACH64_DST_HEIGHT_WIDTH () {0x518;}' unless defined(&MACH64_DST_HEIGHT_WIDTH);
    eval 'sub MACH64_DST_OFF_PITCH () {0x500;}' unless defined(&MACH64_DST_OFF_PITCH);
    eval 'sub MACH64_DST_WIDTH_HEIGHT () {0x6ec;}' unless defined(&MACH64_DST_WIDTH_HEIGHT);
    eval 'sub MACH64_DST_X_Y () {0x6e8;}' unless defined(&MACH64_DST_X_Y);
    eval 'sub MACH64_DST_Y_X () {0x50c;}' unless defined(&MACH64_DST_Y_X);
    eval 'sub MACH64_FIFO_STAT () {0x710;}' unless defined(&MACH64_FIFO_STAT);
    eval 'sub MACH64_FIFO_SLOT_MASK () {0xffff;}' unless defined(&MACH64_FIFO_SLOT_MASK);
    eval 'sub MACH64_FIFO_ERR () {(1<< 31);}' unless defined(&MACH64_FIFO_ERR);
    eval 'sub MACH64_GEN_TEST_CNTL () {0x4d0;}' unless defined(&MACH64_GEN_TEST_CNTL);
    eval 'sub MACH64_GUI_ENGINE_ENABLE () {(1<< 8);}' unless defined(&MACH64_GUI_ENGINE_ENABLE);
    eval 'sub MACH64_GUI_CMDFIFO_DEBUG () {0x170;}' unless defined(&MACH64_GUI_CMDFIFO_DEBUG);
    eval 'sub MACH64_GUI_CMDFIFO_DATA () {0x174;}' unless defined(&MACH64_GUI_CMDFIFO_DATA);
    eval 'sub MACH64_GUI_CNTL () {0x178;}' unless defined(&MACH64_GUI_CNTL);
    eval 'sub MACH64_CMDFIFO_SIZE_MASK () {0x3;}' unless defined(&MACH64_CMDFIFO_SIZE_MASK);
    eval 'sub MACH64_CMDFIFO_SIZE_192 () {0x;}' unless defined(&MACH64_CMDFIFO_SIZE_192);
    eval 'sub MACH64_CMDFIFO_SIZE_128 () {0x1;}' unless defined(&MACH64_CMDFIFO_SIZE_128);
    eval 'sub MACH64_CMDFIFO_SIZE_64 () {0x2;}' unless defined(&MACH64_CMDFIFO_SIZE_64);
    eval 'sub MACH64_GUI_STAT () {0x738;}' unless defined(&MACH64_GUI_STAT);
    eval 'sub MACH64_GUI_ACTIVE () {(1<< 0);}' unless defined(&MACH64_GUI_ACTIVE);
    eval 'sub MACH64_GUI_TRAJ_CNTL () {0x730;}' unless defined(&MACH64_GUI_TRAJ_CNTL);
    eval 'sub MACH64_HOST_CNTL () {0x640;}' unless defined(&MACH64_HOST_CNTL);
    eval 'sub MACH64_HOST_DATA0 () {0x600;}' unless defined(&MACH64_HOST_DATA0);
    eval 'sub MACH64_ONE_OVER_AREA () {0x29c;}' unless defined(&MACH64_ONE_OVER_AREA);
    eval 'sub MACH64_ONE_OVER_AREA_UC () {0x300;}' unless defined(&MACH64_ONE_OVER_AREA_UC);
    eval 'sub MACH64_PAT_REG0 () {0x680;}' unless defined(&MACH64_PAT_REG0);
    eval 'sub MACH64_PAT_REG1 () {0x684;}' unless defined(&MACH64_PAT_REG1);
    eval 'sub MACH64_SC_LEFT () {0x6a0;}' unless defined(&MACH64_SC_LEFT);
    eval 'sub MACH64_SC_RIGHT () {0x6a4;}' unless defined(&MACH64_SC_RIGHT);
    eval 'sub MACH64_SC_LEFT_RIGHT () {0x6a8;}' unless defined(&MACH64_SC_LEFT_RIGHT);
    eval 'sub MACH64_SC_TOP () {0x6ac;}' unless defined(&MACH64_SC_TOP);
    eval 'sub MACH64_SC_BOTTOM () {0x6b0;}' unless defined(&MACH64_SC_BOTTOM);
    eval 'sub MACH64_SC_TOP_BOTTOM () {0x6b4;}' unless defined(&MACH64_SC_TOP_BOTTOM);
    eval 'sub MACH64_SCALE_3D_CNTL () {0x5fc;}' unless defined(&MACH64_SCALE_3D_CNTL);
    eval 'sub MACH64_SCRATCH_REG0 () {0x480;}' unless defined(&MACH64_SCRATCH_REG0);
    eval 'sub MACH64_SCRATCH_REG1 () {0x484;}' unless defined(&MACH64_SCRATCH_REG1);
    eval 'sub MACH64_SECONDARY_TEX_OFF () {0x778;}' unless defined(&MACH64_SECONDARY_TEX_OFF);
    eval 'sub MACH64_SETUP_CNTL () {0x304;}' unless defined(&MACH64_SETUP_CNTL);
    eval 'sub MACH64_SRC_CNTL () {0x5b4;}' unless defined(&MACH64_SRC_CNTL);
    eval 'sub MACH64_SRC_BM_ENABLE () {(1<< 8);}' unless defined(&MACH64_SRC_BM_ENABLE);
    eval 'sub MACH64_SRC_BM_SYNC () {(1<< 9);}' unless defined(&MACH64_SRC_BM_SYNC);
    eval 'sub MACH64_SRC_BM_OP_FRAME_TO_SYSTEM () {(0<< 10);}' unless defined(&MACH64_SRC_BM_OP_FRAME_TO_SYSTEM);
    eval 'sub MACH64_SRC_BM_OP_SYSTEM_TO_FRAME () {(1<< 10);}' unless defined(&MACH64_SRC_BM_OP_SYSTEM_TO_FRAME);
    eval 'sub MACH64_SRC_BM_OP_REG_TO_SYSTEM () {(2<< 10);}' unless defined(&MACH64_SRC_BM_OP_REG_TO_SYSTEM);
    eval 'sub MACH64_SRC_BM_OP_SYSTEM_TO_REG () {(3<< 10);}' unless defined(&MACH64_SRC_BM_OP_SYSTEM_TO_REG);
    eval 'sub MACH64_SRC_HEIGHT1 () {0x594;}' unless defined(&MACH64_SRC_HEIGHT1);
    eval 'sub MACH64_SRC_HEIGHT2 () {0x5ac;}' unless defined(&MACH64_SRC_HEIGHT2);
    eval 'sub MACH64_SRC_HEIGHT1_WIDTH1 () {0x598;}' unless defined(&MACH64_SRC_HEIGHT1_WIDTH1);
    eval 'sub MACH64_SRC_HEIGHT2_WIDTH2 () {0x5b0;}' unless defined(&MACH64_SRC_HEIGHT2_WIDTH2);
    eval 'sub MACH64_SRC_OFF_PITCH () {0x580;}' unless defined(&MACH64_SRC_OFF_PITCH);
    eval 'sub MACH64_SRC_WIDTH1 () {0x590;}' unless defined(&MACH64_SRC_WIDTH1);
    eval 'sub MACH64_SRC_Y_X () {0x58c;}' unless defined(&MACH64_SRC_Y_X);
    eval 'sub MACH64_TEX_0_OFF () {0x5c0;}' unless defined(&MACH64_TEX_0_OFF);
    eval 'sub MACH64_TEX_CNTL () {0x774;}' unless defined(&MACH64_TEX_CNTL);
    eval 'sub MACH64_TEX_SIZE_PITCH () {0x770;}' unless defined(&MACH64_TEX_SIZE_PITCH);
    eval 'sub MACH64_TIMER_CONFIG () {0x428;}' unless defined(&MACH64_TIMER_CONFIG);
    eval 'sub MACH64_VERTEX_1_ARGB () {0x254;}' unless defined(&MACH64_VERTEX_1_ARGB);
    eval 'sub MACH64_VERTEX_1_S () {0x240;}' unless defined(&MACH64_VERTEX_1_S);
    eval 'sub MACH64_VERTEX_1_SECONDARY_S () {0x328;}' unless defined(&MACH64_VERTEX_1_SECONDARY_S);
    eval 'sub MACH64_VERTEX_1_SECONDARY_T () {0x32c;}' unless defined(&MACH64_VERTEX_1_SECONDARY_T);
    eval 'sub MACH64_VERTEX_1_SECONDARY_W () {0x330;}' unless defined(&MACH64_VERTEX_1_SECONDARY_W);
    eval 'sub MACH64_VERTEX_1_SPEC_ARGB () {0x24c;}' unless defined(&MACH64_VERTEX_1_SPEC_ARGB);
    eval 'sub MACH64_VERTEX_1_T () {0x244;}' unless defined(&MACH64_VERTEX_1_T);
    eval 'sub MACH64_VERTEX_1_W () {0x248;}' unless defined(&MACH64_VERTEX_1_W);
    eval 'sub MACH64_VERTEX_1_X_Y () {0x258;}' unless defined(&MACH64_VERTEX_1_X_Y);
    eval 'sub MACH64_VERTEX_1_Z () {0x250;}' unless defined(&MACH64_VERTEX_1_Z);
    eval 'sub MACH64_VERTEX_2_ARGB () {0x274;}' unless defined(&MACH64_VERTEX_2_ARGB);
    eval 'sub MACH64_VERTEX_2_S () {0x260;}' unless defined(&MACH64_VERTEX_2_S);
    eval 'sub MACH64_VERTEX_2_SECONDARY_S () {0x334;}' unless defined(&MACH64_VERTEX_2_SECONDARY_S);
    eval 'sub MACH64_VERTEX_2_SECONDARY_T () {0x338;}' unless defined(&MACH64_VERTEX_2_SECONDARY_T);
    eval 'sub MACH64_VERTEX_2_SECONDARY_W () {0x33c;}' unless defined(&MACH64_VERTEX_2_SECONDARY_W);
    eval 'sub MACH64_VERTEX_2_SPEC_ARGB () {0x26c;}' unless defined(&MACH64_VERTEX_2_SPEC_ARGB);
    eval 'sub MACH64_VERTEX_2_T () {0x264;}' unless defined(&MACH64_VERTEX_2_T);
    eval 'sub MACH64_VERTEX_2_W () {0x268;}' unless defined(&MACH64_VERTEX_2_W);
    eval 'sub MACH64_VERTEX_2_X_Y () {0x278;}' unless defined(&MACH64_VERTEX_2_X_Y);
    eval 'sub MACH64_VERTEX_2_Z () {0x270;}' unless defined(&MACH64_VERTEX_2_Z);
    eval 'sub MACH64_VERTEX_3_ARGB () {0x294;}' unless defined(&MACH64_VERTEX_3_ARGB);
    eval 'sub MACH64_VERTEX_3_S () {0x280;}' unless defined(&MACH64_VERTEX_3_S);
    eval 'sub MACH64_VERTEX_3_SECONDARY_S () {0x2a0;}' unless defined(&MACH64_VERTEX_3_SECONDARY_S);
    eval 'sub MACH64_VERTEX_3_SECONDARY_T () {0x2a4;}' unless defined(&MACH64_VERTEX_3_SECONDARY_T);
    eval 'sub MACH64_VERTEX_3_SECONDARY_W () {0x2a8;}' unless defined(&MACH64_VERTEX_3_SECONDARY_W);
    eval 'sub MACH64_VERTEX_3_SPEC_ARGB () {0x28c;}' unless defined(&MACH64_VERTEX_3_SPEC_ARGB);
    eval 'sub MACH64_VERTEX_3_T () {0x284;}' unless defined(&MACH64_VERTEX_3_T);
    eval 'sub MACH64_VERTEX_3_W () {0x288;}' unless defined(&MACH64_VERTEX_3_W);
    eval 'sub MACH64_VERTEX_3_X_Y () {0x298;}' unless defined(&MACH64_VERTEX_3_X_Y);
    eval 'sub MACH64_VERTEX_3_Z () {0x290;}' unless defined(&MACH64_VERTEX_3_Z);
    eval 'sub MACH64_Z_CNTL () {0x54c;}' unless defined(&MACH64_Z_CNTL);
    eval 'sub MACH64_Z_OFF_PITCH () {0x548;}' unless defined(&MACH64_Z_OFF_PITCH);
    eval 'sub MACH64_CRTC_VLINE_CRNT_VLINE () {0x410;}' unless defined(&MACH64_CRTC_VLINE_CRNT_VLINE);
    eval 'sub MACH64_CRTC_VLINE_MASK () {0x7ff;}' unless defined(&MACH64_CRTC_VLINE_MASK);
    eval 'sub MACH64_CRTC_CRNT_VLINE_MASK () {0x7ff0000;}' unless defined(&MACH64_CRTC_CRNT_VLINE_MASK);
    eval 'sub MACH64_CRTC_OFF_PITCH () {0x414;}' unless defined(&MACH64_CRTC_OFF_PITCH);
    eval 'sub MACH64_CRTC_INT_CNTL () {0x418;}' unless defined(&MACH64_CRTC_INT_CNTL);
    eval 'sub MACH64_CRTC_VBLANK () {(1<< 0);}' unless defined(&MACH64_CRTC_VBLANK);
    eval 'sub MACH64_CRTC_VBLANK_INT_EN () {(1<< 1);}' unless defined(&MACH64_CRTC_VBLANK_INT_EN);
    eval 'sub MACH64_CRTC_VBLANK_INT () {(1<< 2);}' unless defined(&MACH64_CRTC_VBLANK_INT);
    eval 'sub MACH64_CRTC_VLINE_INT_EN () {(1<< 3);}' unless defined(&MACH64_CRTC_VLINE_INT_EN);
    eval 'sub MACH64_CRTC_VLINE_INT () {(1<< 4);}' unless defined(&MACH64_CRTC_VLINE_INT);
    eval 'sub MACH64_CRTC_VLINE_SYNC () {(1<< 5);}' unless defined(&MACH64_CRTC_VLINE_SYNC);
    eval 'sub MACH64_CRTC_FRAME () {(1<< 6);}' unless defined(&MACH64_CRTC_FRAME);
    eval 'sub MACH64_CRTC_SNAPSHOT_INT_EN () {(1<< 7);}' unless defined(&MACH64_CRTC_SNAPSHOT_INT_EN);
    eval 'sub MACH64_CRTC_SNAPSHOT_INT () {(1<< 8);}' unless defined(&MACH64_CRTC_SNAPSHOT_INT);
    eval 'sub MACH64_CRTC_I2C_INT_EN () {(1<< 9);}' unless defined(&MACH64_CRTC_I2C_INT_EN);
    eval 'sub MACH64_CRTC_I2C_INT () {(1<< 10);}' unless defined(&MACH64_CRTC_I2C_INT);
    eval 'sub MACH64_CRTC2_VBLANK () {(1<< 11);}' unless defined(&MACH64_CRTC2_VBLANK);
    eval 'sub MACH64_CRTC2_VBLANK_INT_EN () {(1<< 12);}' unless defined(&MACH64_CRTC2_VBLANK_INT_EN);
    eval 'sub MACH64_CRTC2_VBLANK_INT () {(1<< 13);}' unless defined(&MACH64_CRTC2_VBLANK_INT);
    eval 'sub MACH64_CRTC2_VLINE_INT_EN () {(1<< 14);}' unless defined(&MACH64_CRTC2_VLINE_INT_EN);
    eval 'sub MACH64_CRTC2_VLINE_INT () {(1<< 15);}' unless defined(&MACH64_CRTC2_VLINE_INT);
    eval 'sub MACH64_CRTC_CAPBUF0_INT_EN () {(1<< 16);}' unless defined(&MACH64_CRTC_CAPBUF0_INT_EN);
    eval 'sub MACH64_CRTC_CAPBUF0_INT () {(1<< 17);}' unless defined(&MACH64_CRTC_CAPBUF0_INT);
    eval 'sub MACH64_CRTC_CAPBUF1_INT_EN () {(1<< 18);}' unless defined(&MACH64_CRTC_CAPBUF1_INT_EN);
    eval 'sub MACH64_CRTC_CAPBUF1_INT () {(1<< 19);}' unless defined(&MACH64_CRTC_CAPBUF1_INT);
    eval 'sub MACH64_CRTC_OVERLAY_EOF_INT_EN () {(1<< 20);}' unless defined(&MACH64_CRTC_OVERLAY_EOF_INT_EN);
    eval 'sub MACH64_CRTC_OVERLAY_EOF_INT () {(1<< 21);}' unless defined(&MACH64_CRTC_OVERLAY_EOF_INT);
    eval 'sub MACH64_CRTC_ONESHOT_CAP_INT_EN () {(1<< 22);}' unless defined(&MACH64_CRTC_ONESHOT_CAP_INT_EN);
    eval 'sub MACH64_CRTC_ONESHOT_CAP_INT () {(1<< 23);}' unless defined(&MACH64_CRTC_ONESHOT_CAP_INT);
    eval 'sub MACH64_CRTC_BUSMASTER_EOL_INT_EN () {(1<< 24);}' unless defined(&MACH64_CRTC_BUSMASTER_EOL_INT_EN);
    eval 'sub MACH64_CRTC_BUSMASTER_EOL_INT () {(1<< 25);}' unless defined(&MACH64_CRTC_BUSMASTER_EOL_INT);
    eval 'sub MACH64_CRTC_GP_INT_EN () {(1<< 26);}' unless defined(&MACH64_CRTC_GP_INT_EN);
    eval 'sub MACH64_CRTC_GP_INT () {(1<< 27);}' unless defined(&MACH64_CRTC_GP_INT);
    eval 'sub MACH64_CRTC2_VLINE_SYNC () {(1<< 28);}' unless defined(&MACH64_CRTC2_VLINE_SYNC);
    eval 'sub MACH64_CRTC_SNAPSHOT2_INT_EN () {(1<< 29);}' unless defined(&MACH64_CRTC_SNAPSHOT2_INT_EN);
    eval 'sub MACH64_CRTC_SNAPSHOT2_INT () {(1<< 30);}' unless defined(&MACH64_CRTC_SNAPSHOT2_INT);
    eval 'sub MACH64_CRTC_VBLANK2_INT () {(1<< 31);}' unless defined(&MACH64_CRTC_VBLANK2_INT);
    eval 'sub MACH64_CRTC_INT_ENS () {(  &MACH64_CRTC_VBLANK_INT_EN |  &MACH64_CRTC_VLINE_INT_EN |  &MACH64_CRTC_SNAPSHOT_INT_EN |  &MACH64_CRTC_I2C_INT_EN |  &MACH64_CRTC2_VBLANK_INT_EN |  &MACH64_CRTC2_VLINE_INT_EN |  &MACH64_CRTC_CAPBUF0_INT_EN |  &MACH64_CRTC_CAPBUF1_INT_EN |  &MACH64_CRTC_OVERLAY_EOF_INT_EN |  &MACH64_CRTC_ONESHOT_CAP_INT_EN |  &MACH64_CRTC_BUSMASTER_EOL_INT_EN |  &MACH64_CRTC_GP_INT_EN |  &MACH64_CRTC_SNAPSHOT2_INT_EN | 0);}' unless defined(&MACH64_CRTC_INT_ENS);
    eval 'sub MACH64_CRTC_INT_ACKS () {(  &MACH64_CRTC_VBLANK_INT |  &MACH64_CRTC_VLINE_INT |  &MACH64_CRTC_SNAPSHOT_INT |  &MACH64_CRTC_I2C_INT |  &MACH64_CRTC2_VBLANK_INT |  &MACH64_CRTC2_VLINE_INT |  &MACH64_CRTC_CAPBUF0_INT |  &MACH64_CRTC_CAPBUF1_INT |  &MACH64_CRTC_OVERLAY_EOF_INT |  &MACH64_CRTC_ONESHOT_CAP_INT |  &MACH64_CRTC_BUSMASTER_EOL_INT |  &MACH64_CRTC_GP_INT |  &MACH64_CRTC_SNAPSHOT2_INT |  &MACH64_CRTC_VBLANK2_INT | 0);}' unless defined(&MACH64_CRTC_INT_ACKS);
    eval 'sub MACH64_DATATYPE_CI8 () {2;}' unless defined(&MACH64_DATATYPE_CI8);
    eval 'sub MACH64_DATATYPE_ARGB1555 () {3;}' unless defined(&MACH64_DATATYPE_ARGB1555);
    eval 'sub MACH64_DATATYPE_RGB565 () {4;}' unless defined(&MACH64_DATATYPE_RGB565);
    eval 'sub MACH64_DATATYPE_ARGB8888 () {6;}' unless defined(&MACH64_DATATYPE_ARGB8888);
    eval 'sub MACH64_DATATYPE_RGB332 () {7;}' unless defined(&MACH64_DATATYPE_RGB332);
    eval 'sub MACH64_DATATYPE_Y8 () {8;}' unless defined(&MACH64_DATATYPE_Y8);
    eval 'sub MACH64_DATATYPE_RGB8 () {9;}' unless defined(&MACH64_DATATYPE_RGB8);
    eval 'sub MACH64_DATATYPE_VYUY422 () {11;}' unless defined(&MACH64_DATATYPE_VYUY422);
    eval 'sub MACH64_DATATYPE_YVYU422 () {12;}' unless defined(&MACH64_DATATYPE_YVYU422);
    eval 'sub MACH64_DATATYPE_AYUV444 () {14;}' unless defined(&MACH64_DATATYPE_AYUV444);
    eval 'sub MACH64_DATATYPE_ARGB4444 () {15;}' unless defined(&MACH64_DATATYPE_ARGB4444);
    eval 'sub MACH64_READ {
        my($reg) = @_;
	    eval q( &DRM_READ32( ($dev_priv->{mmio}), ($reg) ));
    }' unless defined(&MACH64_READ);
    eval 'sub MACH64_WRITE {
        my($reg,$val) = @_;
	    eval q( &DRM_WRITE32( ($dev_priv->{mmio}), ($reg), ($val) ));
    }' unless defined(&MACH64_WRITE);
    eval 'sub DWMREG0 () {0x400;}' unless defined(&DWMREG0);
    eval 'sub DWMREG0_END () {0x7ff;}' unless defined(&DWMREG0_END);
    eval 'sub DWMREG1 () {0x;}' unless defined(&DWMREG1);
    eval 'sub DWMREG1_END () {0x3ff;}' unless defined(&DWMREG1_END);
    eval 'sub ISREG0 {
        my($r) = @_;
	    eval q(((($r) >=  &DWMREG0)  && (($r) <=  &DWMREG0_END)));
    }' unless defined(&ISREG0);
    eval 'sub DMAREG0 {
        my($r) = @_;
	    eval q(((($r) -  &DWMREG0) >> 2));
    }' unless defined(&DMAREG0);
    eval 'sub DMAREG1 {
        my($r) = @_;
	    eval q((((($r) -  &DWMREG1) >> 2) | 0x100));
    }' unless defined(&DMAREG1);
    eval 'sub DMAREG {
        my($r) = @_;
	    eval q(( &ISREG0($r) ?  &DMAREG0($r) :  &DMAREG1($r)));
    }' unless defined(&DMAREG);
    eval 'sub MMREG0 () {0x;}' unless defined(&MMREG0);
    eval 'sub MMREG0_END () {0xff;}' unless defined(&MMREG0_END);
    eval 'sub ISMMREG0 {
        my($r) = @_;
	    eval q(((($r) >=  &MMREG0)  && (($r) <=  &MMREG0_END)));
    }' unless defined(&ISMMREG0);
    eval 'sub MMSELECT0 {
        my($r) = @_;
	    eval q(((($r) << 2) +  &DWMREG0));
    }' unless defined(&MMSELECT0);
    eval 'sub MMSELECT1 {
        my($r) = @_;
	    eval q(((((($r) & 0xff) << 2) +  &DWMREG1)));
    }' unless defined(&MMSELECT1);
    eval 'sub MMSELECT {
        my($r) = @_;
	    eval q(( &ISMMREG0($r) ?  &MMSELECT0($r) :  &MMSELECT1($r)));
    }' unless defined(&MMSELECT);
    eval 'sub MACH64_DMA_FRAME_BUF_OFFSET () {0;}' unless defined(&MACH64_DMA_FRAME_BUF_OFFSET);
    eval 'sub MACH64_DMA_SYS_MEM_ADDR () {1;}' unless defined(&MACH64_DMA_SYS_MEM_ADDR);
    eval 'sub MACH64_DMA_COMMAND () {2;}' unless defined(&MACH64_DMA_COMMAND);
    eval 'sub MACH64_DMA_RESERVED () {3;}' unless defined(&MACH64_DMA_RESERVED);
    eval 'sub MACH64_DMA_HOLD_OFFSET () {(1<<30);}' unless defined(&MACH64_DMA_HOLD_OFFSET);
    eval 'sub MACH64_DMA_EOL () {(1<<31);}' unless defined(&MACH64_DMA_EOL);
    eval 'sub MACH64_DMA_CHUNKSIZE () {0x1000;}' unless defined(&MACH64_DMA_CHUNKSIZE);
    eval 'sub MACH64_APERTURE_OFFSET () {0x7ff800;}' unless defined(&MACH64_APERTURE_OFFSET);
    eval 'sub DMALOCALS () { &drm_mach64_freelist_t * &_entry =  &NULL; \'struct drm_buf\' * &_buf =  &NULL;  &u32 * &_buf_wptr; \'int\'  &_outcount;}' unless defined(&DMALOCALS);
    eval 'sub GETBUFPTR {
        my( $__buf ) = @_;
	    eval q((( ($dev_priv->{is_pci})) ? (( &u32 *)($__buf)-> &address) : (( &u32 *)( ($dev_priv->{dev_buffers}->{handle}) + ($__buf)-> &offset))));
    }' unless defined(&GETBUFPTR);
    eval 'sub GETBUFADDR {
        my( $__buf ) = @_;
	    eval q((( &u32)($__buf)-> &bus_address));
    }' unless defined(&GETBUFADDR);
    eval 'sub GETRINGOFFSET () {
        eval q(( ($_entry->{ring_ofs})));
    }' unless defined(&GETRINGOFFSET);
    eval 'sub DMASETPTR {
        my( $_p ) = @_;
	    eval q( &do {  &_buf = ($_p);  &_outcount = 0;  &_buf_wptr =  &GETBUFPTR(  &_buf ); }  &while(0));
    }' unless defined(&DMASETPTR);
    eval 'sub DMAGETPTR {
        my( $file_priv, $dev_priv, $n ) = @_;
	    eval q( &do {  &if (  &MACH64_VERBOSE ) {  &DRM_INFO( \\"DMAGETPTR( %d )\\\\n\\", ( &n) ); }  &_buf =  &mach64_freelist_get( $dev_priv );  &if ( &_buf ==  &NULL) {  &DRM_ERROR(\\"couldn\'t get buffer in DMAGETPTR\\\\n\\");  &return - &EAGAIN; }  &if ( ($_buf->{pending})) {  &DRM_ERROR(\\"pending buf in DMAGETPTR\\\\n\\");  &return - &EFAULT; }  ($_buf->{file_priv}) = $file_priv;  &_outcount = 0;  &_buf_wptr =  &GETBUFPTR(  &_buf ); }  &while (0));
    }' unless defined(&DMAGETPTR);
    eval 'sub DMAOUTREG {
        my( $reg, $val ) = @_;
	    eval q( &do {  &if (  &MACH64_VERBOSE ) {  &DRM_INFO( \\"   DMAOUTREG( 0x%x = 0x%08x )\\\\n\\", $reg, $val ); }  $_buf_wptr[ &_outcount++] =  &cpu_to_le32( &DMAREG($reg));  $_buf_wptr[ &_outcount++] =  &cpu_to_le32(($val));  ($_buf->{used}) += 8; }  &while (0));
    }' unless defined(&DMAOUTREG);
    eval 'sub DMAADVANCE {
        my( $dev_priv, $_discard ) = @_;
	    eval q( &do { \'struct list_head\' * &ptr; \'int\'  &ret;  &if (  &MACH64_VERBOSE ) {  &DRM_INFO( \\"DMAADVANCE() in \\\\n\\" ); }  &if ( ($_buf->{used}) <= 0) {  &DRM_ERROR( \\"DMAADVANCE(): sending empty buf %d\\\\n\\",  ($_buf->{idx}) );  &return - &EFAULT; }  &if ( ($_buf->{pending})) {  &if (( &ret =  &mach64_find_pending_buf_entry($dev_priv, & &_entry,  &_buf))) {  &DRM_ERROR( \\"DMAADVANCE(): couldn\'t find pending buf %d\\\\n\\",  ($_buf->{idx}) );  &return  &ret; }  &if ( ($_entry->{discard})) {  &DRM_ERROR( \\"DMAADVANCE(): sending discarded pending buf %d\\\\n\\",  ($_buf->{idx}) );  &return - &EFAULT; } }  &else {  &if ( &list_empty( ($dev_priv->{placeholders}))) {  &DRM_ERROR( \\"DMAADVANCE(): empty placeholder list\\\\n\\");  &return - &EFAULT; }  &ptr =  ($dev_priv->{placeholders}->{next});  &list_del( &ptr);  &_entry =  &list_entry( &ptr,  &drm_mach64_freelist_t,  &list);  ($_buf->{pending}) = 1;  ($_entry->{buf}) =  &_buf;  &list_add_tail( &ptr,  ($dev_priv->{pending})); }  ($_entry->{discard}) = ($_discard);  &if (( &ret =  &mach64_add_buf_to_ring( $dev_priv,  &_entry )))  &return  &ret; }  &while (0));
    }' unless defined(&DMAADVANCE);
    eval 'sub DMADISCARDBUF () {
        eval q( &do {  &if ( &_entry ==  &NULL) { \'int\'  &ret;  &if (( &ret =  &mach64_find_pending_buf_entry( &dev_priv, & &_entry,  &_buf))) {  &DRM_ERROR( \\"couldn\'t find pending buf %d\\\\n\\",  ($_buf->{idx}) );  &return  &ret; } }  ($_entry->{discard}) = 1; }  &while(0));
    }' unless defined(&DMADISCARDBUF);
    eval 'sub DMAADVANCEHOSTDATA {
        my( $dev_priv ) = @_;
	    eval q( &do { \'struct list_head\' * &ptr; \'int\'  &ret;  &if (  &MACH64_VERBOSE ) {  &DRM_INFO( \\"DMAADVANCEHOSTDATA() in \\\\n\\" ); }  &if ( ($_buf->{used}) <= 0) {  &DRM_ERROR( \\"DMAADVANCEHOSTDATA(): sending empty buf %d\\\\n\\",  ($_buf->{idx}) );  &return - &EFAULT; }  &if ( &list_empty( ($dev_priv->{placeholders}))) {  &DRM_ERROR( \\"empty placeholder list in DMAADVANCEHOSTDATA()\\\\n\\" );  &return - &EFAULT; }  &ptr =  ($dev_priv->{placeholders}->{next});  &list_del( &ptr);  &_entry =  &list_entry( &ptr,  &drm_mach64_freelist_t,  &list);  ($_entry->{buf}) =  &_buf;  ($_entry->{buf}->{pending}) = 1;  &list_add_tail( &ptr,  ($dev_priv->{pending}));  ($_entry->{discard}) = 1;  &if (( &ret =  &mach64_add_hostdata_buf_to_ring( $dev_priv,  &_entry )))  &return  &ret; }  &while (0));
    }' unless defined(&DMAADVANCEHOSTDATA);
}
1;
