CREATE TABLE accounts (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  firm_id INT DEFAULT NULL,
  credit_limit INT DEFAULT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE funny_jokes (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  name VARCHAR(50) DEFAULT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE companies (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  type VARCHAR(50) DEFAULT NULL,
  ruby_type VARCHAR(50) DEFAULT NULL,
  firm_id INT DEFAULT NULL,
  name VARCHAR(50) DEFAULT NULL,
  client_of INT DEFAULT NULL,
  rating INT DEFAULT 1,
  PRIMARY KEY (id)
);

CREATE TABLE topics (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  title VARCHAR(255) DEFAULT NULL,
  author_name VARCHAR(255) DEFAULT NULL,
  author_email_address VARCHAR(255) DEFAULT NULL,
  written_on TIMESTAMP DEFAULT NULL,
  bonus_time TIME DEFAULT NULL,
  last_read DATE DEFAULT NULL,
  content VARCHAR(3000),
  approved SMALLINT DEFAULT 1,
  replies_count INT DEFAULT 0,
  parent_id INT DEFAULT NULL,
  type VARCHAR(50) DEFAULT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE developers (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  name VARCHAR(100) DEFAULT NULL,
  salary INT DEFAULT 70000,
  created_at TIMESTAMP DEFAULT NULL,
  updated_at TIMESTAMP DEFAULT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE projects (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  name VARCHAR(100) DEFAULT NULL,
  type VARCHAR(255) DEFAULT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE developers_projects (
  developer_id INT NOT NULL,
  project_id INT NOT NULL,
  joined_on DATE DEFAULT NULL,
  access_level SMALLINT DEFAULT 1
);

CREATE TABLE orders (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  name VARCHAR(100) DEFAULT NULL,
  billing_customer_id INT DEFAULT NULL,
  shipping_customer_id INT DEFAULT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE customers (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  name VARCHAR(100) DEFAULT NULL,
  balance INT DEFAULT 0,
  address_street VARCHAR(100) DEFAULT NULL,
  address_city VARCHAR(100) DEFAULT NULL,
  address_country VARCHAR(100) DEFAULT NULL,
  gps_location VARCHAR(100) DEFAULT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE movies (
  movieid INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  name VARCHAR(100) DEFAULT NULL,
  PRIMARY KEY (movieid)
);

CREATE TABLE subscribers (
  nick VARCHAR(100) NOT NULL,
  name VARCHAR(100) DEFAULT NULL,
  PRIMARY KEY (nick)
);

CREATE TABLE booleantests (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  value INT DEFAULT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE auto_id_tests (
  auto_id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  value INT DEFAULT NULL,
  PRIMARY KEY (auto_id)
);

CREATE TABLE entrants (
  id INT NOT NULL PRIMARY KEY,
  name VARCHAR(255) NOT NULL,
  course_id INT NOT NULL
);

CREATE TABLE colnametests (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  references INT NOT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE mixins (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  parent_id INT DEFAULT NULL,
  pos INT DEFAULT NULL,
  created_at TIMESTAMP DEFAULT NULL,
  updated_at TIMESTAMP DEFAULT NULL,
  lft INT DEFAULT NULL,
  rgt INT DEFAULT NULL,
  root_id INT DEFAULT NULL,
  type VARCHAR(40) DEFAULT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE people (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  first_name VARCHAR(40) NOT NULL,
  lock_version INT DEFAULT 0,
  PRIMARY KEY (id)
);

CREATE TABLE readers (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  post_id INT NOT NULL,
  person_id INT NOT NULL,
  PRIMARY KEY (id)
);

CREATE TABLE binaries (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  data BLOB(50000),
  PRIMARY KEY (id)
);

CREATE TABLE computers (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  developer INT NOT NULL,
  extendedWarranty INT NOT NULL
);

CREATE TABLE posts (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  author_id INT DEFAULT NULL,
  title VARCHAR(255) DEFAULT NULL,
  type VARCHAR(255) DEFAULT NULL,
  body VARCHAR(3000) DEFAULT NULL
);

CREATE TABLE comments (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  post_id INT DEFAULT NULL,
  type VARCHAR(255) DEFAULT NULL,
  body VARCHAR(3000) DEFAULT NULL
);

CREATE TABLE authors (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  name VARCHAR(255) DEFAULT NULL
);

CREATE TABLE tasks (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  starting TIMESTAMP DEFAULT NULL,
  ending TIMESTAMP DEFAULT NULL
);

CREATE TABLE categories (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  name VARCHAR(255) NOT NULL,
  type VARCHAR(40) DEFAULT NULL
);

CREATE TABLE categories_posts (
  category_id INT NOT NULL,
  post_id INT NOT NULL
);

CREATE TABLE keyboards (
  key_number INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  name VARCHAR(255)
);

CREATE TABLE fk_test_has_pk (
  id INT NOT NULL PRIMARY KEY
);

CREATE TABLE fk_test_has_fk (
  id    INT NOT NULL PRIMARY KEY,
  fk_id INT NOT NULL,

  FOREIGN KEY (fk_id) REFERENCES fk_test_has_pk(id)
);

--This table has an altered lock_version column name
CREATE TABLE legacy_things (
  id INT GENERATED BY DEFAULT AS IDENTITY (START WITH 10000),
  tps_report_number INT DEFAULT NULL,
  version INT DEFAULT 0,
  PRIMARY KEY (id)
);

CREATE TABLE numeric_data (
  id INT NOT NULL PRIMARY KEY,
  bank_balance DECIMAL(10,2),
  big_bank_balance DECIMAL(15,2),
  world_population DECIMAL(10),
  my_house_population DECIMAL(2),
  decimal_number_with_default DECIMAL(3,2) DEFAULT 2.78
);

CREATE TABLE mixed_case_monkeys (
 monkeyID INT NOT NULL PRIMARY KEY,
 fleaCount INT
);

CREATE TABLE minimalistics (
  id INT NOT NULL PRIMARY KEY
);
