/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
 
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
 
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
    Alexander Pipelka
    pipelka@teleweb.at
 
    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/08/09 08:30:35 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/include/paragui.h,v $
    CVS/RCS Revision: $Revision: 1.1.2.12 $
    Status:           $State: Exp $
*/

#ifndef PARAGUI_H
#define PARAGUI_H

#ifdef SWIG
%include "swigcommon.h"
%module paragui
%{
#include "paragui.h"
%}
%include "paragui_types.h"
%include "pgrect.h"
%include "pgmessageobject.h"
%include "pgdrawobject.h"
%include "pgwidget.h"
%include "pgwidgetdnd.h"
%include "pggradientwidget.h"
%include "pgstaticframe.h"
%include "pgwidgetlist.h"
%include "pgapplication.h"
%include "pgbutton.h"
%include "pgbuttongroup.h"
%include "pgradiobutton.h"
%include "pgcheckbutton.h"
%include "pglabel.h"
%include "pglineedit.h"
%include "pgscrollbar.h"
%include "pgprogressbar.h"
%include "pgwindow.h"
%include "pgslider.h"
%include "pglistboxbaseitem.h"
%include "pglistboxitem.h"
%include "pgcolumnitem.h"
%include "pglistbox.h"
%include "pgmaskedit.h"
%include "pgmessagebox.h"
#endif

#include <stdlib.h>
#include <iostream>

// SDL
#include "SDL.h"
#include "SDL_ttf.h"
#include "SDL_thread.h"

#undef PACKAGE
#undef VERSION

#ifdef WIN32
#include "paraconfig_win32.h"
#else
#include "paraconfig.h"
#endif

#include "paragui_types.h"
#include "pgrect.h"
#include "pgtheme.h"

// disable win32 warnings on exporting STL objects
#ifdef WIN32
#ifdef _MSC_VER
	#pragma warning(disable: 4275)
	#pragma warning(disable: 4251)
	#pragma warning(disable: 4786)
	#pragma warning(disable: 4800)
#endif	// _MSC_VER
#endif	// WIN32

// For C++ compliance (required with gcc 3.0) 
#ifndef WIN32
using std::cerr;
using std::cout;
using std::endl;
using std::ios;
#endif

// default display depth
#define DISPLAY_DEPTH 16

// O.K., this is the old story...
// Make sure that file separator ain't the same on all platforms;
// Masahiro Minami<elsur@aaa.letter.co.jp>
// 01/05/06

#ifndef macintosh
#define PG_FILE_SEPARATOR	"/"
#else
#define PG_FILE_SEPARATOR	":"
#endif


// Background modes

#define BKMODE_TILE			1
#define BKMODE_STRETCH		2


// Button states

#define BTN_STATE_NORMAL		0
#define BTN_STATE_PRESSED		1
#define BTN_STATE_HIGH			2


// Text alignment

#define PG_TA_LEFT		0
#define PG_TA_CENTER	1
#define PG_TA_RIGHT	2


// Scrollbars

#define PG_SB_VERTICAL		1
#define PG_SB_HORIZONTAL	2

// internal widget ids

#define	PG_WIDGETID_INTERNAL	10000

// Scrollbar up,down,dragbutton

#define PG_IDSCROLLBAR_UP		PG_WIDGETID_INTERNAL + 1
#define PG_IDSCROLLBAR_DOWN	PG_WIDGETID_INTERNAL + 2
#define PG_IDSCROLLBAR_LEFT	PG_WIDGETID_INTERNAL + 3
#define PG_IDSCROLLBAR_RIGHT	PG_WIDGETID_INTERNAL + 4
#define PG_IDSCROLLBAR_DRAG	PG_WIDGETID_INTERNAL + 5

// WidgetList scrollbar
#define PG_IDWIDGETLIST_SCROLL	PG_WIDGETID_INTERNAL + 10

// Dropdown box
#define PG_IDDROPDOWN_BOX	PG_WIDGETID_INTERNAL + 11

// SpinnerBox
#define PG_IDSPINNERBOX_UP			PG_WIDGETID_INTERNAL + 12
#define PG_IDSPINNERBOX_DOWN		PG_WIDGETID_INTERNAL + 13

// Window
#define PG_WINDOW_CLOSE			PG_WIDGETID_INTERNAL + 14
#define PG_WINDOW_MINIMIZE		PG_WIDGETID_INTERNAL + 15
#define PG_WINDOW_RESTORE		PG_WIDGETID_INTERNAL + 15

// Application object
#define PG_IDAPPLICATION	PG_WIDGETID_INTERNAL + 100


// some global function declarations

SDL_Surface* PG_LoadImage(const char* file);

#endif // PARAGUI_H
