/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.JComponent;
import org.jgraph.JGraph;

public class Rule
extends JComponent
implements MouseMotionListener,
PropertyChangeListener {
    public static final Color middleGray = new Color(170, 170, 170);
    public static final NumberFormat nf = NumberFormat.getInstance();
    public static final int INCH = 72;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int SIZE = 15;
    public int activeoffset;
    public int activelength;
    private transient JGraph graph;
    public int orientation;
    public boolean isMetric;
    private double increment;
    private double units;
    private Point drag;
    private Point mouse = new Point();

    public Rule(int n, boolean bl, JGraph jGraph) {
        this.graph = jGraph;
        this.orientation = n;
        this.isMetric = bl;
        this.setIncrementAndUnits();
        nf.setMaximumFractionDigits(2);
        jGraph.addMouseMotionListener(this);
        jGraph.addPropertyChangeListener(this);
    }

    public void setIsMetric(boolean bl) {
        this.isMetric = bl;
        this.setIncrementAndUnits();
        this.repaint();
    }

    private void setIncrementAndUnits() {
        if (this.isMetric) {
            this.units = 28.346456692913385;
            this.units *= this.graph.getScale();
            this.increment = this.units;
        } else {
            this.units = 72.0;
            this.units *= this.graph.getScale();
            this.increment = this.units / 2.0;
        }
    }

    public boolean isMetric() {
        return this.isMetric;
    }

    public double getIncrement() {
        return this.increment;
    }

    public void setActiveOffset(int n) {
        this.activeoffset = n;
    }

    public void setActiveLength(int n) {
        this.activelength = n;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.graph.getPreferredSize();
        if (this.orientation == 0) {
            dimension.height = 15;
        } else {
            dimension.width = 15;
        }
        return dimension;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point;
        if (this.drag != null) {
            point = this.drag;
            this.drag = null;
            this.repaintStripe(point.x, point.y);
        }
        point = this.mouse;
        this.mouse = mouseEvent.getPoint();
        this.repaintStripe(point.x, point.y);
        this.repaintStripe(this.mouse.x, this.mouse.y);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = this.drag;
        this.drag = mouseEvent.getPoint();
        if (point != null) {
            this.repaintStripe(point.x, point.y);
        }
        this.repaintStripe(this.drag.x, this.drag.y);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("scale")) {
            this.repaint();
        }
    }

    public void repaintStripe(int n, int n2) {
        if (this.orientation == 0) {
            this.repaint(n, 0, 1, 15);
        } else {
            this.repaint(0, n2, 15, 1);
        }
    }

    public void paintComponent(Graphics graphics) {
        this.revalidate();
        this.setIncrementAndUnits();
        Rectangle rectangle = graphics.getClipBounds();
        if (this.activelength > 0) {
            graphics.setColor(middleGray);
        } else {
            graphics.setColor(Color.lightGray);
        }
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Point point = this.graph.toScreen(new Point(this.activeoffset, this.activelength));
        graphics.setColor(Color.lightGray);
        if (this.orientation == 0) {
            graphics.fillRect(point.x, rectangle.y, point.y, rectangle.height);
        } else {
            graphics.fillRect(rectangle.x, point.x, rectangle.width, point.y);
        }
        graphics.setFont(new Font("SansSerif", 0, 8));
        graphics.setColor(Color.black);
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        String string = null;
        if (this.orientation == 0) {
            d2 = Math.floor((double)rectangle.x / this.increment) * this.increment;
            d = Math.ceil((double)(rectangle.x + rectangle.width) / this.increment) * this.increment;
        } else {
            d2 = Math.floor((double)rectangle.y / this.increment) * this.increment;
            d = Math.ceil((double)(rectangle.y + rectangle.height) / this.increment) * this.increment;
        }
        if (d2 == 0.0) {
            string = Integer.toString(0) + (this.isMetric ? " cm" : " in");
            n = 10;
            if (this.orientation == 0) {
                graphics.drawLine(0, 14, 0, 15 - n - 1);
                graphics.drawString(string, 2, 11);
            } else {
                graphics.drawLine(14, 0, 15 - n - 1, 0);
                graphics.drawString(string, 1, 11);
            }
            string = null;
            d2 = this.increment;
        }
        boolean bl = false;
        double d3 = d2;
        while (d3 < d) {
            if (this.units == 0.0) {
                this.units = 1.0;
            }
            n = 10;
            string = nf.format(d3 / this.units);
            bl = false;
            if (n != 0) {
                if (this.orientation == 0) {
                    graphics.drawLine((int)d3, 14, (int)d3, 15 - n - 1);
                    if (string != null) {
                        graphics.drawString(string, (int)d3 + 2, 11);
                    }
                } else {
                    graphics.drawLine(14, (int)d3, 15 - n - 1, (int)d3);
                    if (string != null) {
                        graphics.drawString(string, 0, (int)d3 + 9);
                    }
                }
            }
            d3 += this.increment;
        }
        graphics.setColor(Color.green);
        if (this.orientation == 0) {
            graphics.drawLine(this.mouse.x, 14, this.mouse.x, 15 - n - 1);
        } else {
            graphics.drawLine(14, this.mouse.y, 15 - n - 1, this.mouse.y);
        }
        if (this.drag != null) {
            if (this.orientation == 0) {
                graphics.drawLine(this.drag.x, 14, this.drag.x, 15 - n - 1);
            } else {
                graphics.drawLine(14, this.drag.y, 15 - n - 1, this.drag.y);
            }
        }
    }
}

