/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.actions;

import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import javax.swing.JOptionPane;
import org.jgraph.GPGraphpad;
import org.jgraph.pad.DefaultGraphModelProvider;
import org.jgraph.pad.GPGraph;
import org.jgraph.pad.actions.AbstractActionDefault;
import org.jgraph.pad.resources.Translator;

public class FileImportJGraphpad
extends AbstractActionDefault {
    public FileImportJGraphpad(GPGraphpad gPGraphpad) {
        super(gPGraphpad);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        FileDialog fileDialog = new FileDialog(this.graphpad.getFrame(), Translator.getString("OldJGraphpadFile"), 0);
        fileDialog.show();
        if (fileDialog.getFile() == null) {
            return;
        }
        try {
            String string = "file://" + fileDialog.getDirectory() + fileDialog.getFile();
            if (fileDialog.getFile().toLowerCase().startsWith("http://") || fileDialog.getFile().toLowerCase().startsWith("ftp://")) {
                string = fileDialog.getFile();
            }
            final URL uRL = new URL(string);
            final DefaultGraphModelProvider defaultGraphModelProvider = new DefaultGraphModelProvider();
            Thread thread = new Thread("Read File Thread"){

                public void run() {
                    GPGraph gPGraph = defaultGraphModelProvider.createCleanGraph(defaultGraphModelProvider.createCleanGraphModel());
                    Object var2_2 = null;
                    try {
                        try {
                            InputStream inputStream = uRL.openStream();
                            inputStream = new GZIPInputStream(inputStream);
                            XMLDecoder xMLDecoder = new XMLDecoder(new BufferedInputStream(inputStream));
                            gPGraph.setArchivedState(xMLDecoder.readObject());
                            xMLDecoder.close();
                        }
                        catch (Exception exception) {
                            try {
                                InputStream inputStream = uRL.openStream();
                                XMLDecoder xMLDecoder = new XMLDecoder(new BufferedInputStream(inputStream));
                                gPGraph.setArchivedState(xMLDecoder.readObject());
                                xMLDecoder.close();
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                if (!uRL.toString().toLowerCase().startsWith("http://") && !uRL.toString().toLowerCase().startsWith("ftp://")) {
                                    throw fileNotFoundException;
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(FileImportJGraphpad.this.graphpad, exception.getLocalizedMessage(), Translator.getString("Error"), 0);
                        return;
                    }
                    FileImportJGraphpad.this.graphpad.addDocument(uRL, defaultGraphModelProvider, gPGraph, gPGraph.getModel(), null);
                    FileImportJGraphpad.this.graphpad.update();
                }
            };
            thread.start();
        }
        catch (Exception exception) {
            this.graphpad.error(exception.toString());
        }
    }
}

