/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pp4;

import de.tu_darmstadt.sp.pencil.PageCommand;
import de.tu_darmstadt.sp.pencil.commands.GCmd;
import de.tu_darmstadt.sp.pencil.commands.KCmd;
import de.tu_darmstadt.sp.pencil.commands.RGCmd;
import de.tu_darmstadt.sp.pencil.commands.gCmd;
import de.tu_darmstadt.sp.pencil.commands.kCmd;
import de.tu_darmstadt.sp.pencil.commands.rgCmd;
import de.tu_darmstadt.sp.pp4.PP4Chunks;
import de.tu_darmstadt.sp.pp4.PP4Exception;
import de.tu_darmstadt.sp.pp4.PP4Handler;
import java.util.StringTokenizer;

public class PP4hdColor
extends PP4Handler {
    private int cmdindex = -1;
    private PageCommand[] commands = new PageCommand[6];

    public void doit(String command, String arguments) throws PP4Exception {
        PP4Chunks chunks = this.getPagesRef().getChunks();
        StringTokenizer st = new StringTokenizer(arguments, " \t\n\r\f");
        int colorindex = -1;
        float[] numbers = new float[4];
        this.cmdindex = -1;
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if ((t.equals("reset") || t.equals("highlight") || t.equals("appear")) && !st.hasMoreTokens()) {
                if (colorindex >= 0 || this.cmdindex >= 0) {
                    throw new PP4Exception("Bad argument combination: " + command + " " + arguments);
                }
                if (t.equals("reset")) {
                    chunks.resetColorChange();
                } else if (t.equals("appear")) {
                    chunks.doBuild();
                } else {
                    chunks.doFlip();
                }
                return;
            }
            if (t.startsWith("c")) {
                this.vTeXColorCmd(t, ++this.cmdindex);
                ++this.cmdindex;
                continue;
            }
            try {
                float nextnumber = Float.parseFloat(t);
                if (++colorindex < 4) {
                    numbers[colorindex] = nextnumber;
                    continue;
                }
                throw new PP4Exception("Bad values supplied: " + command + " " + arguments);
            }
            catch (NumberFormatException numberFormatException) {
                if (++this.cmdindex > 5) {
                    throw new PP4Exception("Too many commands: " + command + " " + arguments);
                }
                if (t.equals("rg") || t.equals("RG")) {
                    if (colorindex > 2) {
                        throw new PP4Exception("Too many rg/RG arguments: " + command + " " + arguments);
                    }
                    this.commands[this.cmdindex] = t.equals("rg") ? new rgCmd(numbers[0], numbers[1], numbers[2]) : new RGCmd(numbers[0], numbers[1], numbers[2]);
                    colorindex = -1;
                    continue;
                }
                if (t.equals("k") || t.equals("K")) {
                    if (colorindex > 3) {
                        throw new PP4Exception("Too many k/K arguments: " + command + " " + arguments);
                    }
                    this.commands[this.cmdindex] = t.equals("k") ? new kCmd(numbers[0], numbers[1], numbers[2], numbers[3]) : new KCmd(numbers[0], numbers[1], numbers[2], numbers[3]);
                    colorindex = -1;
                    continue;
                }
                if (t.equals("g") || t.equals("G")) {
                    if (colorindex > 0) {
                        throw new PP4Exception("Too many g/G arguments: " + command + " " + arguments);
                    }
                    this.commands[this.cmdindex] = t.equals("g") ? new gCmd(numbers[0]) : new GCmd(numbers[0]);
                    colorindex = -1;
                    continue;
                }
                throw new PP4Exception("Bad value " + t + " supplied: " + command + " " + arguments);
            }
        }
        if (this.cmdindex != 5) {
            throw new PP4Exception("Not enough values supplied: " + command + " " + arguments);
        }
        chunks.addColorChange(this.commands[0], this.commands[2], this.commands[4]);
        chunks.addColorChange(this.commands[1], this.commands[3], this.commands[5]);
    }

    public String pattern() {
        return "%pausecolor";
    }

    private void vTeXColorCmd(String t, int index) throws PP4Exception {
        long color;
        float[] args = new float[4];
        int len = 1;
        if (t.charAt(1) == '\"') {
            len = 3;
        } else if (t.charAt(1) == ':') {
            len = 4;
        } else {
            throw new PP4Exception("Bad VTeX color specification in " + this.pattern() + " " + t);
        }
        try {
            color = Integer.parseInt(t.substring(2), 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new PP4Exception("Invalid hex value in " + this.pattern() + ": " + t);
        }
        int i = len;
        while (i > 0) {
            args[--i] = (float)((double)(color % 256L) / 255.0);
            color /= 256L;
        }
        if (len == 4) {
            this.commands[index] = new kCmd(args[0], args[1], args[2], args[3]);
            this.commands[this.cmdindex + 1] = new KCmd(args[0], args[1], args[2], args[3]);
        } else {
            this.commands[index] = new rgCmd(args[0], args[1], args[2]);
            this.commands[this.cmdindex + 1] = new RGCmd(args[0], args[1], args[2]);
        }
    }
}

