#!/usr/bin/perl -w
#
#  Perl Audio Converter - (Amarok Extension)
#
#  Copyright (C) 2005-2006 Philip Lyons
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

use strict;

my $dcop    = 'dcop';
my $pacpl     = 'pacpl';
my $player  = 'amarok';

my $name_str = "PACPL-Convert";

if (not `$dcop`) { system("kdialog --sorry \"DCOP does not appear to be in your path\""); clean_up(); }
if (not `$pacpl`)  { system("kdialog --error \"An error occurred while trying to execute pac\nRun pac from console for a complete list of errors\""); clean_up(); }

# Setup menu entries
sub menu {

    my $menu_cmd = "@_";
    my $dcop_call = "$dcop $player script $menu_cmd";
    
    system("kdialog --title \"PACX\" --msgbox \"Perl Audio Converter - (amaroK Extention)\n\nConverting a file is easy...\n\nSimply right click on a file and then click on PAC Convert\nNext click on the desired format you wish to convert the file to.\nYou can convert multiple files using the above method by holding down ctrl and click on each song you wish to convert.\n\nReport bugs to Philip Lyons (viiron\@gmail.com)\" &") if "$menu_cmd" ne "removeCustomMenuItem";
    
    system("$dcop_call $name_str \"To MP2\"");
    system("$dcop_call $name_str \"To MP3\"");
    system("$dcop_call $name_str \"To Ogg Vorbis\"");
    system("$dcop_call $name_str \"To FLAC\"");
    system("$dcop_call $name_str \"To FLAC: FLA\"");
    system("$dcop_call $name_str \"To Monkey Audio: APE\"");
    system("$dcop_call $name_str \"To Shorten: SHN\"");
    system("$dcop_call $name_str \"To FAAC: AAC\"");
    system("$dcop_call $name_str \"To FAAC: M4A\"");
    system("$dcop_call $name_str \"To FAAC: MP4\"");
    system("$dcop_call $name_str \"To Musepack: MPC\"");
    system("$dcop_call $name_str \"To Musepack: MPP\"");
    system("$dcop_call $name_str \"To Wavpack: WV\"");
    system("$dcop_call $name_str \"To OptimFrog: OFR\"");
    system("$dcop_call $name_str \"To OptimFrog: OFS\"");
    system("$dcop_call $name_str \"To TTA\"");
    system("$dcop_call $name_str \"To LPAC\"");
    system("$dcop_call $name_str \"To Kexis: KXS\"");
    system("$dcop_call $name_str \"To AIFF\"");
    system("$dcop_call $name_str \"To AU\"");
    system("$dcop_call $name_str \"To SND\"");
    system("$dcop_call $name_str \"To AC3\"");
    system("$dcop_call $name_str \"To Lossless Audio: LA\"");
    system("$dcop_call $name_str \"To BONK\"");
    system("$dcop_call $name_str \"To BONK: Lossless\"");
    system("$dcop_call $name_str \"To RAW\"");
    system("$dcop_call $name_str \"To VOC\"");
    system("$dcop_call $name_str \"To SMP\"");
    system("$dcop_call $name_str \"To RealAudio: RA\"");
    system("$dcop_call $name_str \"To WAV\"");

}


# Clean up menu entries, etc.
sub clean_up {
    menu("removeCustomMenuItem");
}
   
# Main 
sub main {

  menu("addCustomMenuItem");
  
  while (<STDIN>) {

    my  $input = $_;
    
    # Reinsert spaces & apostrophes
    $input =~ s/\%20/\\ /g;
    $input =~ s/\%27/\\'/g;
               
    # configuration
    system("kdesu kwrite /etc/pacpl/pacpl.conf") if $input =~ /configure/;

    # -> MP2
        if ($input =~ "customMenuClicked: $name_str To MP2") {
        
          $input =~ s/customMenuClicked: $name_str To MP2 file:\/\/\//\//g;
          $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                            
          chomp($input);
          system("$pacpl --convertto mp2 --gui $input");
                                           
    }
                                                    
    # -> MP3
    if ($input =~ "customMenuClicked: $name_str To MP3") {
    
          $input =~ s/customMenuClicked: $name_str To MP3 file:\/\/\//\//g;
          $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);

          chomp($input);
          system("$pacpl --convertto mp3 --gui $input");

    }

    # -> Ogg Vorbis
    elsif ($input =~ "customMenuClicked: $name_str To Ogg Vorbis") {
    
           $input =~ s/customMenuClicked: $name_str To Ogg Vorbis file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);

           chomp($input);
           system("$pacpl --convertto ogg $input --gui");
          
      
    }

    # -> FLAC
    elsif ($input =~ "customMenuClicked: $name_str To FLAC") {
    
           $input =~ s/customMenuClicked: $name_str To FLAC file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);

           chomp($input); 
           system("$pacpl --convertto flac $input --gui");
                                                                                                                                                   
    }
    
    # -> FLAC: FLA
    elsif ($input =~ "customMenuClicked: $name_str To FLAC: FLA") {
            
           $input =~ s/customMenuClicked: $name_str To FLAC: FLA file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                                  
           chomp($input);
           system("$pacpl --convertto fla $input --gui");
                                                        
    }
    
    # -> Monkey Audio: APE
    elsif ($input =~ "customMenuClicked: $name_str To Monkey Audio: APE") {
     
           $input =~ s/customMenuClicked: $name_str To Monkey Audio: APE file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);

           chomp($input);
           system("$pacpl --convertto ape $input --gui");
           
    }

    # -> Shorten: SHN
    elsif ($input =~ "customMenuClicked: $name_str To Shorten: SHN") {
    
           $input =~ s/customMenuClicked: $name_str To Shorten: SHN file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);

           chomp($input);
           system("$pacpl --convertto shn $input --gui");
      
    }        
                                                                                                                                                       
    # -> FAAC: AAC
    elsif ($input =~ "customMenuClicked: $name_str To FAAC: AAC") {
    
           $input =~ s/customMenuClicked: $name_str To FAAC: AAC file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);

           chomp($input);
           system("$pacpl --convertto aac $input --gui");
                                                                                                                                                   
    }
    
    # -> FAAC: M4A
    elsif ($input =~ "customMenuClicked: $name_str To FAAC: M4A") {
            
           $input =~ s/customMenuClicked: $name_str To FAAC: M4A file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                             
           chomp($input);
           system("$pacpl --convertto m4a $input --gui");
                                                  
    }
                                                       
    # -> FAAC: MP4
    elsif ($input =~ "customMenuClicked: $name_str To FAAC: MP4") {
    
           $input =~ s/customMenuClicked: $name_str To FAAC: MP4 file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);

           chomp($input);
           system("$pacpl --convertto mp4 $input --gui");

    }

    # -> Musepack: MPC
    elsif ($input =~ "customMenuClicked: $name_str To Musepack: MPC") {
    
           $input =~ s/customMenuClicked: $name_str To Musepack: MPC file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);

           chomp($input);
           system("$pacpl --convertto mpc $input --gui");
                        
    }

    # -> Musepack: MPP
    elsif ($input =~ "customMenuClicked: $name_str To Musepack: MPP") {
            
           $input =~ s/customMenuClicked: $name_str To Musepack: MPP file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                    
           chomp($input);
           system("$pacpl --convertto mpp $input --gui");
                                          
    }
    
    # -> Wavpack: WV
    elsif ($input =~ "customMenuClicked: $name_str To Wavpack: WV") {
    
           $input =~ s/customMenuClicked: $name_str To Wavpack: WV file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);

           chomp($input);
           system("$pacpl --convertto wv $input --gui");

    }  

    # -> OptimFrog: OFR
    elsif ($input =~ "customMenuClicked: $name_str To OptimFrog: OFR") {
            
           $input =~ s/customMenuClicked: $name_str To OptimFrog: OFR file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                             
           chomp($input);
           system("$pacpl --convertto ofr $input --gui");
                                                   
    }

    # -> OptimFrog: OFS
    elsif ($input =~ "customMenuClicked: $name_str To OptimFrog: OFS") {
          
           $input =~ s/customMenuClicked: $name_str To OptimFrog: OFS file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                             
           chomp($input);
           system("$pacpl --convertto ofs $input --gui");
                                                  
    }
                                                       
    # -> TTA
    elsif ($input =~ "customMenuClicked: $name_str To TTA") {
        
           $input =~ s/customMenuClicked: $name_str To TTA file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                         
           chomp($input);
           system("$pacpl --convertto tta $input --gui");
                                               
    }
    
    # -> LPAC
    elsif ($input =~ "customMenuClicked: $name_str To LPAC") {
            
           $input =~ s/customMenuClicked: $name_str To LPAC file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                             
           chomp($input);
           system("$pacpl --convertto pac $input --gui");
                                                  
    }
    
    # -> Kexis: KXS
    elsif ($input =~ "customMenuClicked: $name_str To Kexis: KXS") {
            
           $input =~ s/customMenuClicked: $name_str To Kexis: KXS file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                             
           chomp($input);
           system("$pacpl --convertto kxs $input --gui");
                                                   
    }
                                                                                                                                                       
    # -> AIFF
    elsif ($input =~ "customMenuClicked: $name_str To AIFF") {
        
           $input =~ s/customMenuClicked: $name_str To AIFF file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                              
           chomp($input);
           system("$pacpl --convertto aiff $input --gui");
                                                    
    }
                                                        
    # -> AU
    elsif ($input =~ "customMenuClicked: $name_str To AU") {
        
           $input =~ s/customMenuClicked: $name_str To AU file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                              
           chomp($input);
           system("$pacpl --convertto au $input --gui");
                                                    
    }
                                                        
    # -> SND
    elsif ($input =~ "customMenuClicked: $name_str To SND") {
        
           $input =~ s/customMenuClicked: $name_str To SND file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                              
           chomp($input);
           system("$pacpl --convertto snd $input --gui");
                                                    
    }
    
    # -> AC3
    if ($input =~ "customMenuClicked: $name_str To AC3") {
            
           $input =~ s/customMenuClicked: $name_str To AC3 file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                                
           chomp($input);
           system("$pacpl --convertto ac3 --gui $input");
                                                    
    }
    
    # -> Lossless Audio (LA)
    if ($input =~ "customMenuClicked: $name_str To Lossless Audio: LA") {
            
           $input =~ s/customMenuClicked: $name_str To Lossless Audio: LA file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                                
           chomp($input);
           system("$pacpl --convertto la --gui $input");
                                                    
    }
    
    # -> BONK
    elsif ($input =~ "customMenuClicked: $name_str To BONK") {
            
           $input =~ s/customMenuClicked: $name_str To BONK file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                    
           chomp($input);
           system("$pacpl --convertto bonk $input --gui");
                                          
    }
    
    # -> BONK: Lossless
    elsif ($input =~ "customMenuClicked: $name_str To BONK: Lossless") {
    
           $input =~ s/customMenuClicked: $name_str To BONK: Lossless file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
           
           chomp($input);
           system("$pacpl --convertto bonk --lossless $input --gui");
    
    }
                                              
    # -> RAW
    if ($input =~ "customMenuClicked: $name_str To RAW") {
            
           $input =~ s/customMenuClicked: $name_str To RAW file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                                
           chomp($input);
           system("$pacpl --convertto raw --gui $input");
                                                    
    }
    
    # -> VOC
    if ($input =~ "customMenuClicked: $name_str To VOC") {
            
           $input =~ s/customMenuClicked: $name_str To VOC file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                                
           chomp($input);
           system("$pacpl --convertto voc --gui $input");
                                                    
    }
    
    # -> SMP
    if ($input =~ "customMenuClicked: $name_str To SMP") {
            
           $input =~ s/customMenuClicked: $name_str To SMP file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                                
           chomp($input);
           system("$pacpl --convertto smp --gui $input");
                                                    
    }
    
    # -> RealAudio: RA
    if ($input =~ "customMenuClicked: $name_str To RealAudio: RA") {
            
           $input =~ s/customMenuClicked: $name_str To RealAudio: RA file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);
                                
           chomp($input);
           system("$pacpl --convertto ra --gui $input");
                                                    
    }
                                                        
    # -> WAV
    elsif ($input =~ "customMenuClicked: $name_str To WAV") {
    
           $input =~ s/customMenuClicked: $name_str To WAV file:\/\/\//\//g;
           $input =~ s/file:\/\/\//\//g if grep(/file:\/\/\//, $input);

           chomp($input);
           system("$pacpl --convertto wav $input --gui");
                                             
    }
                                                                                                                                                       
    # Remove custom menu entries
    $SIG{TERM} = \&clean_up; 

  }
  
}             

# Start main 
main();
#clean_up();