'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.8/tcllib-1.8/modules/pop3/pop3.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.2 2004/01/15 06:36:12 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "pop3" n 1.6.3 pop3 "Tcl POP3 Client Library"
.BS
.SH "NAME"
pop3 \- Tcl client for POP3 email protocol
'\" -*- tcl -*- doctools manpage
.SH "SYNOPSIS"
package require \fBTcl  8.2\fR
.sp
package require \fBpop3  ?1.6.3?\fR
.sp
\fB::pop3::open\fR ?\fB-msex\fR 0|1? ?\fB-retr-mode\fR retr|list|slow? \fIhost username password\fR ?\fIport\fR?
.sp
\fB::pop3::config\fR \fIchan\fR
.sp
\fB::pop3::status\fR \fIchan\fR
.sp
\fB::pop3::last\fR \fIchan\fR
.sp
\fB::pop3::retrieve\fR \fIchan startIndex\fR ?\fIendIndex\fR?
.sp
\fB::pop3::delete\fR \fIchan startIndex\fR ?\fIendIndex\fR?
.sp
\fB::pop3::list\fR \fIchan\fR ?\fImsg\fR?
.sp
\fB::pop3::top\fR \fIchan\fR \fImsg\fR \fIn\fR
.sp
\fB::pop3::uidl\fR \fIchan\fR ?\fImsg\fR?
.sp
\fB::pop3::close\fR \fIchan\fR
.sp
.BE
.SH "DESCRIPTION"
The \fBpop3\fR package provides a simple Tcl-only client library
for the POP3 email protocol as specified in
RFC 1939 (\fIhttp://www.rfc-editor.org/rfc/rfc1939.txt\fR). It works
by opening the standard POP3 socket on the server, transmitting the
username and password, then providing a Tcl API to access the POP3
protocol commands.  All server errors are returned as Tcl errors
(thrown) which must be caught with the Tcl \fBcatch\fR command.
.SH "COMMANDS"
.TP
\fB::pop3::open\fR ?\fB-msex\fR 0|1? ?\fB-retr-mode\fR retr|list|slow? \fIhost username password\fR ?\fIport\fR?
Open a socket connection to the server specified by \fIhost\fR,
transmit the \fIusername\fR and \fIpassword\fR as login information to
the server.  The default port number is 110, which can be overridden
using the optional \fIport\fR argument.  The return value is a channel
used by all of the other ::pop3 functions.
.sp
The command recognizes the options \fB-msex\fR and
\fB-retr-mode\fR. The first of them can be used to notify the
package of the fact that the server to talk to is an MS Exchange
server (which has some oddities we have to work around). The default
is 0.
.sp
The retrieval mode determines how exactly messages are read from the
server. The allowed values are \fBretr\fR, \fBlist\fR and
\fBslow\fR. The default is \fBretr\fR. See
\fB::pop3::retrieve\fR for more information.
.TP
\fB::pop3::config\fR \fIchan\fR
Returns the configuration of the pop3 connection identified by the
channel handle \fIchan\fR as a serialized array.
.TP
\fB::pop3::status\fR \fIchan\fR
Query the server for the status of the mail spool.  The status is
returned as a list containing two elements, the first is the number of
email messages on the server and the second is the size (in octets, 8
byte blocks) of the entire mail spool.
.TP
\fB::pop3::last\fR \fIchan\fR
Query the server for the last email message read from the spool.  This
value includes all messages read from all clients connecting to the
login account.  This command may not be supported by the email server,
in which case the server may return 0 or an error.
.TP
\fB::pop3::retrieve\fR \fIchan startIndex\fR ?\fIendIndex\fR?
Retrieve a range of messages from the server.  If the \fIendIndex\fR
is not specified, only one message will be retrieved.  The return
value is a list containing each message as a separate element.  See
the \fIstartIndex\fR and \fIendIndex\fR descriptions below.
.sp
The retrieval mode determines how exactly messages are read from the
server. The mode \fBretr\fR assumes that the RETR command delivers
the size of the message as part of the command status and uses this to
read the message efficiently. In mode \fBlist\fR RETR does not
deliver the size, but the LIST command does and we use this to
retrieve the message size before the actual retrieval, which can then
be done efficiently. In the last mode, \fBslow\fR, the system is
unable to obtain the size of the message to retrieve in any manner and
falls back to reading the message from the server line by line.
.sp
It should also be noted that the system checks upon the configured
mode and falls back to the slower modes if the above assumptions are
not true.
.TP
\fB::pop3::delete\fR \fIchan startIndex\fR ?\fIendIndex\fR?
Delete a range of messages from the server.  If the \fIendIndex\fR is
not specified, only one message will be deleted.  Note, the indices
are not reordered on the server, so if you delete message 1, then the
first message in the queue is message 2 (message index 1 is no longer
valid).  See the \fIstartIndex\fR and \fIendIndex\fR descriptions
below.
.RS
.TP
\fIstartIndex\fR
The \fIstartIndex\fR may be an index of a specific message starting
with the index 1, or it have any of the following values:
.RS
.TP
\fBstart\fR
This is a logical value for the first message in the spool, equivalent
to the value 1.
.TP
\fBnext\fR
The message immediately following the last message read, see
\fB::pop3::last\fR.
.TP
\fBend\fR
The most recent message in the spool (the end of the spool).  This is
useful to retrieve only the most recent message.
.RE
.TP
\fIendIndex\fR
The \fIendIndex\fR is an optional parameter and defaults to the value
"-1", which indicates to only retrieve the one message specified by
\fIstartIndex\fR.  If specified, it may be an index of a specific
message starting with the index "1", or it may have any of the
following values:
.RS
.TP
\fBlast\fR
The message is the last message read by a POP3 client, see
\fB::pop3::last\fR.
.TP
\fBend\fR
The most recent message in the spool (the end of the spool).
.RE
.RE
.TP
\fB::pop3::list\fR \fIchan\fR ?\fImsg\fR?
Returns the scan listing of the mailbox. If parameter \fImsg\fR is
given, then the listing only for that message is returned.
.TP
\fB::pop3::top\fR \fIchan\fR \fImsg\fR \fIn\fR
Optional POP3 command, not all servers may support this.
\fB::pop3::top\fR retrieves headers of a message, specified by
parameter \fImsg\fR, and number of \fIn\fR lines from the message
body.
.TP
\fB::pop3::uidl\fR \fIchan\fR ?\fImsg\fR?
Optional POP3 command, not all servers may support this.
\fB::pop3::uidl\fR returns the uid listing of the mailbox. If the
parameter \fImsg\fR is specified, then the listing only for that
message is returned.
.TP
\fB::pop3::close\fR \fIchan\fR
Gracefully close the connect after sending a POP3 QUIT command down
the socket.
.SH "KEYWORDS"
email, mail, pop, pop3, rfc 1939