'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.8/tcllib-1.8/modules/doctools/doctools_api.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2002-2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" -*- tcl -*- doctools manpage
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.2 2004/01/15 06:36:12 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "doctools_api" n 1.0 doctools "Documentation tools"
.BS
.SH "NAME"
doctools_api \- Specification of the Interface to Doctools Formatting Engines
.SH "SYNOPSIS"
\fBfmt_numpasses\fR
.sp
\fBfmt_initialize\fR
.sp
\fBfmt_setup\fR \fIn\fR
.sp
\fBfmt_postprocess\fR \fItext\fR
.sp
\fBfmt_shutdown\fR
.sp
\fBfmt_listvariables\fR
.sp
\fBfmt_varset\fR \fIvarname\fR \fItext\fR
.sp
\fBfmt_plain_text\fR \fItext\fR
.sp
\fBfmt_comment\fR \fItext\fR
.sp
\fBfmt_manpage_begin\fR \fIcommand\fR \fIsection\fR \fIversion\fR
.sp
\fBfmt_manpage_end\fR
.sp
\fBfmt_moddesc\fR \fIdesc\fR
.sp
\fBfmt_titledesc\fR \fIdesc\fR
.sp
\fBfmt_copyright\fR \fItext\fR
.sp
\fBfmt_description\fR
.sp
\fBfmt_require\fR \fIpkg\fR ?\fIversion\fR?
.sp
\fBfmt_section\fR \fIname\fR
.sp
\fBfmt_subsection\fR \fIname\fR
.sp
\fBfmt_para\fR
.sp
\fBfmt_see_also\fR \fIargs\fR
.sp
\fBfmt_keywords\fR \fIargs\fR
.sp
\fBfmt_arg\fR \fItext\fR
.sp
\fBfmt_cmd\fR \fItext\fR
.sp
\fBfmt_opt\fR \fItext\fR
.sp
\fBfmt_emph\fR \fItext\fR
.sp
\fBfmt_strong\fR \fItext\fR
.sp
\fBfmt_sectref\fR \fItext\fR ?\fIlabel\fR?
.sp
\fBfmt_syscmd\fR \fItext\fR
.sp
\fBfmt_method\fR \fItext\fR
.sp
\fBfmt_namespace\fR \fItext\fR
.sp
\fBfmt_option\fR \fItext\fR
.sp
\fBfmt_widget\fR \fItext\fR
.sp
\fBfmt_fun\fR \fItext\fR
.sp
\fBfmt_type\fR \fItext\fR
.sp
\fBfmt_package\fR \fItext\fR
.sp
\fBfmt_class\fR \fItext\fR
.sp
\fBfmt_var\fR \fItext\fR
.sp
\fBfmt_file\fR \fItext\fR
.sp
\fBfmt_uri\fR \fItext\fR ?\fItext\fR?
.sp
\fBfmt_term\fR \fItext\fR
.sp
\fBfmt_const\fR \fItext\fR
.sp
\fBfmt_nl\fR
.sp
\fBfmt_example_begin\fR
.sp
\fBfmt_example_end\fR
.sp
\fBfmt_list_begin\fR \fIwhat\fR
.sp
\fBfmt_list_end\fR
.sp
\fBfmt_bullet\fR
.sp
\fBfmt_enum\fR
.sp
\fBfmt_lst_item\fR \fItext\fR
.sp
\fBfmt_call\fR \fIargs\fR
.sp
\fBfmt_arg_def\fR \fItype\fR \fIname\fR ?\fImode\fR?
.sp
\fBfmt_opt_def\fR \fIname\fR ?\fIarg\fR?
.sp
\fBfmt_cmd_def\fR \fIcommand\fR
.sp
\fBfmt_tkoption_def\fR \fIname\fR \fIdbname\fR \fIdbclass\fR
.sp
\fBfmt_usage\fR \fIargs\fR
.sp
\fBdt_copyright\fR
.sp
\fBdt_file\fR
.sp
\fBdt_fileid\fR
.sp
\fBdt_fmap\fR \fIsymfname\fR
.sp
\fBdt_format\fR
.sp
\fBdt_lnesting\fR
.sp
\fBdt_module\fR
.sp
\fBdt_source\fR \fIfile\fR
.sp
\fBdt_user\fR
.sp
\fBex_cappend\fR
.sp
\fBex_cget\fR
.sp
\fBex_cis\fR
.sp
\fBex_cname\fR
.sp
\fBex_cpop\fR
.sp
\fBex_cpush\fR
.sp
\fBex_cset\fR
.sp
\fBex_lb\fR
.sp
\fBex_rb\fR
.sp
\fBc_inpass\fR
.sp
\fBc_begin\fR
.sp
\fBc_begun\fR
.sp
\fBc_set_module\fR \fItext\fR
.sp
\fBc_get_module\fR
.sp
\fBc_set_title\fR \fItext\fR
.sp
\fBc_get_title\fR
.sp
\fBc_provenance\fR
.sp
\fBc_pass\fR \fIpass proc arguments body\fR
.sp
\fBc_holdBuffers\fR \fIargs\fR
.sp
\fBc_hold\fR \fIbuffer entry\fR
.sp
\fBc_held\fR \fIbuffer\fR
.sp
\fBc_cnext\fR
.sp
\fBc_cinit\fR
.sp
\fBc_creset\fR
.sp
\fBNOP\fR \fIargs\fR
.sp
\fBNYI\fR ?\fImessage\fR?
.sp
\fBc_sectionId\fR \fIname\fR
.sp
\fBc_possibleReference\fR \fItext gi\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
This document specifies version 1 of the interface a doctools
formatting engine has to comply with to be usable by the package
\fBdoctools\fR.
The specification of the \fIdoctools\fR format all doctools
formatting engines have to process can be found in the companion
document \fIdoctools_fmt\fR.
.SH "API"
.SS "EXPORTED COMMANDS"
Each doctools formatting engine has to provide a number of commands
through which objects created by the package \fBdoctools\fR will
upon the functionality of the engine. These commands are described
here.
.TP
\fIManagement commands\fR
.RS
.TP
\fBfmt_numpasses\fR
This command is called by a doctools object immediately after it has
loaded the engine. No other command of the engine will be called
before it. It has to return the number of passes this engine requires
to fully process the input document. This value has to be an integer
number greater or equal to one.
.TP
\fBfmt_initialize\fR
This command is called at the beginning of every conversion run, as
the first command of that run. Note that a run is not a pass, but may
consist of multiple passes. See \fBfmt_numpasses\fR. The command has
to initialize the general state of the doctools formatting engine,
beyond the initialization done during the load.
.TP
\fBfmt_setup\fR \fIn\fR
This command is called at the beginning of each pass over the input in
a run. Its argument is the number of the pass which has begun. Passes
are counted from \fB1\fR upward. The command has to set up the
internal state of the doctools formatting engine for this particular
pass.
.TP
\fBfmt_postprocess\fR \fItext\fR
This command is called immediately after the last pass in a run. Its
argument is the result of the conversion generated by that pass. It is
provided to allow the engine to perform any global last-ditch
modifications of the generated document. The text returned by this
command will be the final result of the conversion.
.sp
An engine for a format which requires no postprocessing can simply
return the argument without change.
.TP
\fBfmt_shutdown\fR
This command is called at the end of every conversion run. It is the
last command called in a run. It has to clean up of all the
run-specific state in the doctools formatting engine. After the call
the engine has to be in a state which allows the initiation of another
run without fear that information from the last run is leaked into
this new run.
.TP
\fBfmt_listvariables\fR
This command is called by a doctools object after it has loaded the
engine (after \fBfmt_numpasses\fR). It has to return a list containing
the names of the engine parameters provided by the engine. This list
can be empty.
.TP
\fBfmt_varset\fR \fIvarname\fR \fItext\fR
This command is called whenever the doctools object wishes to set an
engine parameter to a particular value. The parameter to change is
specified by \fIvarname\fR, the value to set in \fItext\fR.
.sp
The command has to throw an error if an unknown \fIvarname\fR is
used. Only the names returned by \fBfmt_listvariables\fR are
considered known.
.sp
The values of all engine parameters have to persist between passes and
runs.
.RE
.TP
\fIFormatting commands\fR
The commands listed in this section are responsible for the conversion
of the input into the wanted output.
Their names are the names of the associated markup command, with
prefix \fBfmt_\fR added to them.
Not all markup commands have associated formatting commands. The two
exceptions are \fBvset\fR and \fBinclude\fR. These markup commands are
processed by the doctools object itself.
.sp
A detailed documentation of the markup commands can be found in the
companion document \fIdoctools_fmt\fR. It is the formal specification
of the \fIdoctools\fR format.
.sp
\fINote\fR: The formatting commands can expect that they are only
called in an order allowed by the format specification.
.RS
.TP
\fBfmt_plain_text\fR \fItext\fR
This command has no associated markup command. It is called for any
plain text encountered by the processor in the input. It has to
perform any special processing required for plain text. The text
returned as its result is added to the output. If no special
processing is required it has to simply return its argument without
change.
.TP
\fBfmt_comment\fR \fItext\fR
This command has to format the \fItext\fR as a comment and return the
formatted string. It has to return the empty string if the output
format has no way of formatting comments.
.TP
\fBfmt_manpage_begin\fR \fIcommand\fR \fIsection\fR \fIversion\fR
This command has to format the \fIcommand\fR name, the \fIsection\fR
the manpage resides in, and the \fIversion\fR of the module as the
start of the generated manpage and return the formatted string.
.TP
\fBfmt_manpage_end\fR
This command has to generate the end of the generated manpage and
return the formatted string.
.TP
\fBfmt_moddesc\fR \fIdesc\fR
This command remembers its argument \fIdesc\fR as a short description
of the module the manpage resides in. It may or may not return a
formatted string.
.TP
\fBfmt_titledesc\fR \fIdesc\fR
This command remembers its argument \fIdesc\fR as the title of the
manpage. It may or may not return a formatted string. If this command
was omitted the argument of \fBmoddesc\fR has to be be used for the
title as well.
.TP
\fBfmt_copyright\fR \fItext\fR
This command remembers its argument \fItext\fR as declaration of a
copyright assignment for the manpage. When invoked more than once the
assignments have to be accumulated. It may or may not return a
formatted string.
.sp
Assignments provided by this command have priority over information
supplied by an doctools processing application.
.TP
\fBfmt_description\fR
This command separates the header part of the manpage from the main
body. It may or may not return a formatted string.
.TP
\fBfmt_require\fR \fIpkg\fR ?\fIversion\fR?
This command remembers its arguments as name and version of a package
which is required by an application or other library to use the
described package. It may or may not return a formatted string.
.TP
\fBfmt_section\fR \fIname\fR
This command partitions the body of the manpage into named
sections. Note that the command \fBdescription\fR at the beginning of
the manpage body implicitly started a section named "DESCRIPTION". A
section command has to close the last \fBpara\fRgraph coming before it
and also open the first paragraph of the new section. It may or may
not return a formatted string.
.TP
\fBfmt_subsection\fR \fIname\fR
This command partitions the body of a \fIsection\fR into named
sub-sections.
A subsection command has to close the last \fBpara\fRgraph coming
before it and also opens the first paragraph of the new section.  It
may or may not return a formatted string.
.TP
\fBfmt_para\fR
This command partitions the text in a section or sub-section into
paragraphs. Each invokation has to close the paragraph coming before
it and open a new paragraph for the text coming after.  It may or may
not return a formatted string.
.TP
\fBfmt_see_also\fR \fIargs\fR
This command defines direct cross-references to other documents. Each
argument is a label identifying the referenced document. If this
command is used multiple times all the arguments have to accumulate.
It may or may not return a formatted string.
.TP
\fBfmt_keywords\fR \fIargs\fR
This command defines the keywords applying to this document. Each
argument is a single keyword. If this command is used multiple times
all the arguments have to accumulate.  It may or may not return a
formatted string.
.TP
\fBfmt_arg\fR \fItext\fR
This command declares that the argument \fItext\fR is the name of a
command argument.  It has to return a formatted string.
.TP
\fBfmt_cmd\fR \fItext\fR
This command declares that the argument \fItext\fR is the name of a
command.  It has to return a formatted string.
.TP
\fBfmt_opt\fR \fItext\fR
This command declares that the argument \fItext\fR is something
optional. It has to return a formatted string.
.TP
\fBfmt_emph\fR \fItext\fR
This command emphasizes the \fItext\fR.  It has to return a formatted
string.
.TP
\fBfmt_strong\fR \fItext\fR
This command emphasizes the \fItext\fR. Same as \fBemph\fR. Usage of
this command is discouraged. The command is deprecated and present
only for backward compatibility.  It has to return a formatted string.
.TP
\fBfmt_sectref\fR \fItext\fR ?\fIlabel\fR?
This command declares that the argument \fItext\fR is the name of a
section somewhere else in the document, and the current location
should refer to it.  It has to return a formatted string.
If a \fIlabel\fR is specified then it has to be used in the returned
text. Otherwise the section title \fItext\fR is used.
.TP
\fBfmt_syscmd\fR \fItext\fR
This command declares that the argument \fItext\fR is the name of a
system command.  It has to return a formatted string.
.TP
\fBfmt_method\fR \fItext\fR
This command declares that the argument \fItext\fR is the name of an
object method.  It has to return a formatted string.
.TP
\fBfmt_namespace\fR \fItext\fR
This command declares that the argument \fItext\fR is the name of a
namespace.  It has to return a formatted string.
.TP
\fBfmt_option\fR \fItext\fR
This command declares that the argument \fItext\fR is the name of an
option.  It has to return a formatted string.
.TP
\fBfmt_widget\fR \fItext\fR
This command declares that the argument \fItext\fR is the name of a
widget.  It has to return a formatted string.
.TP
\fBfmt_fun\fR \fItext\fR
This command declares that the argument \fItext\fR is the name of a
function.  It has to return a formatted string.
.TP
\fBfmt_type\fR \fItext\fR
This command declares that the argument \fItext\fR is the name of a
data type.  It has to return a formatted string.
.TP
\fBfmt_package\fR \fItext\fR
This command declares that the argument \fItext\fR is the name of a
package.  It has to return a formatted string.
.TP
\fBfmt_class\fR \fItext\fR
This command declares that the argument \fItext\fR is the name of a
class.  It has to return a formatted string.
.TP
\fBfmt_var\fR \fItext\fR
This command declares that the argument \fItext\fR is the name of a
variable.  It has to return a formatted string.
.TP
\fBfmt_file\fR \fItext\fR
This command declares that the argument \fItext\fR is a file.  It has
to return a formatted string.
.TP
\fBfmt_uri\fR \fItext\fR ?\fItext\fR?
This command declares that the argument \fItext\fR is an uri. The
second argument, if it is present, is the human-readable description
of the uri. In other words, the label for the link. Without a labeling
text the uri is used as its own label.  It has to return a formatted
string.
.TP
\fBfmt_term\fR \fItext\fR
This command declares that the argument \fItext\fR contains some
unspecific terminology.  It has to return a formatted string.
.TP
\fBfmt_const\fR \fItext\fR
This command declares that the argument \fItext\fR is a constant
value.  It has to return a formatted string.
.TP
\fBfmt_nl\fR
This command signals vertical space to separate blocks of text.  It
may or may not return a formatted string.
'\"
'\"     FUTURE: This is the same as para, but restricted to use inside of
'\"     list elements. Whereas para's are restricted to usage outside list
'\"     elements. Given that both do the same this separation is stupid.
'\"     Doctools V2 will have only one command, 'para', useable everywhere.
'\"     The formatting engine has to switch outputs, if truly necessary.
'\"
.TP
\fBfmt_example_begin\fR
This command begins an example block. Subsequent text belongs to the
example. Line breaks, spaces, and tabs have to be preserved literally.
It may or may not return a formatted string.
.TP
\fBfmt_example_end\fR
This command closes the example block.  It may or may not return a
formatted string.
.TP
\fBfmt_list_begin\fR \fIwhat\fR
This command starts new list. The value of the argument \fIwhat\fR
determines what type of list is opened. This also defines what command
has to be used to start an item in the new list. The allowed types
(and their associated item commands) are explained in the format
specification, i.e. \fIdoctools_fmt\fR.  It may or may not return a
formatted string.
.TP
\fBfmt_list_end\fR
This command ends the list opened by the last \fBlist_begin\fR.  It
may or may not return a formatted string.
.TP
\fBfmt_bullet\fR
This command starts a new list item in a bulletted list. The previous
item has to be closed automatically.  It may or may not return a
formatted string.
.TP
\fBfmt_enum\fR
This command starts a new list item in an enumerated list. The
previous item has to be closed automatically.  It may or may not
return a formatted string.
.TP
\fBfmt_lst_item\fR \fItext\fR
This command starts a new list item in a definition list. The argument
is the term to be defined. The previous item has to be closed
automatically.  It may or may not return a formatted string.
.TP
\fBfmt_call\fR \fIargs\fR
This command starts a new list item in a definition list, but the term
defined by it is a command and its arguments. The previous item is
automatically closed. The first argument is the name of the described
command, and everything after that are descriptions of the command
arguments.  It may or may not return a formatted string.
.TP
\fBfmt_arg_def\fR \fItype\fR \fIname\fR ?\fImode\fR?
This command starts a new list item in an argument list. The previous
item has to be closed automatically. Specifies the data-\fItype\fR of
the described argument, its \fIname\fR and its i/o-\fImode\fR. The
latter is optional.  It may or may not return a formatted string.
.TP
\fBfmt_opt_def\fR \fIname\fR ?\fIarg\fR?
This command starts a new list item in an option list. The previous
item has to be closed automatically. Specifies the \fIname\fR of the
option and its arguments (\fIarg\fR). The latter is a list, and can be
left out.  It may or may not return a formatted string.
.TP
\fBfmt_cmd_def\fR \fIcommand\fR
This command starts a new list item in a command list.  The previous
item has to be closed automatically.
Specifies the name of the \fIcommand\fR.  It may or may not return a
formatted string.
.TP
\fBfmt_tkoption_def\fR \fIname\fR \fIdbname\fR \fIdbclass\fR
This command starts a new list item in a widget option list. The
previous item has to be closed automatically.
Specifies the \fIname\fR of the option, i.e. the name used in scripts,
the name used by the option database (\fIdbname\fR), and the class
(type) of the option (\fIdbclass\fR).  It may or may not return a
formatted string.
.TP
\fBfmt_usage\fR \fIargs\fR
This command is like \fBcall\fR, except that a formatting engine must
not generate output at the location of the command. In other words,
this command is \fIsilent\fR. The data it defines may appear in a
different section of the output, for example a table of contents, or
synopsis, depending on the formatting engine and its output format.
It may or may not return a formatted string.
.RE
.PP
.SS "IMPORTED ENVIRONMENT"
The implementation of a doctools formatting engine can make the
following assumptions about the environment it is executed in:
.IP [1]
That it has full access to its own safe interpreter. In other words,
the engine cannot damage the other parts of the processor, nor can it
damage the filesystem.
.IP [2]
That the following commands are provided by the doctools object
controlling the engine:
.RS
.TP
Doctools commands
.RS
.TP
\fBdt_copyright\fR
This command returns a string containing the copyright information the
doctools object was configured with (option \fB-copyright\fR).
.TP
\fBdt_file\fR
This command returns the full name of the file currently processed by
the engine.
.TP
\fBdt_fileid\fR
This command returns the name of the file currently processed by the
engine, without path, nor extension.
.TP
\fBdt_fmap\fR \fIsymfname\fR
This command returns the actual name to use in the output in place of
the symbolic filename \fIsymfname\fR. It will return the unchanged
input if no mapping was found for \fIsymfname\fR.
.TP
\fBdt_format\fR
This command returns the name of the format currently executing.
.TP
\fBdt_lnesting\fR
This command returns the number of lists currently open.
.TP
\fBdt_module\fR
This command returns the name of the module the file currently
processed belongs to.
.TP
\fBdt_source\fR \fIfile\fR
This command allows the doctools formatting engine to load additional
tcl code.
Only files which are either in the same directory as the file
containing the engine, or below it, can be loaded. Trying to load a
file outside of this directory causes an error.
.TP
\fBdt_user\fR
This command returns the name of the current user as known to the tcl
interpreter the doctools object controlling the engine resides in.
.RE
.TP
Expander commands
All of the commands below are methods of the expander object (without
the prefix \fBex_\fR) handling the current input. This gives the
engine limited access to the state of the expander.
Their arguments and results are described in the documentation for the
package \fBexpander\fR.
.RS
.TP
\fBex_cappend\fR
.TP
\fBex_cget\fR
.TP
\fBex_cis\fR
.TP
\fBex_cname\fR
.TP
\fBex_cpop\fR
.TP
\fBex_cpush\fR
.TP
\fBex_cset\fR
.TP
\fBex_lb\fR
.TP
\fBex_rb\fR
.RE
.TP
Other commands
The file "\fI_common.tcl\fR" contains default implementations
of \fBfmt_plaint_text\fR and all the \fBfmt_\fR commands
listed in section \fBEXPORTED COMMANDS\fR.
It resides in the subdirectory "\fImpformats\fR" containing all the
predefined formats. This means that all external formats (i.e. not
provided by the package \fBdoctools\fR) cannot use it immediately,
but have to have a copy at their location.
Additional commands provided by this file are:
.RS
.TP
\fBc_inpass\fR
This command returns the id of the pass currently executing.
.TP
\fBc_begin\fR
This command signals that processing of the text
after \fBmanpage_begin\fR has begun.
.TP
\fBc_begun\fR
This command checks the flag set by \fBc_begin\fR.
.TP
\fBc_set_module\fR \fItext\fR
This command remembers \fItext\fR as module information.
.TP
\fBc_get_module\fR
This command retrieves the module information
stored by \fBc_set_module\fR.
.TP
\fBc_set_title\fR \fItext\fR
This command remembers \fItext\fR as title.
.TP
\fBc_get_title\fR
This command retrieves the title stored by \fBc_set_title\fR.
.TP
\fBc_provenance\fR
This command returns a string describing how the input was processed.
.TP
\fBc_pass\fR \fIpass proc arguments body\fR
This command defines a procedure which is valid when pass \fIpass\fR
of the engine is executed.
.TP
\fBc_holdBuffers\fR \fIargs\fR
This command defines one or more buffers for holding data between
passes.
.TP
\fBc_hold\fR \fIbuffer entry\fR
This command adds an entry to the specified buffer.
The buffer has to be defined by an earlier invocation of the command
\fBc_holdBuffers\fR.
.TP
\fBc_held\fR \fIbuffer\fR
This command retrieves the contents of the specified buffer. The
buffer is empty afterwards. All entries in the buffer are joined by
newlines.
.TP
\fBc_cnext\fR
This command increments the counter and return its current value.
.TP
\fBc_cinit\fR
This command pushes the current counter on the stack and reinitialize
the counter to zero.
.TP
\fBc_creset\fR
This command reinitializes the counter with the value on the counter
stack and removes that value from the stack.
.TP
\fBNOP\fR \fIargs\fR
This command does nothing.
It can be used in conjunction with \fBc_pass\fR to visibly declare in
which passes a formatting command has nothing to do.
.TP
\fBNYI\fR ?\fImessage\fR?
This command throws the error
"\fImessage\fR \fBNot yet implemented\fR".
.TP
\fBc_sectionId\fR \fIname\fR
This command remembers the name of the section for later
cross-referencing.
.TP
\fBc_possibleReference\fR \fItext gi\fR
This command checks if a section is available for \fItext\fR. This
command is currently tuned for use by engines like HTML and TMML.
.RE
.RE
.SH "SEE ALSO"
doctools, doctools_fmt
.SH "KEYWORDS"
HTML, LaTeX, TMML, document, generic markup, manpage, markup, nroff
.SH "COPYRIGHT"
.nf
Copyright (c) 2002-2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi