'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.8/tcllib-1.8/modules/doctools/docidx_api.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2003-2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" -*- tcl -*- doctools manpage
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.2 2004/01/15 06:36:12 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "docidx_api" n 1.0 doctools "Documentation tools"
.BS
.SH "NAME"
docidx_api \- Specification of the Interface to Index Formatting Engines
.SH "SYNOPSIS"
\fBidx_numpasses\fR
.sp
\fBidx_initialize\fR
.sp
\fBidx_setup\fR \fIn\fR
.sp
\fBidx_postprocess\fR \fItext\fR
.sp
\fBidx_shutdown\fR
.sp
\fBidx_listvariables\fR
.sp
\fBidx_varset\fR \fIvarname\fR \fItext\fR
.sp
\fBfmt_plain_text\fR \fItext\fR
.sp
\fBfmt_comment\fR \fItext\fR
.sp
\fBfmt_index_begin\fR \fItext\fR \fItitle\fR
.sp
\fBfmt_index_end\fR
.sp
\fBfmt_key\fR \fItext\fR
.sp
\fBfmt_manpage\fR \fIfile\fR \fItext\fR
.sp
\fBfmt_url\fR \fIurl\fR \fItext\fR
.sp
\fBdt_format\fR
.sp
\fBdt_fmap\fR \fIsymfname\fR
.sp
\fBdt_source\fR \fIfile\fR
.sp
\fBex_cappend\fR
.sp
\fBex_cget\fR
.sp
\fBex_cis\fR
.sp
\fBex_cname\fR
.sp
\fBex_cpop\fR
.sp
\fBex_cpush\fR
.sp
\fBex_cset\fR
.sp
\fBex_lb\fR
.sp
\fBex_rb\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
This document specifies version 1 of the interface an index formatting
engine has to comply with to be usable by the package
\fBdoctools::idx\fR.
The specification of the \fIdocidx\fR format all index formatting
engines have to process can be found in the companion document
\fIdocidx_fmt\fR.
.SH "API"
.SS "EXPORTED COMMANDS"
Each index formatting engine has to provide a number of commands
through which objects created by the package \fBdoctools::idx\fR
will upon the functionality of the engine. These commands are
described here.
.TP
\fIManagement commands\fR
.RS
.TP
\fBidx_numpasses\fR
This command is called by a docidx object immediately after it has
loaded the engine. No other command of the engine will be called
before it. It has to return the number of passes this engine requires
to fully process the input document. This value has to be an integer
number greater or equal to one.
.TP
\fBidx_initialize\fR
This command is called at the beginning of every conversion run, as
the first command of that run. Note that a run is not a pass, but may
consist of multiple passes. See \fBidx_numpasses\fR. The command has
to initialize the general state of the index formatting engine, beyond
the initialization done during the load.
.TP
\fBidx_setup\fR \fIn\fR
This command is called at the beginning of each pass over the input in
a run. Its argument is the number of the pass which has begun. Passes
are counted from \fB1\fR upward. The command has to set up the
internal state of the index formatting engine for this particular
pass.
.TP
\fBidx_postprocess\fR \fItext\fR
This command is called immediately after the last pass in a run. Its
argument is the result of the conversion generated by that pass. It is
provided to allow the engine to perform any global last-ditch
modifications of the generated document. The text returned by this
command will be the final result of the conversion.
.sp
An engine for a format which requires no postprocessing can simply
return the argument without change.
.TP
\fBidx_shutdown\fR
This command is called at the end of every conversion run. It is the
last command called in a run. It has to clean up of all the
run-specific state in the index formatting engine. After the call the
engine has to be in a state which allows the initiation of another run
without fear that information from the last run is leaked into this
new run.
.TP
\fBidx_listvariables\fR
This command is called by a docidx object after it has loaded the
engine (after \fBidx_numpasses\fR). It has to return a list containing
the names of the engine parameters provided by the engine. This list
can be empty.
.TP
\fBidx_varset\fR \fIvarname\fR \fItext\fR
This command is called whenever the docidx object wishes to set an
engine parameter to a particular value. The parameter to change is
specified by \fIvarname\fR, the value to set in \fItext\fR.
.sp
The command has to throw an error if an unknown \fIvarname\fR is
used. Only the names returned by \fBidx_listvariables\fR are
considered known.
.sp
The values of all engine parameters have to persist between passes and
runs.
.RE
.sp
.TP
\fIFormatting commands\fR
The commands listed in this section are responsible for the conversion
of the input into the wanted output.
Their names are the names of the associated markup command, with
prefix \fBfmt_\fR added to them.
Not all markup commands have associated formatting commands. The two
exceptions are \fBvset\fR and \fBinclude\fR. These markup commands are
processed by the docidx object itself.
.sp
A detailed documentation of the markup commands can be found in the
companion document \fIdocidx_fmt\fR. It is the formal specification
of the \fIdocidx\fR format.
.sp
\fINote\fR: The formatting commands can expect that they are only
called in an order allowed by the format specification.
.RS
.TP
\fBfmt_plain_text\fR \fItext\fR
This command has no associated markup command. It is called for any
plain text encountered by the processor in the input. It has to
perform any special processing required for plain text. The text
returned as its result is added to the output. If no special
processing is required it has to simply return its argument without
change.
.TP
\fBfmt_comment\fR \fItext\fR
This command has to format the \fItext\fR as a comment and return the
formatted string. It has to return the empty string if the output
format has no way of formatting comments.
.TP
\fBfmt_index_begin\fR \fItext\fR \fItitle\fR
This command has to format the label \fItext\fR and the associated
\fItitle\fR string as the start of the generated index and return
the formatted string.
.TP
\fBfmt_index_end\fR
This command has to generate the end of the generated index and return
the formatted string.
.TP
\fBfmt_key\fR \fItext\fR
This commands has to format the keyword \fItext\fR at the beginning of
a list of documents and other entities which belong to it and return
the formatted string.
.TP
\fBfmt_manpage\fR \fIfile\fR \fItext\fR
This command has to format a document reference and return the
formatted string.
The document referenced by the entry is specified through its symbolic
name \fIfile\fR, whereas the label to use for the link is provided by
\fItext\fR.
Use the command \fBdt_fmap\fR to convert the symbolic name to the
actual link.
It is described in section \fBIMPORTED ENVIRONMENT\fR.
.TP
\fBfmt_url\fR \fIurl\fR \fItext\fR
This is the second command to describe an index element. It has to
format an url reference and return the formatted string. The label to
use is provided by \fItext\fR, like for \fBfmt_manpage\fR. The place
to link to is however not given through a symbolic name, but the exact
uri to use in the output.
.RE
.PP
.SS "IMPORTED ENVIRONMENT"
The implementation of an index formatting engine can make the
following assumptions about the environment it is executed in:
.IP [1]
That it has full access to its own safe interpreter. In other words,
the engine cannot damage the other parts of the processor, nor can it
damage the filesystem.
.IP [2]
That the following commands are provided by the docidx object
controlling the engine:
.RS
.TP
Doctools commands
.RS
.TP
\fBdt_format\fR
This command returns the name of the format currently executing.
.TP
\fBdt_fmap\fR \fIsymfname\fR
This command returns the actual name to use in the output in place of
the symbolic filename \fIsymfname\fR. It will return the unchanged
input if no mapping was found for \fIsymfname\fR.
.TP
\fBdt_source\fR \fIfile\fR
This command allows the index formatting engine to load additional tcl
code.
Only files which are either in the same directory as the file
containing the engine, or below it, can be loaded. Trying to load a
file outside of this directory causes an error.
.RE
.sp
.TP
Expander commands
All of the commands below are methods of the expander object (without
the prefix \fBex_\fR) handling the current input. This gives the
engine limited access to the state of the expander.
Their arguments and results are described in the documentation for the
package \fBexpander\fR.
.RS
.TP
\fBex_cappend\fR
.TP
\fBex_cget\fR
.TP
\fBex_cis\fR
.TP
\fBex_cname\fR
.TP
\fBex_cpop\fR
.TP
\fBex_cpush\fR
.TP
\fBex_cset\fR
.TP
\fBex_lb\fR
.TP
\fBex_rb\fR
.RE
.sp
.TP
Other commands
The file "\fI_idx_common.tcl\fR" contains default implementations of
\fBfmt_plaint_text\fR and all the \fBidx_\fR commands listed in
section \fBEXPORTED COMMANDS\fR.
It resides in the subdirectory "\fImpformats\fR" containing all the
predefined formats. This means that all external formats (i.e. not
provided by the package \fBdoctools::idx\fR) cannot use it
immediately, but have to have a copy at their location.
.RE
.SH "SEE ALSO"
docidx, docidx_fmt
.SH "KEYWORDS"
HTML, LaTeX, TMML, generic markup, index, keyword index, keywords, markup, nroff
.SH "COPYRIGHT"
.nf
Copyright (c) 2003-2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi