'\"
'\" Generated from file '/usr/obj/i386/tcllib-1.8/tcllib-1.8/modules/des/des.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2005, Pat Thoyts <patthoyts@users.sourceforge.net>
'\"
'\" -*- tcl -*- doctools manpage
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.2 2004/01/15 06:36:12 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "des" n 1.0 des "Data Encryption Standard (DES)"
.BS
.SH "NAME"
des \- Implementation of the DES and triple-DES ciphers
.SH "SYNOPSIS"
package require \fBTcl  8.2\fR
.sp
package require \fBdes  1.0\fR
.sp
\fB::DES::des\fR ?\fI-mode [ecb|cbc|cfb|ofb]\fR? ?\fI-dir [encrypt|decrypt]\fR? \fI-key keydata\fR ?\fI-iv vector\fR? ?\fI-hex\fR? ?\fI-weak\fR? ?\fI-out channel\fR? ?\fI-chunksize size\fR? [ \fI-in channel\fR | \fIdata\fR ]
.sp
\fB::DES::Init\fR \fImode\fR \fIkeydata\fR \fIiv\fR ?\fIweak\fR?
.sp
\fB::DES::Encrypt\fR \fIKey\fR \fIdata\fR
.sp
\fB::DES::Decrypt\fR \fIKey\fR \fIdata\fR
.sp
\fB::DES::Reset\fR \fIKey\fR \fIiv\fR
.sp
\fB::DES::Final\fR \fIKey\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
This is an implementation in Tcl of the Data Encryption Standard (DES)
as published by the U.S. National Institute of Standards and
Technology (NIST) [1]. This implementation also supports triple
DES (3DES) extension to DES. DES is a 64-bit block cipher that uses a
56-bit key. 3DES uses a 168-bit key. DES has now officially been
superceeded by AES but is in common use in many protocols.
.PP
The tcllib implementation of DES and 3DES uses an implementation by
Mac Cody and is available as a separate download from [2]. For
anyone concerned about the details of exporting this code please see
the TclDES web pages. The tcllib specific code is a wrapper to the
TclDES API that presents same API for the DES cipher as for other
ciphers in the library.
.SH "COMMANDS"
.TP
\fB::DES::des\fR ?\fI-mode [ecb|cbc|cfb|ofb]\fR? ?\fI-dir [encrypt|decrypt]\fR? \fI-key keydata\fR ?\fI-iv vector\fR? ?\fI-hex\fR? ?\fI-weak\fR? ?\fI-out channel\fR? ?\fI-chunksize size\fR? [ \fI-in channel\fR | \fIdata\fR ]
Perform the \fBDES\fR algorithm on either the data provided
by the argument or on the data read from the \fI-in\fR channel. If
an \fI-out\fR channel is given then the result will be written to
this channel.
.sp
The \fI-key\fR option must be given. This parameter takes a binary
string of 8 bytes in length and is used to generate the key schedule.
In DES only 56 bits of key data are used. The highest bit from each
byte is discarded.
.sp
The \fI-mode\fR and \fI-dir\fR options are optional and default to cbc
mode and encrypt respectively. The initialization vector \fI-iv\fR
takes an 8 byte binary argument. This defaults to all zeros. See
\fBMODES OF OPERATION\fR for more about \fI-mode\fR and the use
of the initialization vector.
.sp
DES is a 64-bit block cipher. This means that the data must be
provided in units that are a multiple of 8 bytes.
.SH "PROGRAMMING INTERFACE"
Internal state is maintained in an opaque structure that is returned
from the \fBInit\fR function. In ECB mode the state is not affected by
the input but for other modes some input dependent state is maintained
and may be reset by calling the \fBReset\fR function with a new
initialization vector value.
.TP
\fB::DES::Init\fR \fImode\fR \fIkeydata\fR \fIiv\fR ?\fIweak\fR?
Construct a new DES key schedule using the specified key data and the
given initialization vector. The initialization vector is not used
with ECB mode but is important for other usage modes.
See \fBMODES OF OPERATION\fR.
.sp
There are a small number of keys that are known to be weak when used
with DES. By default if such a key is passed in then an error will be
raised. If there is a need to accept such keys then the \fIweak\fR
parameter can be set true to avoid the error being thrown.
.TP
\fB::DES::Encrypt\fR \fIKey\fR \fIdata\fR
Use a prepared key acquired by calling \fBInit\fR to encrypt the
provided data. The data argument should be a binary array that is a
multiple of the DES block size of 8 bytes. The result is a binary
array the same size as the input of encrypted data.
.TP
\fB::DES::Decrypt\fR \fIKey\fR \fIdata\fR
Decipher data using the key. Note that the same key may be used to
encrypt and decrypt data provided that the initialization vector is
reset appropriately for CBC mode.
.TP
\fB::DES::Reset\fR \fIKey\fR \fIiv\fR
Reset the initialization vector. This permits the programmer to re-use
a key and avoid the cost of re-generating the key schedule where the
same key data is being used multiple times.
.TP
\fB::DES::Final\fR \fIKey\fR
This should be called to clean up resources associated with \fIKey\fR.
Once this function has been called the key may not be used again.
.SH "MODES OF OPERATION"
.TP
Electronic Code Book (ECB)
ECB is the basic mode of all block ciphers. Each block is encrypted
independently and so identical plain text will produce identical
output when encrypted with the same key. Any encryption errors will
only affect a single block however this is vulnerable to known
plaintext attacks.
.TP
Cipher Block Chaining (CBC)
CBC mode uses the output of the last block encryption to affect the
current block. An initialization vector of the same size as the cipher
block size is used to handle the first block. The initialization
vector should be chosen randomly and transmitted as the first block of
the output. Errors in encryption affect the current block and the next
block after which the cipher will correct itself. CBC is the most
commonly used mode in software encryption.
.TP
Cipher Feedback (CFB)
CFB mode can be used to convert block ciphers into stream ciphers. In
CFB mode the initialization vector is encrypted and the output is then
xor'd with the plaintext stream. The result is then used as the
initialization vector for the next round. Errors will affect the
current block and the next block.
.TP
Output Feedback (OFB)
OFB is similar to CFB except that the output of the cipher is fed back
into the next round and not the xor'd plain text. This means that
errors only affect a single block but the cipher is more vulnerable to
attack.
.SH "EXAMPLES"
.nf

% set ciphertext [DES::des -mode cbc -dir encrypt -key $secret $plaintext]
% set plaintext [DES::des -mode cbc -dir decrypt -key $secret $ciphertext]

.fi
.nf

set iv [string repeat \\\\0 8]
set Key [DES::Init cbc \\\\0\\\\1\\\\2\\\\3\\\\4\\\\5\\\\6\\\\7 $iv]
set ciphertext [DES::Encrypt $Key "somedata"]
append ciphertext [DES::Encrypt $Key "moredata"]
DES::Reset $Key $iv
set plaintext [DES::Decrypt $Key $ciphertext]
DES::Final $Key

.fi
.SH "REFERENCES"
.IP [1]
"Data Encryption Standard",
Federal Information Processing Standards Publication 46-3, 1999,
(\fIhttp://csrc.nist.gov/publications/fips/fips46-3/fips46-3.pdf\fR)
.IP [2]
"TclDES: munitions-grade Tcl scripting"
\fIhttp://tcldes.sourceforge.net/\fR
.SH "AUTHORS"
Jochen C Loewer,
Mac Cody,
Pat Thoyts
.SH "SEE ALSO"
aes(n), blowfish(n), md5(n), rc4(n), sha1(n)
.SH "KEYWORDS"
3DES, DES, block cipher, data integrity, encryption, security
.SH "COPYRIGHT"
.nf
Copyright (c) 2005, Pat Thoyts <patthoyts@users.sourceforge.net>

.fi