#!/usr/bin/octave -iq

function line=read_data(in,out,data)
	fprintf(out,'%s gettext\n\n',data);
	if(isstr ( line=fgets(in) ))
		if(strcmp(line,'length 0\n'))
			line="";
			return;
		end
		line=fgets(in);
		l=columns(line);
		line=substr(line,1,l-1);
	end
end

out=stdout;

in=fopen('Integrate.ws','r');
while(isstr ( line=fgets(in) ))
	fprintf(out,'%s',line);
end

in=stdin;


action=-1;

while( action<0 && isstr ( line=fgets(in) ) )
	fprintf(stderr,"%s",line);
	if(strcmp(substr(line,1,7),'*cancel') || strcmp(substr(line,1,7),'*window'))
		action=0;
		break;
	end
	if(strcmp(substr(line,1,3),'*ok'))
		action=1;
		fprintf(stderr,"Exec ok\n");
		break;
	end
	if(strcmp(substr(line,1,5),'*copy'))
		action=2;
		break;
	end
end

fprintf(out,"\nwindow close\n\n");
fprintf(stderr,"window close\n");
fflush(out);

command="";

if(action!=0)
	func=read_data(in,out,'func');
	fprintf(stderr,"func=%s\n",func);
	x_min=read_data(in,out,'x_min');
	fprintf(stderr,"x_max=%s\n",x_min);
	fprintf(out,'x_min gettext\n\n');
	x_max=read_data(in,out,'x_max');
	fprintf(stderr,"x_max=%s\n",x_max);
	command=sprintf('quad(\"%s\",%s,%s)\n',func,x_min,x_max);
end

if(action==1)
	%Se ejecuta Ok
	fprintf(stderr,'%s\n',command);
elseif (action==2)
	
end
fprintf(out,'quit\n\n');


