/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import java.awt.Color;
import java.io.IOException;
import java.util.Vector;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentSerializer;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.converter.xml.sxc.BookSettings;
import org.openoffice.xmerge.converter.xml.sxc.CellStyle;
import org.openoffice.xmerge.converter.xml.sxc.ColumnRowInfo;
import org.openoffice.xmerge.converter.xml.sxc.ColumnStyle;
import org.openoffice.xmerge.converter.xml.sxc.Format;
import org.openoffice.xmerge.converter.xml.sxc.NameDefinition;
import org.openoffice.xmerge.converter.xml.sxc.RowStyle;
import org.openoffice.xmerge.converter.xml.sxc.SpreadsheetEncoder;
import org.openoffice.xmerge.converter.xml.sxc.SxcDocument;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class SxcDocumentSerializer
implements OfficeConstants,
DocumentSerializer {
    private Color foreground = Color.black;
    private Color background = Color.white;
    private long format = 0L;
    private Format fmt = new Format();
    private int rowID = 1;
    private int colID = 1;
    private int rowsRepeated = 1;
    private int colsRepeated = 1;
    private StyleCatalog styleCat = null;
    private Vector ColumnRowList;
    private int displayWidth = 0;
    protected SpreadsheetEncoder encoder = null;
    protected SxcDocument sxcDoc = null;

    public SxcDocumentSerializer(Document document) {
        this.sxcDoc = (SxcDocument)document;
    }

    public abstract ConvertData serialize() throws ConvertException, IOException;

    public void traverseSettings(Node node) throws IOException {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string = node2.getNodeName();
                if (string.equals("config:config-item-set")) {
                    this.traverseSettings(node2);
                    continue;
                }
                if (string.equals("config:config-item-map-indexed")) {
                    this.traverseSettings(node2);
                    continue;
                }
                if (string.equals("config:config-item-map-entry")) {
                    BookSettings bookSettings = new BookSettings(node2);
                    this.encoder.addSettings(bookSettings);
                    continue;
                }
                Debug.log(4, "<OTHERS " + XmlUtil.getNodeInfo(node2) + " />");
            }
        }
    }

    protected void loadStyles(SxcDocument sxcDocument) {
        org.w3c.dom.Document document;
        this.styleCat = new StyleCatalog(25);
        NodeList nodeList = null;
        String[] stringArray = new String[]{"table-column", "table-row", "table-cell"};
        Class[] classArray = new Class[]{ColumnStyle.class, RowStyle.class, CellStyle.class};
        org.w3c.dom.Document document2 = sxcDocument.getContentDOM();
        nodeList = document2.getElementsByTagName("office:automatic-styles");
        if (nodeList.getLength() != 0) {
            this.styleCat.add(nodeList.item(0), stringArray, classArray, null, false);
        }
        if ((nodeList = (document = sxcDocument.getStyleDOM()).getElementsByTagName("office:styles")).getLength() != 0) {
            this.styleCat.add(nodeList.item(0), stringArray, classArray, null, false);
        }
    }

    protected void traverseBody(Node node) throws IOException {
        Debug.log(4, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        Debug.log(4, "<DEBUGLOG>");
        if (node.hasChildNodes()) {
            String string;
            Node node2;
            int n;
            NodeList nodeList = node.getChildNodes();
            int n2 = nodeList.getLength();
            for (n = 0; n < n2; ++n) {
                node2 = nodeList.item(n);
                if (node2.getNodeType() != 1) continue;
                string = node2.getNodeName();
                if (string.equals("table:named-expressions")) {
                    this.traverseNamedExpressions(node2);
                    continue;
                }
                Debug.log(4, "Skipping " + XmlUtil.getNodeInfo(node2) + " />");
            }
            for (n = 0; n < n2; ++n) {
                node2 = nodeList.item(n);
                if (node2.getNodeType() != 1) continue;
                string = node2.getNodeName();
                if (string.equals("table:table")) {
                    this.traverseTable(node2);
                    continue;
                }
                Debug.log(4, "<OTHERS " + XmlUtil.getNodeInfo(node2) + " />");
            }
        }
        Debug.log(4, "</DEBUGLOG>");
    }

    protected void traverseNamedExpressions(Node node) throws IOException {
        Debug.log(4, "<NAMED:EXPRESSIONS>");
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                NameDefinition nameDefinition = new NameDefinition(node2);
                this.encoder.setNameDefinition(nameDefinition);
            }
        }
        Debug.log(4, "</NAMED:EXPRESSIONS>");
    }

    protected void traverseTable(Node node) throws IOException {
        Debug.log(4, "<TABLE>");
        this.ColumnRowList = new Vector();
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = namedNodeMap.getNamedItem("table:name").getNodeValue();
        this.rowID = 1;
        this.encoder.createWorksheet(string);
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string2 = node2.getNodeName();
                if (string2.equals("table:table-row")) {
                    this.traverseTableRow(node2);
                    continue;
                }
                if (string2.equals("table:table-column")) {
                    this.traverseTableColumn(node2);
                    continue;
                }
                if (string2.equals("table:scenario")) continue;
                Debug.log(4, "<OTHERS " + XmlUtil.getNodeInfo(node2) + " />");
            }
        }
        this.encoder.setColumnRows(this.ColumnRowList);
        Debug.log(4, "</TABLE>");
    }

    protected void traverseTableRow(Node node) throws IOException {
        Object object;
        Object object2;
        int n;
        Object object3;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            Object object4;
            object3 = namedNodeMap.getNamedItem("table:style-name");
            Node node2 = namedNodeMap.getNamedItem("table:number-rows-repeated");
            n = 1;
            if (node2 != null) {
                object2 = node2.getNodeValue();
                Debug.log(4, "traverseTableRow() repeated-rows : " + (String)object2);
                n = Integer.parseInt((String)object2);
            }
            object2 = new String("");
            if (object3 != null) {
                object2 = object3.getNodeValue();
            }
            if (((String)object2).equalsIgnoreCase("Default") || ((String)object2).length() == 0) {
                Debug.log(4, "No defined Row Style Attribute was found");
            } else {
                object = (RowStyle)this.styleCat.lookup((String)object2, "table-row", null, RowStyle.class);
                int n2 = ((RowStyle)object).getRowHeight();
                Debug.log(4, "traverseTableRow() Row Height : " + n2);
                object4 = new ColumnRowInfo(n2, n, 2, n2 != 0);
                this.ColumnRowList.add(object4);
            }
            object = namedNodeMap.getNamedItem("table:number-rows-repeated");
            if (object != null) {
                String string = object.getNodeValue();
                object4 = new Integer(string);
                this.rowsRepeated = (Integer)object4;
            } else {
                this.rowsRepeated = 1;
            }
        }
        Debug.log(4, "<TR>");
        if (node.hasChildNodes()) {
            object3 = node.getChildNodes();
            int n3 = object3.getLength();
            for (n = 0; n < n3; ++n) {
                object2 = object3.item(n);
                if (object2.getNodeType() != 1) continue;
                object = object2.getNodeName();
                if (((String)object).equals("table:table-cell")) {
                    this.traverseCell((Node)object2);
                    continue;
                }
                Debug.log(4, "<OTHERS " + XmlUtil.getNodeInfo((Node)object2) + " />");
            }
        }
        this.rowID += this.rowsRepeated;
        this.rowsRepeated = 1;
        this.colID = 1;
        this.colsRepeated = 1;
        Debug.log(4, "</TR>");
    }

    protected void traverseTableColumn(Node node) throws IOException {
        Cloneable cloneable;
        Object object;
        Debug.log(4, "traverseColumn() : ");
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("table:style-name");
        Node node3 = namedNodeMap.getNamedItem("table:number-columns-repeated");
        Node node4 = namedNodeMap.getNamedItem("table:default-cell-style-name");
        int n = 1;
        int n2 = 0;
        ColumnRowInfo columnRowInfo = new ColumnRowInfo(1);
        if (node3 != null) {
            Debug.log(4, "traverseColumn() repeated-cols : " + node3.getNodeValue());
            n = Integer.parseInt(node3.getNodeValue());
            columnRowInfo.setRepeated(n);
        }
        String string = new String("");
        if (node4 != null) {
            string = node4.getNodeValue();
            Debug.log(4, "traverseColumn() default-cell-style : " + string);
        }
        if (string.equalsIgnoreCase("Default") || string.length() == 0) {
            Debug.log(4, "No default cell Style Attribute was found");
        } else {
            object = (CellStyle)this.styleCat.lookup(string, "table-cell", null, CellStyle.class);
            cloneable = new Format(((CellStyle)object).getFormat());
            columnRowInfo.setFormat((Format)cloneable);
        }
        object = new String("");
        if (node2 != null) {
            object = node2.getNodeValue();
        }
        if (((String)object).equalsIgnoreCase("Default") || ((String)object).length() == 0) {
            Debug.log(4, "No defined Style Attribute was found");
        } else {
            cloneable = (ColumnStyle)this.styleCat.lookup((String)object, "table-column", null, ColumnStyle.class);
            n2 = ((ColumnStyle)cloneable).getColWidth();
            columnRowInfo.setSize(n2);
            Debug.log(4, "traverseColumn() Column Width : " + n2);
        }
        this.ColumnRowList.add(columnRowInfo);
    }

    protected void traverseCell(Node node) throws IOException {
        Node node2;
        Object object;
        Object object2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = 0;
        Node node3 = null;
        this.fmt.clearFormatting();
        if (namedNodeMap == null || namedNodeMap.item(0) == null) {
            Debug.log(1, "No Cell Attributes\n");
        } else {
            while ((node3 = namedNodeMap.item(n++)) != null) {
                Debug.log(1, "Cell Attribute " + n + ": " + node3.getNodeName() + " : " + node3.getNodeValue() + "\n");
            }
        }
        Node node4 = namedNodeMap.getNamedItem("table:value-type");
        Node node5 = namedNodeMap.getNamedItem("table:number-columns-repeated");
        Node node6 = namedNodeMap.getNamedItem("table:style-name");
        String string = new String("");
        if (node6 != null) {
            string = node6.getNodeValue();
        }
        if (string.equalsIgnoreCase("Default")) {
            Debug.log(4, "No defined Style Attribute was found");
        } else if (string.length() != 0) {
            object2 = (CellStyle)this.styleCat.lookup(string, "table-cell", null, CellStyle.class);
            object = ((CellStyle)object2).getFormat();
            this.fmt = new Format((Format)object);
        }
        if (node5 != null) {
            object2 = node5.getNodeValue();
            object = new Integer((String)object2);
            this.colsRepeated = (Integer)object;
        } else {
            this.colsRepeated = 1;
        }
        if (this.fmt.isDefault() && string.length() == 0) {
            int n2 = 1;
            object = this.ColumnRowList.elements();
            while (object.hasMoreElements()) {
                ColumnRowInfo columnRowInfo = (ColumnRowInfo)object.nextElement();
                if (!columnRowInfo.isColumn()) continue;
                if (this.colID >= n2 && this.colID < n2 + columnRowInfo.getRepeated()) {
                    this.fmt = new Format(columnRowInfo.getFormat());
                }
                n2 += columnRowInfo.getRepeated();
            }
        }
        if (node4 != null) {
            this.displayWidth = 0;
            String string2 = node4.getNodeValue();
            if (string2.equalsIgnoreCase("string")) {
                this.fmt.setCategory("string");
                object = namedNodeMap.getNamedItem("table:string-value");
                Debug.log(4, "Cell Type String :  " + object);
                if (object != null) {
                    this.fmt.setValue(object.getNodeValue());
                }
            } else if (string2.equalsIgnoreCase("float")) {
                this.fmt.setCategory("float");
                this.fmt.setDecimalPlaces(this.getDecimalPlaces(node));
                object = namedNodeMap.getNamedItem("table:value");
                this.fmt.setValue(object.getNodeValue());
            } else if (string2.equalsIgnoreCase("time")) {
                this.fmt.setCategory("time");
                object = namedNodeMap.getNamedItem("table:time-value");
                this.fmt.setValue(object.getNodeValue());
            } else if (string2.equalsIgnoreCase("date")) {
                this.fmt.setCategory("date");
                object = namedNodeMap.getNamedItem("table:date-value");
                this.fmt.setValue(object.getNodeValue());
            } else if (string2.equalsIgnoreCase("currency")) {
                this.fmt.setCategory("currency");
                this.fmt.setDecimalPlaces(this.getDecimalPlaces(node));
                object = namedNodeMap.getNamedItem("table:value");
                this.fmt.setValue(object.getNodeValue());
            } else if (string2.equalsIgnoreCase("boolean")) {
                this.fmt.setCategory("boolean");
                object = namedNodeMap.getNamedItem("table:boolean-value");
                this.fmt.setValue(object.getNodeValue());
            } else if (string2.equalsIgnoreCase("percentage")) {
                this.fmt.setCategory("percentage");
                this.fmt.setDecimalPlaces(this.getDecimalPlaces(node));
                object = namedNodeMap.getNamedItem("table:value");
                this.fmt.setValue(object.getNodeValue());
            } else {
                Debug.log(4, "No defined value type" + string2);
            }
        }
        if ((node2 = namedNodeMap.getNamedItem("table:formula")) != null) {
            if (node4 == null) {
                this.fmt.setCategory("string");
                object = namedNodeMap.getNamedItem("table:string-value");
                this.fmt.setValue(object.getNodeValue());
            }
            object = node2.getNodeValue();
            this.addCell((String)object);
        } else {
            Debug.log(1, "TextNode, DateNode, TimeNode or BooleanNode\n");
            if (node.hasChildNodes()) {
                object = node.getChildNodes();
                int n3 = object.getLength();
                for (int i = 0; i < n3; ++i) {
                    String string3;
                    Node node7 = object.item(i);
                    if (node7.getNodeType() != 1 || !(string3 = node7.getNodeName()).equals("text:p")) continue;
                    this.traverseParagraph(node7);
                }
            } else if (!this.fmt.isDefault()) {
                this.addCell("");
            }
        }
        this.format = 0L;
        this.colID += this.colsRepeated;
        this.colsRepeated = 1;
    }

    protected void traverseParagraph(Node node) throws IOException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = 0;
        Node node2 = null;
        if (namedNodeMap == null || namedNodeMap.item(0) == null) {
            Debug.log(1, "No Paragraph Attributes\n");
        } else {
            while ((node2 = namedNodeMap.item(n++)) != null) {
                Debug.log(1, "Paragraph Attribute " + n + ": " + node2.getNodeName() + " : " + node2.getNodeValue() + "\n");
            }
        }
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n2 = nodeList.getLength();
            StringBuffer stringBuffer = new StringBuffer();
            block5: for (int i = 0; i < n2; ++i) {
                Node node3 = nodeList.item(i);
                short s = node3.getNodeType();
                switch (s) {
                    case 3: {
                        stringBuffer.append(node3.getNodeValue());
                        continue block5;
                    }
                    case 5: {
                        NodeList nodeList2 = node3.getChildNodes();
                        int n3 = nodeList2.getLength();
                        for (int j = 0; j < n3; ++j) {
                            Node node4 = nodeList2.item(j);
                            if (node4.getNodeType() != 3) continue;
                            stringBuffer.append(node4.getNodeValue());
                        }
                        continue block5;
                    }
                }
            }
            String string = stringBuffer.toString();
            this.addCell(string);
        }
    }

    protected void addCell(String string) throws IOException {
        int n = this.colID;
        int n2 = this.rowID;
        for (int i = 0; i < this.rowsRepeated; ++i) {
            if (i > 0) {
                Debug.log(4, "</TR>");
                Debug.log(4, "<TR>");
            }
            n = this.colID;
            for (int j = 0; j < this.colsRepeated; ++j) {
                Debug.log(4, "<TD>");
                this.encoder.addCell(n2, n, this.fmt, string);
                Debug.log(4, string);
                Debug.log(4, "</TD>");
                ++n;
            }
            ++n2;
        }
    }

    protected int getDecimalPlaces(Node node) {
        int n = 0;
        Element element = null;
        if (!(node instanceof Element)) {
            return n;
        }
        element = (Element)node;
        NodeList nodeList = element.getElementsByTagName("text:p");
        if (nodeList.getLength() != 1) {
            return n;
        }
        Node node2 = nodeList.item(0);
        if (node2.hasChildNodes()) {
            NodeList nodeList2 = node2.getChildNodes();
            int n2 = nodeList2.getLength();
            for (int i = 0; i < n2; ++i) {
                String string;
                int n3;
                Node node3 = nodeList2.item(i);
                if (node3.getNodeType() != 3 || (n3 = (string = node3.getNodeValue()).lastIndexOf(".")) <= 0) continue;
                string = string.substring(n3 + 1);
                n = string.length();
            }
        }
        return n;
    }

    private String getAttribute(Node node, String string) {
        Node node2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem(string)) != null) {
            return node2.getNodeValue();
        }
        return null;
    }
}

