/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.content;

import java.io.IOException;
import java.util.LinkedList;
import org.openoffice.xmerge.converter.xml.EmbeddedObject;
import org.openoffice.xmerge.converter.xml.EmbeddedXMLObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import writer2latex.latex.Context;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.util.CSVList;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class DrawConverter
extends ConverterHelper {
    private boolean bNeedGraphicx = false;
    private LinkedList floatingFrames = new LinkedList();

    public DrawConverter(Config config, ConverterPalette converterPalette) {
        super(config, converterPalette);
    }

    public void appendDeclarations(LaTeXDocumentPortion laTeXDocumentPortion, LaTeXDocumentPortion laTeXDocumentPortion2) {
        if (this.bNeedGraphicx) {
            laTeXDocumentPortion.append("\\usepackage");
            if (this.config.getBackend() == 2) {
                laTeXDocumentPortion.append("[pdftex]");
            } else if (this.config.getBackend() == 1) {
                laTeXDocumentPortion.append("[dvips]");
            }
            laTeXDocumentPortion.append("{graphicx}").nl();
        }
    }

    public void handleDrawElement(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        String string = element.getTagName();
        if (string.equals("draw:object")) {
            this.handleDrawObject(element, laTeXDocumentPortion, context);
        } else if (!context.isInHeaderFooter() && string.equals("draw:image")) {
            this.handleDrawImage(element, laTeXDocumentPortion, context);
        } else if (!context.isInHeaderFooter() && string.equals("draw:text-box")) {
            this.handleDrawTextBox(element, laTeXDocumentPortion, context);
        } else if (string.equals("draw:a")) {
            this.palette.getFieldCv().handleAnchor(element, laTeXDocumentPortion, context);
        } else {
            laTeXDocumentPortion.append("[Warning: Draw object ignored]");
        }
    }

    private void handleDrawObject(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        String string = element.getAttribute("xlink:href");
        if (string != null && string.length() > 0) {
            EmbeddedObject embeddedObject = this.palette.getEmbeddedObject(string);
            if (embeddedObject != null && "application/vnd.sun.xml.math".equals(embeddedObject.getType())) {
                try {
                    Document document = ((EmbeddedXMLObject)embeddedObject).getSettingsDOM();
                    Document document2 = ((EmbeddedXMLObject)embeddedObject).getContentDOM();
                    Element element2 = Misc.getChildByTagName(document2, "math:math");
                    laTeXDocumentPortion.append(" $").append(this.palette.getMathmlCv().convert(document, element2)).append("$ ");
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        } else {
            Element element3 = Misc.getChildByTagName(element, "math:math");
            if (element3 != null) {
                laTeXDocumentPortion.append(" $").append(this.palette.getMathmlCv().convert(null, element3)).append("$ ");
            }
        }
    }

    private void handleDrawImage(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        String string = element.getAttribute("text:name");
        this.palette.getFieldCv().addTarget(element, "|graphics", laTeXDocumentPortion);
        String string2 = element.getAttribute("text:anchor-type");
        if (context.isInFrame() || "as-char".equals(string2)) {
            this.handleDrawImageAsChar(element, laTeXDocumentPortion, context);
        } else {
            this.floatingFrames.add(element);
        }
    }

    private void handleDrawImageAsChar(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        laTeXDocumentPortion.append(" ");
        this.includeGraphics(element, laTeXDocumentPortion, context);
        laTeXDocumentPortion.append(" ");
    }

    private void handleDrawImageFloat(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        laTeXDocumentPortion.append("\\begin{center}").nl();
        this.includeGraphics(element, laTeXDocumentPortion, context);
        laTeXDocumentPortion.nl().append("\\end{center}").nl();
    }

    /*
     * Unable to fully structure code
     */
    private void includeGraphics(Element var1_1, LaTeXDocumentPortion var2_2, Context var3_3) {
        block14: {
            block13: {
                var4_4 = null;
                var5_5 = true;
                var6_6 = var1_1.getAttribute("xlink:href");
                if (var6_6 == null || var6_6.length() <= 0) break block13;
                if (var6_6.startsWith("#")) {
                    var6_6 = var6_6.substring(1);
                }
                var4_4 = var6_6;
                var7_7 = var6_6.lastIndexOf(".");
                v0 = var8_10 = var7_7 >= 0 ? var6_6.substring(var7_7).toLowerCase() : "";
                if (var4_4.indexOf(":") > -1) ** GOTO lbl-1000
                if (this.config.getBackend() != 2 || !".jpg".equals(var8_10)) {
                    if (this.config.getBackend() != 2 || !".png".equals(var8_10)) {
                        ** if (this.config.getBackend() == 1 && ".eps".equals((Object)var8_10)) goto lbl-1000
                    }
                }
                ** GOTO lbl-1000
lbl-1000:
                // 2 sources

                {
                    v1 = true;
                    ** GOTO lbl21
                }
lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
lbl21:
                // 2 sources

                var5_5 = v1;
                break block14;
            }
            var7_8 = this.palette.getImageLoader().getImage(var1_1);
            if (var7_8 == null) break block14;
            this.palette.addDocument(var7_8);
            var4_4 = var7_8.getFileName();
            var8_10 = var7_8.getDocumentMIMEType();
            if (this.config.getBackend() == 2 && "image/jpeg".equals(var8_10)) ** GOTO lbl-1000
            if (this.config.getBackend() == 2 && "image/png".equals(var8_10)) ** GOTO lbl-1000
            if (this.config.getBackend() != 1 || !"image/x-eps".equals(var8_10)) {
                v2 = true;
            } else lbl-1000:
            // 3 sources

            {
                v2 = var5_5 = false;
            }
        }
        if (var4_4 == null) {
            var2_2.append("[Warning: Image not found]");
            return;
        }
        this.bNeedGraphicx = true;
        var7_9 = Misc.truncateLength(var1_1.getAttribute("svg:width"));
        var8_10 = Misc.truncateLength(var1_1.getAttribute("svg:height"));
        if (var5_5) {
            var2_2.append(" [Warning: Image ignored] ");
            var2_2.append("% Unhandled or unsupported graphics:").nl().append("%");
        }
        var2_2.append("\\includegraphics");
        var9_11 = new CSVList(',');
        if (var7_9 != null) {
            var9_11.addValue("width=" + var7_9);
        }
        if (var8_10 != null) {
            var9_11.addValue("height=" + var8_10);
        }
        if (!var9_11.isEmpty()) {
            var2_2.append("[").append(var9_11.toString()).append("]");
        }
        var2_2.append("{").append(var4_4).append("}");
        if (var5_5) {
            var2_2.nl();
        }
    }

    private void handleDrawTextBox(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        String string = element.getAttribute("text:name");
        this.palette.getFieldCv().addTarget(element, "|frame", laTeXDocumentPortion);
        String string2 = element.getAttribute("text:anchor-type");
        if (context.isInFrame() || "as-char".equals(string2)) {
            this.makeDrawTextBox(element, laTeXDocumentPortion, context);
        } else {
            this.floatingFrames.add(element);
        }
    }

    private void handleDrawTextBoxFloat(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        laTeXDocumentPortion.append("\\begin{center}").nl();
        this.makeDrawTextBox(element, laTeXDocumentPortion, context);
        laTeXDocumentPortion.append("\\end{center}").nl();
    }

    private void makeDrawTextBox(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        Context context2 = (Context)context.clone();
        context2.setInFrame(true);
        context2.setNoFootnotes(true);
        String string = Misc.truncateLength(element.getAttribute("svg:width"));
        laTeXDocumentPortion.append("\\begin{minipage}{").append(string).append("}").nl();
        this.palette.getBlockCv().traverseBlockText(element, laTeXDocumentPortion, context2);
        laTeXDocumentPortion.append("\\end{minipage}");
        if (!context.isNoFootnotes()) {
            this.palette.getNoteCv().flushFootnotes(laTeXDocumentPortion, context);
        }
    }

    public void flushFloatingFrames(LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        if (context.isInFrame()) {
            return;
        }
        int n = this.floatingFrames.size();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Element element = (Element)this.floatingFrames.get(i);
            String string = element.getNodeName();
            if (string.equals("draw:image")) {
                this.handleDrawImageFloat(element, laTeXDocumentPortion, context);
                continue;
            }
            if (!string.equals("draw:text-box")) continue;
            this.handleDrawTextBoxFloat(element, laTeXDocumentPortion, context);
        }
        this.floatingFrames.clear();
    }
}

