/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import org.netbeans.beaninfo.editors.StringEditor;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.Util;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;

public class HelpStringCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    private JLabel listLabel;
    private JList list;
    private JScrollPane scrollPane;
    private JComboBox combo;
    private JLabel comboLabel;

    public HelpStringCustomEditor(String value, List items, List helpItems, String comboText, char comboMnemonic, String helpID) {
        this.initComponents();
        this.combo.setModel(new DefaultComboBoxModel<Object>(items.toArray()));
        this.combo.setSelectedItem(value);
        this.list.setListData(helpItems.toArray());
        this.list.setBackground(new Color(SystemColor.window.getRGB()));
        this.comboLabel.setText(comboText);
        this.comboLabel.setDisplayedMnemonic(comboMnemonic);
        this.listLabel.setText(I18nUtil.getBundle().getString("LBL_Arguments"));
        this.listLabel.setDisplayedMnemonic(I18nUtil.getBundle().getString("LBL_Arguments_Mnem").charAt(0));
        this.initAccessibility();
        HelpCtx.setHelpIDString((JComponent)this, (String)helpID);
    }

    public Object getPropertyValue() throws IllegalStateException {
        return (String)this.combo.getSelectedItem();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_HelpStringCustomEditor"));
        this.combo.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_HelpStringCombo"));
        this.list.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_HelpStringList"));
    }

    private void initComponents() {
        this.combo = new JComboBox();
        this.scrollPane = new JScrollPane();
        this.list = new JList();
        this.comboLabel = new JLabel();
        this.listLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.combo.setEditable(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 11);
        this.add((Component)this.combo, gridBagConstraints);
        this.list.setSelectionMode(0);
        this.list.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                HelpStringCustomEditor.this.listKeyPressed(evt);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                HelpStringCustomEditor.this.listMouseClicked(evt);
            }
        });
        this.scrollPane.setViewportView(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 11, 11);
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.comboLabel.setLabelFor(this.combo);
        this.comboLabel.setText("comboLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.comboLabel, gridBagConstraints);
        this.listLabel.setLabelFor(this.list);
        this.listLabel.setText("listLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.add((Component)this.listLabel, gridBagConstraints);
    }

    private void listKeyPressed(KeyEvent evt) {
        String selected = (String)this.list.getSelectedValue();
        if (evt.getKeyCode() == 10 && selected != null) {
            evt.consume();
            this.insertInFormat(selected);
        }
    }

    private void listMouseClicked(MouseEvent evt) {
        String selected = (String)this.list.getSelectedValue();
        if (evt.getClickCount() == 2 && selected != null) {
            this.insertInFormat(selected);
        }
    }

    private void insertInFormat(String selected) {
        int index = selected.indexOf(32);
        if (index < 0 || index > selected.length()) {
            return;
        }
        String replace = selected.substring(0, index);
        JTextField textField = (JTextField)this.combo.getEditor().getEditorComponent();
        try {
            textField.getDocument().insertString(textField.getCaretPosition(), replace, null);
        }
        catch (BadLocationException ble) {
            ErrorManager.getDefault().notify(1, (Throwable)ble);
        }
    }

    public static class I18nRegExpEditor
    extends StringEditor {
        public Component getCustomEditor() {
            return new HelpStringCustomEditor((String)this.getValue(), I18nUtil.getI18nRegExpItems(), I18nUtil.getRegExpHelpItems(), I18nUtil.getBundle().getString("LBL_I18nRegExpFormat"), Util.getChar("LBL_I18nRegExpFormat_mne"), "i18n.pe.testregexp");
        }
    }

    public static class RegExpEditor
    extends StringEditor {
        public Component getCustomEditor() {
            return new HelpStringCustomEditor((String)this.getValue(), I18nUtil.getRegExpItems(), I18nUtil.getRegExpHelpItems(), I18nUtil.getBundle().getString("LBL_NonI18nRegExpFormat"), Util.getChar("LBL_NonI18nRegExpFormat_mne"), "i18n.pe.i18nregexp");
        }
    }

    public static class ReplaceCodeEditor
    extends StringEditor {
        public Component getCustomEditor() {
            return new HelpStringCustomEditor((String)this.getValue(), I18nUtil.getReplaceFormatItems(), I18nUtil.getReplaceHelpItems(), I18nUtil.getBundle().getString("LBL_ReplaceCodeFormat"), Util.getChar("LBL_ReplaceCodeFormat_mne"), "i18n.pe.replacestring");
        }
    }

    public static class InitCodeEditor
    extends StringEditor {
        public Component getCustomEditor() {
            return new HelpStringCustomEditor((String)this.getValue(), I18nUtil.getInitFormatItems(), I18nUtil.getInitHelpItems(), I18nUtil.getBundle().getString("LBL_InitCodeFormat"), Util.getChar("LBL_InitCodeFormat_mne"), "i18n.pe.bundlestring");
        }
    }
}

