/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import java.util.List;
import java.util.Vector;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.parsing.EqualsAssignmentNode;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.MajorNode;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.queryframework.UpdateAllQuery;

public class SetNode
extends MajorNode {
    private List assignmentNodes = new Vector();

    public void addUpdatesToQuery(UpdateAllQuery theQuery, GenerationContext context) {
        for (EqualsAssignmentNode node : this.assignmentNodes) {
            Expression leftExpression = this.getExpressionForNode(node.getLeft(), theQuery.getReferenceClass(), context);
            Expression rightExpression = this.getExpressionForNode(node.getRight(), theQuery.getReferenceClass(), context);
            theQuery.addUpdate(leftExpression, rightExpression);
        }
    }

    public void validate(ParseTreeContext context) {
        for (Node item : this.assignmentNodes) {
            item.validate(context);
        }
    }

    protected Expression getExpressionForNode(Node node, Class referenceClass, GenerationContext context) {
        Expression expression = null;
        if (node.isAttributeNode()) {
            String classVariable = context.getParseTreeContext().getVariableNameForClass(referenceClass, context);
            expression = context.expressionFor(classVariable);
            if (expression == null) {
                expression = new ExpressionBuilder();
                context.addExpression(expression, classVariable);
            }
            expression = node.addToExpression(expression, context);
        } else {
            expression = node.generateExpression(context);
        }
        return expression;
    }

    public void setAssignmentNodes(List nodes) {
        this.assignmentNodes = nodes;
    }
}

