/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.internal.parsing.DotNode;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.SelectGenerationContext;
import oracle.toplink.essentials.internal.parsing.TypeHelper;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReportQuery;

public class ConstructorNode
extends Node {
    private String className = null;
    public List constructorItems = new ArrayList();

    public ConstructorNode(String className) {
        this.className = className;
    }

    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery instanceof ReportQuery) {
            SelectGenerationContext selectContext = (SelectGenerationContext)context;
            ReportQuery reportQuery = (ReportQuery)theQuery;
            reportQuery.beginAddingConstructorArguments(this.getConstructorClass());
            for (Node node : this.constructorItems) {
                if (this.selectingRelationshipField(node, context)) {
                    selectContext.useOuterJoins();
                }
                node.applyToQuery(reportQuery, context);
                selectContext.dontUseOuterJoins();
            }
            reportQuery.endAddingToConstructorItem();
        }
    }

    public void validate(ParseTreeContext context) {
        String name;
        int index;
        for (Node item : this.constructorItems) {
            item.validate(context);
        }
        TypeHelper typeHelper = context.getTypeHelper();
        Object type = typeHelper.resolveTypeName(this.className);
        if (type == null && (index = (name = this.className).lastIndexOf(46)) != -1) {
            name = name.substring(0, index) + '$' + name.substring(index + 1);
            type = typeHelper.resolveTypeName(name);
        }
        this.setType(type);
    }

    public boolean isConstructorNode() {
        return true;
    }

    public void addConstructorItem(Object theNode) {
        this.constructorItems.add(theNode);
    }

    public void setConstructorItems(List items) {
        this.constructorItems = items;
    }

    public List getConstructorItems() {
        return this.constructorItems;
    }

    private Class getConstructorClass() {
        Object type = this.getType();
        if (type == null) {
            throw EJBQLException.constructorClassNotFound(this.className);
        }
        return (Class)type;
    }

    private boolean selectingRelationshipField(Node node, GenerationContext context) {
        if (node == null || !node.isDotNode()) {
            return false;
        }
        return !((DotNode)node).endsWithDirectToField(context);
    }

    public String getAsString() {
        StringBuffer repr = new StringBuffer();
        repr.append("NEW ").append(this.className);
        repr.append("(");
        Iterator i = this.constructorItems.iterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            repr.append(node.getAsString());
            if (!i.hasNext()) continue;
            repr.append(", ");
        }
        repr.append(")");
        return repr.toString();
    }
}

