/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel.transientimpl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.MultivaluedOrderedIndex;
import org.netbeans.mdr.persistence.ObjectResolver;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.TransientStorableObject;
import org.netbeans.mdr.storagemodel.transientimpl.CompensatingTransaction;
import org.netbeans.mdr.storagemodel.transientimpl.TransactionalIndex;
import org.netbeans.mdr.storagemodel.transientimpl.TransientMultivaluedIndex;
import org.netbeans.mdr.storagemodel.transientimpl.TransientMultivaluedOrderedIndex;
import org.netbeans.mdr.storagemodel.transientimpl.TransientObjectResolverIndex;
import org.netbeans.mdr.storagemodel.transientimpl.TransientSinglevaluedIndex;

public class TransientStorage
implements Storage {
    public static final String STORAGE_ID = "GC";
    private MdrStorage mdrStorage;
    private long sequenceNumber;
    private String name;
    private Stack indexTxLog;
    private Stack attrTxLog;
    private HashMap indexes;

    public TransientStorage(String name) {
        this.name = name;
        this.sequenceNumber = 1L;
        this.indexes = new HashMap();
        this.indexTxLog = new Stack();
        this.attrTxLog = new Stack();
    }

    public String getName() {
        return this.name;
    }

    public String getStorageId() {
        return STORAGE_ID;
    }

    public synchronized long getSerialNumber() {
        return this.sequenceNumber++;
    }

    public MOFID readMOFID(InputStream inputStream) throws StorageException {
        throw new UnsupportedOperationException();
    }

    public void writeMOFID(OutputStream outputStream, MOFID modId) throws StorageException {
        throw new UnsupportedOperationException();
    }

    public MOFID resolveMOFID(String sMofId) {
        if (sMofId == null) {
            return null;
        }
        if (!sMofId.startsWith(STORAGE_ID)) {
            return null;
        }
        try {
            long serialNumber = Long.parseLong(sMofId.substring(STORAGE_ID.length() + 1), 16);
            return new MOFID(serialNumber, STORAGE_ID);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public synchronized SinglevaluedIndex getPrimaryIndex() throws StorageException {
        SinglevaluedIndex primaryIndex = (SinglevaluedIndex)this.indexes.get("TRANSIENT_OBJECTS_RESOLVER");
        if (primaryIndex == null) {
            primaryIndex = new TransientObjectResolverIndex();
            this.indexes.put("TRANSIENT_OBJECTS_RESOLVER", primaryIndex);
            this.indexTxLog.push(new CompensatingTransaction.CreateIndexCTx(this.name, primaryIndex));
        }
        return primaryIndex;
    }

    public boolean exists() throws StorageException {
        return true;
    }

    public synchronized boolean delete() throws StorageException {
        Iterator it = this.indexes.keySet().iterator();
        while (it.hasNext()) {
            this.dropIndex((String)it.next());
        }
        return true;
    }

    public void create(boolean replace, ObjectResolver resolver) throws StorageException {
        this.mdrStorage = (MdrStorage)resolver;
    }

    public void open(boolean createOnNoExist, ObjectResolver resolver) throws StorageException {
        throw new UnsupportedOperationException();
    }

    public void close() throws StorageException {
        this.commitChanges();
        this.delete();
    }

    public synchronized SinglevaluedIndex createSinglevaluedIndex(String name, Storage.EntryType keyType, Storage.EntryType valueType) throws StorageException {
        if (this.indexes.get(name) != null) {
            throw new StorageBadRequestException("Index already exists.");
        }
        TransientSinglevaluedIndex tsi = new TransientSinglevaluedIndex(this.mdrStorage, name, keyType, valueType);
        this.indexes.put(name, tsi);
        this.indexTxLog.push(new CompensatingTransaction.CreateIndexCTx(name, tsi));
        return tsi;
    }

    public synchronized MultivaluedOrderedIndex createMultivaluedOrderedIndex(String name, Storage.EntryType keyType, Storage.EntryType valueType, boolean unique) throws StorageException {
        if (this.indexes.get(name) != null) {
            throw new StorageBadRequestException("Index already exists.");
        }
        TransientMultivaluedOrderedIndex tmoi = new TransientMultivaluedOrderedIndex(this.mdrStorage, name, keyType, valueType, unique);
        this.indexes.put(name, tmoi);
        this.indexTxLog.push(new CompensatingTransaction.CreateIndexCTx(name, tmoi));
        return tmoi;
    }

    public synchronized MultivaluedIndex createMultivaluedIndex(String name, Storage.EntryType keyType, Storage.EntryType valueType, boolean unique) throws StorageException {
        if (this.indexes.get(name) != null) {
            throw new StorageBadRequestException("Index already exists.");
        }
        TransientMultivaluedIndex tmi = new TransientMultivaluedIndex(this.mdrStorage, name, keyType, valueType, unique);
        this.indexes.put(name, tmi);
        this.indexTxLog.push(new CompensatingTransaction.CreateIndexCTx(name, tmi));
        return tmi;
    }

    public synchronized Index getIndex(String name) throws StorageException {
        return (Index)this.indexes.get(name);
    }

    public synchronized SinglevaluedIndex getSinglevaluedIndex(String name) throws StorageException {
        return (SinglevaluedIndex)this.getIndex(name);
    }

    public synchronized MultivaluedIndex getMultivaluedIndex(String name) throws StorageException {
        return (MultivaluedIndex)this.getIndex(name);
    }

    public synchronized MultivaluedOrderedIndex getMultivaluedOrderedIndex(String name) throws StorageException {
        return (MultivaluedOrderedIndex)this.getIndex(name);
    }

    public synchronized void dropIndex(String name) throws StorageException {
        Object index = this.indexes.remove(name);
        this.indexTxLog.push(new CompensatingTransaction.DropIndexCTx(name, index));
    }

    public void objectStateWillChange(Object key) throws StorageException {
    }

    public void objectStateChanged(Object key) throws StorageException {
        this.attrTxLog.push(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitChanges() throws StorageException {
        this.indexTxLog.clear();
        Iterator it = null;
        TransientStorage transientStorage = this;
        synchronized (transientStorage) {
            it = ((HashMap)this.indexes.clone()).values().iterator();
        }
        while (it.hasNext()) {
            ((TransactionalIndex)it.next()).commit();
        }
        while (!this.attrTxLog.empty()) {
            MOFID id = (MOFID)this.attrTxLog.pop();
            SinglevaluedIndex pi = this.getPrimaryIndex();
            TransientStorableObject tso = (TransientStorableObject)pi.getIfExists(id);
            if (tso == null) continue;
            tso.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollBackChanges() throws StorageException {
        while (!this.indexTxLog.empty()) {
            CompensatingTransaction ctx = (CompensatingTransaction)this.indexTxLog.pop();
            ctx.perform(this.indexes);
        }
        Iterator it = null;
        TransientStorage transientStorage = this;
        synchronized (transientStorage) {
            it = ((HashMap)this.indexes.clone()).values().iterator();
        }
        while (it.hasNext()) {
            ((TransactionalIndex)it.next()).rollBack();
        }
        while (!this.attrTxLog.empty()) {
            MOFID id = (MOFID)this.attrTxLog.pop();
            SinglevaluedIndex pi = this.getPrimaryIndex();
            TransientStorableObject tso = (TransientStorableObject)pi.getIfExists(id);
            if (tso == null) continue;
            tso.rollBack();
        }
    }

    public void shutDown() throws StorageException {
    }
}

