/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.generator;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.ws.processor.config.Configuration;
import com.sun.tools.ws.processor.generator.GeneratorBase;
import com.sun.tools.ws.processor.generator.GeneratorException;
import com.sun.tools.ws.processor.model.Fault;
import com.sun.tools.ws.processor.model.Model;
import com.sun.xml.ws.encoding.soap.SOAPVersion;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.ws.WebFault;

public class CustomExceptionGenerator
extends GeneratorBase {
    private Map<String, JClass> faults = new HashMap<String, JClass>();

    public CustomExceptionGenerator() {
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties) {
        return new CustomExceptionGenerator(model, config, properties);
    }

    public GeneratorBase getGenerator(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        return new CustomExceptionGenerator(model, config, properties);
    }

    protected CustomExceptionGenerator(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
    }

    protected void preVisitModel(Model model) throws Exception {
    }

    protected void postVisitModel(Model model) throws Exception {
        this.faults = null;
    }

    protected void preVisitFault(Fault fault) throws Exception {
        if (this.isRegistered(fault)) {
            return;
        }
        this.registerFault(fault);
    }

    private boolean isRegistered(Fault fault) {
        if (this.faults.keySet().contains(fault.getJavaException().getName())) {
            fault.setExceptionClass(this.faults.get(fault.getJavaException().getName()));
            return true;
        }
        return false;
    }

    private void registerFault(Fault fault) {
        try {
            this.write(fault);
            this.faults.put(fault.getJavaException().getName(), fault.getExceptionClass());
        }
        catch (Exception e) {
            throw new GeneratorException("generator.nestedGeneratorError", e);
        }
    }

    private void write(Fault fault) throws Exception {
        String className = this.env.getNames().customExceptionClassName(fault);
        JDefinedClass cls = this.cm._class(className, ClassType.CLASS);
        JDocComment comment = cls.javadoc();
        if (fault.getJavaDoc() != null) {
            comment.add(fault.getJavaDoc());
            comment.add("\n\n");
        }
        for (String doc : this.getJAXWSClassComment()) {
            comment.add(doc);
        }
        cls._extends(Exception.class);
        JAnnotationUse faultAnn = cls.annotate(WebFault.class);
        faultAnn.param("name", fault.getBlock().getName().getLocalPart());
        faultAnn.param("targetNamespace", fault.getBlock().getName().getNamespaceURI());
        JType faultBean = fault.getBlock().getType().getJavaType().getType().getType();
        JFieldVar fi = cls.field(4, faultBean, "faultInfo");
        fault.getBlock().getType().getJavaType().getType().annotate(fi);
        fi.javadoc().add("Java type that goes as soapenv:Fault detail element.");
        JFieldRef fr = JExpr.ref(JExpr._this(), fi);
        JMethod constrc1 = cls.constructor(1);
        JVar var1 = constrc1.param(String.class, "message");
        JVar var2 = constrc1.param(faultBean, "faultInfo");
        constrc1.javadoc().addParam(var1);
        constrc1.javadoc().addParam(var2);
        JBlock cb1 = constrc1.body();
        cb1.invoke("super").arg(var1);
        cb1.assign(fr, var2);
        JMethod constrc2 = cls.constructor(1);
        var1 = constrc2.param(String.class, "message");
        var2 = constrc2.param(faultBean, "faultInfo");
        JVar var3 = constrc2.param(Throwable.class, "cause");
        constrc2.javadoc().addParam(var1);
        constrc2.javadoc().addParam(var2);
        constrc2.javadoc().addParam(var3);
        JBlock cb2 = constrc2.body();
        cb2.invoke("super").arg(var1).arg(var3);
        cb2.assign(fr, var2);
        JMethod fim = cls.method(1, faultBean, "getFaultInfo");
        fim.javadoc().addReturn().add("returns fault bean: " + faultBean.fullName());
        JBlock fib = fim.body();
        fib._return(fi);
        fault.setExceptionClass(cls);
    }
}

