/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.wizard.entity.WrapperPanel;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelDS;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelJdbc;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class Util {
    private static final String WIZARD_PANEL_CONTENT_DATA = "WizardPanel_contentData";
    private static final String WIZARD_PANEL_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";

    public static void changeLabelInComponent(JComponent component, String oldLabel, String newLabel) {
        JLabel label = Util.findLabel(component, oldLabel);
        if (label != null) {
            label.setText(newLabel);
        }
    }

    public static void hideLabelAndLabelFor(JComponent component, String lab) {
        JLabel label = Util.findLabel(component, lab);
        if (label != null) {
            label.setVisible(false);
            Component c = label.getLabelFor();
            if (c != null) {
                c.setVisible(false);
            }
        }
    }

    public static void getAllComponents(Component[] components, Collection allComponents) {
        for (int i = 0; i < components.length; ++i) {
            if (components[i] == null) continue;
            allComponents.add(components[i]);
            if (((Container)components[i]).getComponentCount() == 0) continue;
            Util.getAllComponents(((Container)components[i]).getComponents(), allComponents);
        }
    }

    public static JLabel findLabel(JComponent comp, String labelText) {
        Vector allComponents = new Vector();
        Util.getAllComponents(comp.getComponents(), allComponents);
        for (Component c : allComponents) {
            JLabel label;
            if (!(c instanceof JLabel) || !(label = (JLabel)c).getText().equals(labelText)) continue;
            return label;
        }
        return null;
    }

    public static String getClassName(String fqClassName) {
        int dot = fqClassName.lastIndexOf(".");
        if (dot >= 0 && dot < fqClassName.length() - 1) {
            return fqClassName.substring(dot + 1);
        }
        return fqClassName;
    }

    public static String getPackageName(String fqClassName) {
        int dot = fqClassName.lastIndexOf(".");
        if (dot >= 0 && dot < fqClassName.length() - 1) {
            return fqClassName.substring(0, dot);
        }
        return "";
    }

    public static SourceGroup getClassSourceGroup(Project project, String fqClassName) {
        SourceGroup[] sourceGroups;
        String classFile = fqClassName.replace('.', '/') + ".java";
        for (SourceGroup sourceGroup : sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            FileObject classFO = sourceGroup.getRootFolder().getFileObject(classFile);
            if (classFO == null) continue;
            return sourceGroup;
        }
        return null;
    }

    public static SourceGroup[] getJavaSourceGroups(Project project) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        Set testGroups = Util.getTestSourceGroups(project, sourceGroups);
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
        for (int i = 0; i < sourceGroups.length; ++i) {
            if (testGroups.contains(sourceGroups[i])) continue;
            result.add(sourceGroups[i]);
        }
        return result.toArray(new SourceGroup[result.size()]);
    }

    private static Set getTestSourceGroups(Project project, SourceGroup[] sourceGroups) {
        Map foldersToSourceGroupsMap = Util.createFoldersToSourceGroupsMap(sourceGroups);
        HashSet testGroups = new HashSet();
        for (int i = 0; i < sourceGroups.length; ++i) {
            testGroups.addAll(Util.getTestTargets(sourceGroups[i], foldersToSourceGroupsMap));
        }
        return testGroups;
    }

    private static Map createFoldersToSourceGroupsMap(SourceGroup[] sourceGroups) {
        HashMap<FileObject, SourceGroup> result;
        if (sourceGroups.length == 0) {
            result = Collections.EMPTY_MAP;
        } else {
            result = new HashMap<FileObject, SourceGroup>(2 * sourceGroups.length, 0.5f);
            for (int i = 0; i < sourceGroups.length; ++i) {
                SourceGroup sourceGroup = sourceGroups[i];
                result.put(sourceGroup.getRootFolder(), sourceGroup);
            }
        }
        return result;
    }

    private static List getFileObjects(URL[] urls) {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (int i = 0; i < urls.length; ++i) {
            FileObject sourceRoot = URLMapper.findFileObject((URL)urls[i]);
            if (sourceRoot != null) {
                result.add(sourceRoot);
                continue;
            }
            int severity = 1;
            if (!ErrorManager.getDefault().isNotifiable(severity)) continue;
            ErrorManager.getDefault().notify(severity, (Throwable)new IllegalStateException("No FileObject found for the following URL: " + urls[i]));
        }
        return result;
    }

    private static List getTestTargets(SourceGroup sourceGroup, Map foldersToSourceGroupsMap) {
        URL[] rootURLs = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder());
        if (rootURLs.length == 0) {
            return new ArrayList();
        }
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
        List sourceRoots = Util.getFileObjects(rootURLs);
        for (int i = 0; i < sourceRoots.size(); ++i) {
            FileObject sourceRoot = (FileObject)sourceRoots.get(i);
            SourceGroup srcGroup = (SourceGroup)foldersToSourceGroupsMap.get(sourceRoot);
            if (srcGroup == null) continue;
            result.add(srcGroup);
        }
        return result;
    }

    public static ClassPath getFullClasspath(FileObject fo) {
        int i;
        FileObject[] sourceRoots = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source").getRoots();
        FileObject[] bootRoots = ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot").getRoots();
        FileObject[] compileRoots = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile").getRoots();
        FileObject[] roots = new FileObject[sourceRoots.length + bootRoots.length + compileRoots.length];
        for (i = 0; i < sourceRoots.length; ++i) {
            roots[i] = sourceRoots[i];
        }
        for (i = 0; i < bootRoots.length; ++i) {
            roots[sourceRoots.length + i] = bootRoots[i];
        }
        for (i = 0; i < compileRoots.length; ++i) {
            roots[sourceRoots.length + bootRoots.length + i] = compileRoots[i];
        }
        return ClassPathSupport.createClassPath((FileObject[])roots);
    }

    public static void mergeSteps(WizardDescriptor wizard, WizardDescriptor.Panel[] panels, String[] steps) {
        int offset;
        String[] beforeSteps;
        Object prop = wizard.getProperty(WIZARD_PANEL_CONTENT_DATA);
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
            offset = beforeSteps.length;
            if (offset > 0 && "...".equals(beforeSteps[offset - 1])) {
                --offset;
            }
        } else {
            beforeSteps = null;
            offset = 0;
        }
        String[] resultSteps = new String[offset + panels.length];
        for (int i = 0; i < offset; ++i) {
            resultSteps[i] = beforeSteps[i];
        }
        Util.setSteps(panels, steps, resultSteps, offset);
    }

    private static void setSteps(WizardDescriptor.Panel[] panels, String[] steps, String[] resultSteps, int offset) {
        int n = steps == null ? 0 : steps.length;
        for (int i = 0; i < panels.length; ++i) {
            String step;
            JComponent component = (JComponent)panels[i].getComponent();
            String string = step = i < n ? steps[i] : null;
            if (step == null) {
                step = component.getName();
            }
            component.putClientProperty(WIZARD_PANEL_CONTENT_DATA, resultSteps);
            component.putClientProperty(WIZARD_PANEL_CONTENT_SELECTED_INDEX, new Integer(i));
            component.getAccessibleContext().setAccessibleDescription(step);
            resultSteps[i + offset] = step;
        }
    }

    public static void setSteps(WizardDescriptor.Panel[] panels, String[] steps) {
        Util.setSteps(panels, steps, steps, 0);
    }

    public static boolean isSupportedJavaEEVersion(Project project) {
        Object moduleType;
        String moduleVersion;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        String string = moduleVersion = j2eeModuleProvider != null ? j2eeModuleProvider.getJ2eeModule().getModuleVersion() : null;
        if (moduleVersion == null) {
            return false;
        }
        Object object = moduleType = j2eeModuleProvider != null ? j2eeModuleProvider.getJ2eeModule().getModuleType() : null;
        if (moduleType == null) {
            return false;
        }
        return moduleType.equals(J2eeModule.EJB) && moduleVersion.equals("3.0") || moduleType.equals(J2eeModule.WAR) && moduleVersion.equals("2.5");
    }

    public static boolean isEjbModule(Project project) {
        Object moduleType;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        Object object = moduleType = j2eeModuleProvider != null ? j2eeModuleProvider.getJ2eeModule().getModuleType() : null;
        if (moduleType == null) {
            return false;
        }
        return moduleType.equals(J2eeModule.EJB);
    }

    public static boolean isEjb21Module(Project project) {
        String moduleVersion;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        String string = moduleVersion = j2eeModuleProvider != null ? j2eeModuleProvider.getJ2eeModule().getModuleVersion() : null;
        if (moduleVersion == null) {
            return false;
        }
        return Util.isEjbModule(project) && moduleVersion.equals("2.1");
    }

    public static boolean isJavaSE(Project project) {
        String moduleVersion;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        String string = moduleVersion = j2eeModuleProvider != null ? j2eeModuleProvider.getJ2eeModule().getModuleVersion() : null;
        return moduleVersion == null;
    }

    public static PersistenceUnit buildPersistenceUnitUsingWizard(Project project, String preselectedDB, PersistenceUnitWizardPanel.TableGeneration tableGeneration) {
        Object result;
        boolean isContainer = Util.isSupportedJavaEEVersion(project);
        PersistenceUnitWizardPanel panel = isContainer ? new PersistenceUnitWizardPanelDS(project, null, true, tableGeneration) : new PersistenceUnitWizardPanelJdbc(project, null, true, tableGeneration);
        if (preselectedDB != null) {
            panel.setPreselectedDB(preselectedDB);
        }
        final JButton createPUButton = new JButton(NbBundle.getMessage(Util.class, (String)"LBL_CreatePersistenceUnitButton"));
        createPUButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Util.class, (String)"ACSD_CreatePersistenceUnitButton"));
        Object[] buttons = new Object[]{createPUButton, DialogDescriptor.CANCEL_OPTION};
        final DialogDescriptor nd = new DialogDescriptor((Object)new WrapperPanel(panel), NbBundle.getMessage(Util.class, (String)"LBL_CreatePersistenceUnit"), true, buttons, DialogDescriptor.OK_OPTION, 0, null, null);
        panel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Object newvalue;
                if (evt.getPropertyName().equals("PersistenceUnitWizardPanel_isValid") && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                    nd.setValid(((Boolean)newvalue).booleanValue());
                    createPUButton.setEnabled((Boolean)newvalue);
                }
            }
        });
        if (!panel.isValidPanel()) {
            nd.setValid(false);
            createPUButton.setEnabled(false);
        }
        if ((result = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd)) == createPUButton) {
            PersistenceUnit punit = new PersistenceUnit();
            if (isContainer) {
                PersistenceUnitWizardPanelDS puPanel = (PersistenceUnitWizardPanelDS)panel;
                if (puPanel.isJTA()) {
                    punit.setJtaDataSource(puPanel.getDatasource());
                } else {
                    if (puPanel.isNonDefaultProviderEnabled()) {
                        punit.setNonJtaDataSource(puPanel.getDatasource());
                    }
                    punit.setTransactionType("RESOURCE_LOCAL");
                }
                if (puPanel.isNonDefaultProviderEnabled()) {
                    punit.setProvider(puPanel.getNonDefaultProvider());
                }
            } else {
                PersistenceUnitWizardPanelJdbc puJdbc = (PersistenceUnitWizardPanelJdbc)panel;
                punit = ProviderUtil.buildPersistenceUnit(puJdbc.getPersistenceUnitName(), puJdbc.getSelectedProvider(), puJdbc.getPersistenceConnection());
                punit.setTransactionType("RESOURCE_LOCAL");
                if (puJdbc.getPersistenceLibrary() != null) {
                    Util.addLibraryToProject(project, puJdbc.getPersistenceLibrary());
                }
            }
            punit.setName(panel.getPersistenceUnitName());
            ProviderUtil.setTableGeneration(punit, panel.getTableGeneration(), project);
            return punit;
        }
        return null;
    }

    public static boolean createPersistenceUnitUsingWizard(Project project) {
        return Util.createPersistenceUnitUsingWizard(project, null, PersistenceUnitWizardPanel.TableGeneration.CREATE);
    }

    public static boolean createPersistenceUnitUsingWizard(Project project, String preselectedDB, PersistenceUnitWizardPanel.TableGeneration tableGeneration) {
        PersistenceUnit punit = Util.buildPersistenceUnitUsingWizard(project, preselectedDB, tableGeneration);
        if (punit == null) {
            return false;
        }
        PUDataObject pud = ProviderUtil.getPUDataObject(project);
        pud.addPersistenceUnit(punit);
        pud.save();
        return true;
    }

    public static void addLibraryToProject(Project project, Library library) {
        ProjectClassPathExtender pcpe = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class);
        if (pcpe != null) {
            try {
                pcpe.addLibrary(library);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    public static String simpleClassName(String fqn) {
        int lastDot = fqn.lastIndexOf(46);
        return lastDot > 0 ? fqn.substring(lastDot + 1) : fqn;
    }
}

