/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.persistence.rules.annotation;

import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.NamedNativeQuery;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;

public class NamedNativeQueryUnique
extends AbstractRule {
    protected String getMessageKey() {
        return "MSG_NamedNativeQueryUnique";
    }

    public String getId() {
        return "NamedNativeQueryUnique";
    }

    protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        Annotation annotation;
        AnnotationType type;
        if (ctx.isIsEntityClass() && (type = (annotation = (Annotation)Annotation.class.cast(subject)).getType()) != null && "javax.persistence.NamedNativeQuery".equals(type.getName())) {
            return super.isApplicable(subject, ctx);
        }
        return false;
    }

    public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (this.isApplicable(subject, ctx)) {
            Annotation annotation = (Annotation)Annotation.class.cast(subject);
            String queryName = NamedNativeQueryUnique.getNameOfQuery(annotation);
            int count = 0;
            if (queryName != null) {
                EntityMappings entityMapping = ctx.getEntityMapping();
                for (NamedNativeQuery namedNativeQuery : entityMapping.getNamedNativeQuery()) {
                    if (queryName.equals(namedNativeQuery.getName())) {
                        ++count;
                    }
                    if (count <= 1) continue;
                    return this.createProblem(ctx, subject);
                }
                for (NamedNativeQuery namedNativeQuery : entityMapping.getEntity()) {
                    for (NamedNativeQuery nq : namedNativeQuery.getNamedNativeQuery()) {
                        if (queryName.equals(nq.getName())) {
                            ++count;
                        }
                        if (count <= 1) continue;
                        return this.createProblem(ctx, subject);
                    }
                }
            }
        }
        return null;
    }

    private static String getNameOfQuery(Annotation entity) {
        for (AttributeValue attrValue : entity.getAttributeValues()) {
            InitialValue value;
            if (!"name".equals(attrValue.getName()) || !((value = attrValue.getValue()) instanceof StringLiteral)) continue;
            return ((StringLiteral)StringLiteral.class.cast(value)).getValue();
        }
        return null;
    }
}

