/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.jmi.reflect.RefObject;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.refactoring.plugins.EncapsulateFieldRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.ui.UIUtilities;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class EncapsulateFieldPanel
extends CustomRefactoringPanel {
    Field[] refactoredObjs;
    DefaultTableModel model;
    RefObject[] selectedObjects;
    ParametersPanel parent;
    private static final String[] modifierNames = new String[]{"public", "protected", "<default>", "private"};
    private static final String[] columnNames = new String[]{EncapsulateFieldPanel.getString("LBL_ColField"), "    ", EncapsulateFieldPanel.getString("LBL_ColGetter"), "    ", EncapsulateFieldPanel.getString("LBL_ColSetter")};
    private static final int MOD_PUBLIC_INDEX = 0;
    private static final int MOD_PROTECTED_INDEX = 1;
    private static final int MOD_DEFAULT_INDEX = 2;
    private static final int MOD_PRIVATE_INDEX = 3;
    private static final Class[] columnTypes = new Class[]{Field.class, Boolean.class, String.class, Boolean.class, String.class};
    private boolean initialized = false;
    private JCheckBox jCheckAccess;
    private JComboBox jComboAccess;
    private JComboBox jComboField;
    private JLabel jLblAccessVis;
    private JLabel jLblFieldVis;
    private JLabel jLblTitle;
    private JScrollPane jScrollField;
    private JTable jTableFields;

    public EncapsulateFieldPanel(RefObject[] selectedObjects, ParametersPanel parent) {
        ClassDefinition cd;
        Feature f;
        String title = EncapsulateFieldPanel.getString("LBL_TitleEncapsulateFields");
        if (selectedObjects.length > 0 && (f = JavaModelUtil.getDeclaringFeature((Element)((Element)selectedObjects[0]))) != null && (cd = f.getDeclaringClass()) instanceof JavaClass) {
            title = title + " - " + ((JavaClass)cd).getName();
        }
        this.selectedObjects = selectedObjects;
        this.parent = parent;
        this.model = new TabM(columnNames, 0);
        this.initComponents();
        this.setName(title);
        this.jTableFields.setDefaultRenderer(Field.class, new UIUtilities.JavaElementTableCellRenderer());
        this.jScrollField.setBackground(this.jTableFields.getBackground());
        this.jScrollField.getViewport().setBackground(this.jTableFields.getBackground());
        this.jTableFields.setRowHeight(18);
        if (UIManager.getColor("control") != null) {
            this.jTableFields.setGridColor(UIManager.getColor("control"));
        }
    }

    public void initialize() {
        int i;
        if (this.initialized) {
            return;
        }
        this.refactoredObjs = this.initFields((Field)this.selectedObjects[0]);
        HashSet<String> selectedNames = new HashSet<String>(this.selectedObjects.length);
        for (i = 0; i < this.selectedObjects.length; ++i) {
            selectedNames.add(((Field)this.selectedObjects[i]).getName());
        }
        for (i = 0; i < this.refactoredObjs.length; ++i) {
            Field field = this.refactoredObjs[i];
            String name = field.getName();
            boolean createGetter = selectedNames.contains(name);
            boolean createSetter = createGetter && !Modifier.isFinal(field.getModifiers());
            this.model.addRow(new Object[]{field, createGetter ? Boolean.TRUE : Boolean.FALSE, createGetter ? EncapsulateFieldRefactoringPlugin.computeGetterName(field) : null, createSetter ? Boolean.TRUE : Boolean.FALSE, createSetter ? EncapsulateFieldRefactoringPlugin.computeSetterName(field) : null});
        }
        this.packRows(this.jTableFields);
        this.jTableFields.getTableHeader().setReorderingAllowed(false);
        this.setColumnWidth(1);
        this.setColumnWidth(3);
        this.jTableFields.invalidate();
        this.jTableFields.repaint();
        this.model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                int col = e.getColumn();
                int row = e.getFirstRow();
                if (col == 1 || col == 3) {
                    Boolean value = (Boolean)EncapsulateFieldPanel.this.model.getValueAt(row, col);
                    if (value.booleanValue()) {
                        if (col == 1) {
                            EncapsulateFieldPanel.this.model.setValueAt(EncapsulateFieldRefactoringPlugin.computeGetterName(EncapsulateFieldPanel.this.refactoredObjs[row]), row, col + 1);
                        } else {
                            EncapsulateFieldPanel.this.model.setValueAt(EncapsulateFieldRefactoringPlugin.computeSetterName(EncapsulateFieldPanel.this.refactoredObjs[row]), row, col + 1);
                        }
                    } else if (EncapsulateFieldPanel.this.model.getValueAt(row, col + 1) != null) {
                        EncapsulateFieldPanel.this.model.setValueAt(null, row, col + 1);
                    }
                } else {
                    String value = (String)EncapsulateFieldPanel.this.model.getValueAt(row, col);
                    if (value == null | "".equals(value)) {
                        EncapsulateFieldPanel.this.model.setValueAt(Boolean.FALSE, row, col - 1);
                    }
                }
                EncapsulateFieldPanel.this.parent.stateChanged(null);
            }
        });
        this.initialized = true;
    }

    private void setColumnWidth(int a) {
        TableColumn col = this.jTableFields.getColumnModel().getColumn(a);
        JCheckBox box = new JCheckBox();
        int width = (int)box.getPreferredSize().getWidth();
        col.setPreferredWidth(width);
        col.setMinWidth(width);
        col.setMaxWidth(width);
        col.setResizable(false);
    }

    private int getMinimumRowHeight(JTable table, int rowIndex) {
        int height = table.getRowHeight();
        for (int c = 0; c < table.getColumnCount(); ++c) {
            TableCellRenderer renderer = table.getCellRenderer(rowIndex, c);
            Component comp = table.prepareRenderer(renderer, rowIndex, c);
            int h = comp.getMinimumSize().height;
            height = Math.max(height, h);
        }
        return height;
    }

    private void packRows(JTable table) {
        int max = 0;
        for (int r = 0; r < table.getRowCount(); ++r) {
            int h = this.getMinimumRowHeight(table, r);
            if (h <= max) continue;
            max = h;
        }
        table.setRowHeight(max);
        table.getTableHeader().setPreferredSize(new Dimension(table.getTableHeader().getPreferredSize().width, max));
    }

    protected DefaultTableModel getTableModel() {
        return this.model;
    }

    private void initComponents() {
        this.jLblTitle = new JLabel();
        this.jScrollField = new JScrollPane();
        this.jTableFields = new JTable();
        this.jLblFieldVis = new JLabel();
        this.jComboField = new JComboBox();
        this.jLblAccessVis = new JLabel();
        this.jComboAccess = new JComboBox();
        this.jCheckAccess = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.jLblTitle.setLabelFor(this.jTableFields);
        Mnemonics.setLocalizedText((JLabel)this.jLblTitle, (String)EncapsulateFieldPanel.getString("LBL_FieldList"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLblTitle, gridBagConstraints);
        this.jScrollField.setPreferredSize(new Dimension(300, 200));
        this.jTableFields.setModel(this.model);
        this.jScrollField.setViewportView(this.jTableFields);
        this.jTableFields.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("ACSD_jTableFields"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 12, 2);
        this.add((Component)this.jScrollField, gridBagConstraints);
        this.jLblFieldVis.setLabelFor(this.jComboField);
        Mnemonics.setLocalizedText((JLabel)this.jLblFieldVis, (String)EncapsulateFieldPanel.getString("LBL_FieldVis"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 5, 5);
        this.add((Component)this.jLblFieldVis, gridBagConstraints);
        this.jComboField.setModel(new DefaultComboBoxModel<String>(modifierNames));
        this.jComboField.setSelectedIndex(3);
        this.jComboField.setPreferredSize(new Dimension(100, 23));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jComboField, gridBagConstraints);
        this.jComboField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("ACSD_fieldModifiers"));
        this.jLblAccessVis.setLabelFor(this.jComboAccess);
        Mnemonics.setLocalizedText((JLabel)this.jLblAccessVis, (String)EncapsulateFieldPanel.getString("LBL_AccessVis"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add((Component)this.jLblAccessVis, gridBagConstraints);
        this.jComboAccess.setModel(new DefaultComboBoxModel<String>(modifierNames));
        this.jComboAccess.setSelectedIndex(0);
        this.jComboAccess.setPreferredSize(new Dimension(100, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jComboAccess, gridBagConstraints);
        this.jComboAccess.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("ACSD_methodAcc"));
        this.jCheckAccess.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckAccess, (String)EncapsulateFieldPanel.getString("LBL_AccessorsEven"));
        this.jCheckAccess.setMargin(new Insets(12, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.jCheckAccess, gridBagConstraints);
        this.jCheckAccess.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/refactoring/ui/Bundle").getString("ACSD_useAccessors"));
    }

    private static String getString(String key) {
        return NbBundle.getMessage((Class)EncapsulateFieldPanel.class, (String)key);
    }

    private Field[] initFields(Field selectedField) {
        ClassDefinition cd = selectedField.getDeclaringClass();
        ArrayList result = new ArrayList();
        List features = cd.getFeatures();
        Iterator it = features.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Field) || o instanceof EnumConstant) continue;
            result.add(o);
        }
        return result.toArray(new Field[0]);
    }

    public Field[] getAllFields() {
        return this.refactoredObjs;
    }

    public boolean isCheckAccess() {
        return this.jCheckAccess.isSelected();
    }

    protected int[] getModifiers() {
        int[] result = new int[2];
        JComboBox combo = this.jComboAccess;
        for (int i = 0; i < 2; ++i) {
            switch (combo.getSelectedIndex()) {
                case 3: {
                    result[i] = 2;
                    break;
                }
                case 2: {
                    result[i] = 0;
                    break;
                }
                case 1: {
                    result[i] = 4;
                    break;
                }
                case 0: {
                    result[i] = 1;
                }
            }
            combo = this.jComboField;
        }
        return result;
    }

    private static class TabM
    extends DefaultTableModel {
        public TabM(Object[] columnNames, int rowCount) {
            super(columnNames, rowCount);
        }

        public Class getColumnClass(int columnIndex) {
            return columnTypes[columnIndex];
        }

        public boolean isCellEditable(int row, int column) {
            if (column == 0) {
                return false;
            }
            if (column == 1 || column == 3) {
                return true;
            }
            return (Boolean)this.getValueAt(row, column - 1);
        }
    }
}

